/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.compensation;

import io.camunda.zeebe.engine.processing.deployment.model.validation.ExpectedValidationResult;
import io.camunda.zeebe.engine.processing.deployment.model.validation.ProcessValidationUtil;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractStartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.AbstractThrowEventBuilder;
import io.camunda.zeebe.model.bpmn.instance.BoundaryEvent;
import io.camunda.zeebe.model.bpmn.instance.EndEvent;
import io.camunda.zeebe.model.bpmn.instance.IntermediateThrowEvent;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import io.camunda.zeebe.model.bpmn.instance.Task;
import java.io.InputStream;
import org.junit.jupiter.api.Test;

public class CompensationEventTest {
    @Test
    public void shouldDeployCompensationBoundaryEvent() {
        BpmnModelInstance process = this.createModelFromClasspathResource("/compensation/compensation-boundary-event.bpmn");
        ProcessValidationUtil.validateProcess(process);
    }

    @Test
    public void shouldNotDeployCompensationBoundaryEventWithoutAssociation() {
        BpmnModelInstance process = this.createModelFromClasspathResource("/compensation/compensation-boundary-event-no-association.bpmn");
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(BoundaryEvent.class, "Must have at least one outgoing sequence flow or association"));
    }

    @Test
    public void shouldDeployCompensationIntermediateThrowEvent() {
        BpmnModelInstance process = this.createModelFromClasspathResource("/compensation/compensation-throw-event.bpmn");
        ProcessValidationUtil.validateProcess(process);
    }

    @Test
    public void shouldNotDeployCompensationIntermediateThrowEventWithWaitForCompletionFalse() {
        BpmnModelInstance process = this.createModelFromClasspathResource("/compensation/compensation-throw-event-attribute-false.bpmn");
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(IntermediateThrowEvent.class, "A compensation intermediate throwing event waitForCompletion attribute must be true or not present"));
    }

    @Test
    public void shouldDeployCompensationEndEvent() {
        BpmnModelInstance process = this.createModelFromClasspathResource("/compensation/compensation-end-event.bpmn");
        ProcessValidationUtil.validateProcess(process);
    }

    @Test
    public void shouldNotDeployCompensationEndEventWithWaitForCompletionFalse() {
        BpmnModelInstance process = this.createModelFromClasspathResource("/compensation/compensation-end-event-attribute-false.bpmn");
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(EndEvent.class, "A compensation end event waitForCompletion attribute must be true or not present"));
    }

    @Test
    public void shouldDeployCompensationUndefinedTask() {
        BpmnModelInstance process = this.createModelFromClasspathResource("/compensation/compensation-undefined-task.bpmn");
        ProcessValidationUtil.validateProcess(process);
    }

    @Test
    public void shouldNotDeployCompensationHandlerNotValid() {
        BpmnModelInstance process = this.createModelFromClasspathResource("/compensation/compensation-not-valid-task.bpmn");
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(Task.class, "Compensation task must be one of: service task, user task, send task, script task, manual task, or undefined task"));
    }

    @Test
    public void shouldNotDeployCompensationHandlerWithOutgoingFlow() {
        BpmnModelInstance process = this.createModelFromClasspathResource("/compensation/compensation-task-with-outgoing.bpmn");
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(Task.class, "A compensation handler should have no outgoing sequence flows"));
    }

    @Test
    public void shouldNotDeployCompensationHandlerWithIncomingFlow() {
        BpmnModelInstance process = this.createModelFromClasspathResource("/compensation/compensation-task-with-incoming.bpmn");
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(Task.class, "A compensation handler should have no incoming sequence flows"));
    }

    @Test
    public void shouldNotDeployCompensationHandlerWithBoundaryEvent() {
        BpmnModelInstance process = this.createModelFromClasspathResource("/compensation/compensation-task-with-boundary.bpmn");
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(Task.class, "A compensation handler should have no boundary events"));
    }

    @Test
    public void shouldDeployCompensationEventSubprocess() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"compensation-process").startEvent().subProcess("embedded-subprocess", s -> s.embeddedSubProcess().eventSubProcess("subprocess", eventSubProcess -> eventSubProcess.startEvent("compensation-start", AbstractStartEventBuilder::compensation).intermediateThrowEvent("compensation-throw-event", AbstractThrowEventBuilder::compensateEventDefinition).userTask("B").endEvent()).startEvent().userTask("A").boundaryEvent().compensation(c -> c.userTask("undo-A")).endEvent().done()).endEvent("compensation-end-event", end -> end.compensateEventDefinition().compensateEventDefinitionDone()).done();
        ProcessValidationUtil.validateProcess(process);
    }

    @Test
    public void shouldNotDeployCompensationEventSubprocessOnProcessLevel() {
        BpmnModelInstance process = this.createModelFromClasspathResource("/compensation/compensation-not-embedded-subprocess.bpmn");
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(SubProcess.class, "A compensation event subprocess is not allowed on the process level"));
    }

    private BpmnModelInstance createModelFromClasspathResource(String classpath) {
        InputStream resourceAsStream = this.getClass().getResourceAsStream(classpath);
        return Bpmn.readModelFromStream((InputStream)resourceAsStream);
    }
}

