/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.gateway;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.EventBasedGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.test.util.record.TimerRecordStream;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class EventBasedGatewayConcurrencyTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition().maxCommandsInBatch(1);
    private static final BpmnModelInstance PROCESS_WITH_EQUAL_TIMERS = ((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)((EventBasedGatewayBuilder)Bpmn.createExecutableProcess((String)"PROCESS_WITH_EQUAL_TIMERS").startEvent("start").eventBasedGateway().id("gateway")).intermediateCatchEvent("timer-1", c -> c.timerWithDuration("PT2S")).sequenceFlowId("to-end1")).endEvent("end1").moveToLastGateway().intermediateCatchEvent("timer-2", c -> c.timerWithDuration("PT2S")).sequenceFlowId("to-end2")).endEvent("end2").done();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @BeforeClass
    public static void init() {
        ENGINE.deployment().withXmlResource(PROCESS_WITH_EQUAL_TIMERS).deploy();
    }

    @Test
    public void shouldOnlyExecuteOneBranchWithEqualTimers() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS_WITH_EQUAL_TIMERS").create();
        Assertions.assertThat((long)((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).limit(2L)).count()).isEqualTo(2L);
        ENGINE.increaseTime(Duration.ofSeconds(2L));
        List timers = ((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).map(r -> ((TimerRecordValue)r.getValue()).getTargetElementId()).collect(Collectors.toList());
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withHandlerNodeId((String)timers.get(0)).withProcessInstanceKey(processInstanceKey).exists()).isTrue();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGER).withHandlerNodeId((String)timers.get(1)).withProcessInstanceKey(processInstanceKey).onlyCommandRejections()).getFirst())).hasRejectionType(RejectionType.INVALID_STATE).hasRecordType(RecordType.COMMAND_REJECTION);
    }
}

