/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DecisionIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionRequirementsIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsMetadataValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsRecordValue;
import io.camunda.zeebe.test.util.record.DecisionRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.Rule;
import org.junit.Test;

public final class DmnDeploymentTest {
    private static final String DMN_DECISION_TABLE = "/dmn/decision-table.dmn";
    private static final String DMN_DECISION_TABLE_V2 = "/dmn/decision-table_v2.dmn";
    private static final String DMN_DECISION_TABLE_RENAMED_DRG = "/dmn/decision-table-with-renamed-drg.dmn";
    private static final String DMN_DECISION_TABLE_RENAMED_DRG_AND_DECISION = "/dmn/decision-table-with-renamed-drg-and-decision.dmn";
    private static final String DMN_INVALID_EXPRESSION = "/dmn/decision-table-with-invalid-expression.dmn";
    private static final String DMN_WITH_TWO_DECISIONS = "/dmn/drg-force-user.dmn";
    private static final String DMN_MISSING_DECISION_NAME = "/dmn/decision-table-with-missing-decision-name.dmn";
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldDeployDmnResource() {
        String tenant = "tenant";
        Record<DeploymentRecordValue> deploymentEvent = this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).withTenantId("tenant").deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentEvent).hasIntent((Intent)DeploymentIntent.CREATED).hasValueType(ValueType.DEPLOYMENT).hasRecordType(RecordType.EVENT);
        this.verifyDeploymentForTenant(deploymentEvent, "tenant");
    }

    @Test
    public void shouldDeployDmnResourceForTenants() {
        String tenant = "tenant";
        String tenant2 = "tenant2";
        Record<DeploymentRecordValue> deploymentEvent = this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).withTenantId("tenant").deploy();
        Record<DeploymentRecordValue> deploymentEvent2 = this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).withTenantId("tenant2").deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentEvent).hasIntent((Intent)DeploymentIntent.CREATED).hasValueType(ValueType.DEPLOYMENT).hasRecordType(RecordType.EVENT);
        this.verifyDeploymentForTenant(deploymentEvent, "tenant");
        this.verifyDeploymentForTenant(deploymentEvent2, "tenant2");
    }

    @Test
    public void shouldRejectInvalidDmnResource() {
        Record<DeploymentRecordValue> deploymentEvent = this.engine.deployment().withXmlClasspathResource(DMN_INVALID_EXPRESSION).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentEvent).hasIntent((Intent)DeploymentIntent.CREATE).hasRecordType(RecordType.COMMAND_REJECTION).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)deploymentEvent.getRejectionReason()).contains(new CharSequence[]{"FEEL unary-tests: failed to parse expression"});
    }

    @Test
    public void shouldRejectDmnResourceWithMissingDecisionName() {
        Record<DeploymentRecordValue> deploymentEvent = this.engine.deployment().withXmlClasspathResource(DMN_MISSING_DECISION_NAME).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentEvent).hasIntent((Intent)DeploymentIntent.CREATE).hasRecordType(RecordType.COMMAND_REJECTION).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)deploymentEvent.getRejectionReason()).contains(new CharSequence[]{"because \"value\" is null"});
    }

    @Test
    public void shouldWriteDecisionRequirementsRecord() {
        this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        Record record = (Record)RecordingExporter.decisionRequirementsRecords().getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)record).hasIntent((Intent)DecisionRequirementsIntent.CREATED).hasValueType(ValueType.DECISION_REQUIREMENTS).hasRecordType(RecordType.EVENT);
        Assertions.assertThat((long)record.getKey()).isPositive();
        DecisionRequirementsRecordValue decisionRequirementsRecord = (DecisionRequirementsRecordValue)record.getValue();
        Assertions.assertThat((String)decisionRequirementsRecord.getDecisionRequirementsId()).isEqualTo("force_users");
        Assertions.assertThat((String)decisionRequirementsRecord.getDecisionRequirementsName()).isEqualTo("Force Users");
        Assertions.assertThat((long)decisionRequirementsRecord.getDecisionRequirementsKey()).isPositive();
        Assertions.assertThat((int)decisionRequirementsRecord.getDecisionRequirementsVersion()).isEqualTo(1);
        Assertions.assertThat((String)decisionRequirementsRecord.getNamespace()).isEqualTo("http://camunda.org/schema/1.0/dmn");
        Assertions.assertThat((String)decisionRequirementsRecord.getResourceName()).isEqualTo(DMN_DECISION_TABLE);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])decisionRequirementsRecord.getChecksum()).describedAs("Expect the MD5 checksum of the DMN resource", new Object[0])).isEqualTo((Object)this.getChecksum(DMN_DECISION_TABLE));
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])decisionRequirementsRecord.getResource()).describedAs("Expect the same content as the DMN resource", new Object[0])).isEqualTo((Object)this.readResource(DMN_DECISION_TABLE));
    }

    @Test
    public void shouldWriteDecisionRecord() {
        this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        Record record = (Record)RecordingExporter.decisionRecords().getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)record).hasIntent((Intent)DecisionIntent.CREATED).hasValueType(ValueType.DECISION).hasRecordType(RecordType.EVENT);
        Assertions.assertThat((long)record.getKey()).isPositive();
        DecisionRecordValue decisionRecord = (DecisionRecordValue)record.getValue();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionRecordValue)decisionRecord).hasDecisionId("jedi_or_sith").hasDecisionName("Jedi or Sith").hasDecisionRequirementsId("force_users").hasVersion(1);
        Assertions.assertThat((long)decisionRecord.getDecisionKey()).isPositive();
        Assertions.assertThat((long)decisionRecord.getDecisionRequirementsKey()).isPositive();
    }

    @Test
    public void shouldWriteOneRecordForEachDecision() {
        this.engine.deployment().withXmlClasspathResource(DMN_WITH_TWO_DECISIONS).deploy();
        Record decisionRequirementsRecord = (Record)RecordingExporter.decisionRequirementsRecords().getFirst();
        String decisionRequirementsId = ((DecisionRequirementsRecordValue)decisionRequirementsRecord.getValue()).getDecisionRequirementsId();
        long decisionRequirementsKey = ((DecisionRequirementsRecordValue)decisionRequirementsRecord.getValue()).getDecisionRequirementsKey();
        List decisionRecords = ((DecisionRecordStream)RecordingExporter.decisionRecords().limit(2L)).asList();
        ((ListAssert)Assertions.assertThat((List)decisionRecords).hasSize(2)).extracting(Record::getValue).extracting(new Function[]{DecisionRecordValue::getDecisionId, DecisionRecordValue::getDecisionName}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"jedi_or_sith", "Jedi or Sith"}), Assertions.tuple((Object[])new Object[]{"force_user", "Which force user?"})});
        Assertions.assertThat((List)decisionRecords).extracting(Record::getValue).allSatisfy(record -> {
            Assertions.assertThat((String)record.getDecisionRequirementsId()).isEqualTo(decisionRequirementsId);
            Assertions.assertThat((long)record.getDecisionRequirementsKey()).isEqualTo(decisionRequirementsKey);
        });
        ((AbstractLongAssert)Assertions.assertThat((long)((Record)decisionRecords.get(0)).getKey()).describedAs("Expect that the decision records have different keys", new Object[0])).isNotEqualTo(((Record)decisionRecords.get(1)).getKey());
    }

    @Test
    public void shouldDeployNewVersion() {
        this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        Record<DeploymentRecordValue> deploymentEvent = this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE_V2).deploy();
        Assertions.assertThat((List)((DeploymentRecordValue)deploymentEvent.getValue()).getDecisionRequirementsMetadata()).extracting(DecisionRequirementsMetadataValue::getDecisionRequirementsVersion).describedAs("Expect that the DRG version is increased", new Object[0]).containsExactly((Object[])new Integer[]{2});
        Assertions.assertThat((List)((DeploymentRecordValue)deploymentEvent.getValue()).getDecisionsMetadata()).extracting(DecisionRecordValue::getVersion).describedAs("Expect that the decision version is increased", new Object[0]).containsExactly((Object[])new Integer[]{2});
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.decisionRequirementsRecords().limit(2L)).hasSize(2)).extracting(Record::getValue).extracting(new Function[]{DecisionRequirementsMetadataValue::getDecisionRequirementsId, DecisionRequirementsMetadataValue::getDecisionRequirementsVersion}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"force_users", 1}), Assertions.tuple((Object[])new Object[]{"force_users", 2})});
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.decisionRecords().limit(2L)).hasSize(2)).extracting(Record::getValue).extracting(new Function[]{DecisionRecordValue::getDecisionId, DecisionRecordValue::getVersion}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"jedi_or_sith", 1}), Assertions.tuple((Object[])new Object[]{"jedi_or_sith", 2})});
    }

    @Test
    public void shouldDeployDuplicate() {
        Record<DeploymentRecordValue> firstDeployment = this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        DecisionRequirementsMetadataValue drgV1 = (DecisionRequirementsMetadataValue)((DeploymentRecordValue)firstDeployment.getValue()).getDecisionRequirementsMetadata().get(0);
        DecisionRecordValue decisionV1 = (DecisionRecordValue)((DeploymentRecordValue)firstDeployment.getValue()).getDecisionsMetadata().get(0);
        Record<DeploymentRecordValue> secondDeployment = this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        Assertions.assertThat((List)((DeploymentRecordValue)secondDeployment.getValue()).getDecisionRequirementsMetadata()).hasSize(1);
        DecisionRequirementsMetadataValue drgMetadata = (DecisionRequirementsMetadataValue)((DeploymentRecordValue)secondDeployment.getValue()).getDecisionRequirementsMetadata().get(0);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionRequirementsMetadataValue)drgMetadata).hasDecisionRequirementsVersion(1).hasDecisionRequirementsKey(drgV1.getDecisionRequirementsKey()).isDuplicate();
        Assertions.assertThat((List)((DeploymentRecordValue)secondDeployment.getValue()).getDecisionsMetadata()).hasSize(1);
        DecisionRecordValue decisionMetadata = (DecisionRecordValue)((DeploymentRecordValue)secondDeployment.getValue()).getDecisionsMetadata().get(0);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionRecordValue)decisionMetadata).hasVersion(1).hasDecisionKey(decisionV1.getDecisionKey()).hasDecisionRequirementsKey(drgV1.getDecisionRequirementsKey()).isDuplicate();
    }

    @Test
    public void shouldOmitRecordsForDuplicate() {
        this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE_V2).deploy();
        Assertions.assertThat((Stream)RecordingExporter.decisionRequirementsRecords().limit(2L)).extracting(Record::getValue).extracting(DecisionRequirementsMetadataValue::getDecisionRequirementsVersion).describedAs("Expect to omit decision requirements record for duplicate", new Object[0]).containsExactly((Object[])new Integer[]{1, 2});
        Assertions.assertThat((Stream)RecordingExporter.decisionRecords().limit(2L)).extracting(Record::getValue).extracting(DecisionRecordValue::getVersion).describedAs("Expect to omit decision record for duplicate", new Object[0]).containsExactly((Object[])new Integer[]{1, 2});
    }

    @Test
    public void shouldDeployNewVersionIfResourceNameDiffers() {
        byte[] dmnResource = this.readResource(DMN_DECISION_TABLE);
        this.engine.deployment().withXmlResource(dmnResource, "decision-table.dmn").deploy();
        Record<DeploymentRecordValue> deploymentEvent = this.engine.deployment().withXmlResource(dmnResource, "renamed-decision-table.dmn").deploy();
        Assertions.assertThat((List)((DeploymentRecordValue)deploymentEvent.getValue()).getDecisionRequirementsMetadata()).extracting(DecisionRequirementsMetadataValue::getDecisionRequirementsVersion).describedAs("Expect that the DRG version is increased", new Object[0]).containsExactly((Object[])new Integer[]{2});
        Assertions.assertThat((List)((DeploymentRecordValue)deploymentEvent.getValue()).getDecisionsMetadata()).extracting(DecisionRecordValue::getVersion).describedAs("Expect that the decision version is increased", new Object[0]).containsExactly((Object[])new Integer[]{2});
    }

    @Test
    public void shouldDeployNewVersionIfDrgIdDiffers() {
        this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE_RENAMED_DRG).deploy();
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.decisionRequirementsRecords().limit(2L)).hasSize(2)).extracting(Record::getValue).extracting(new Function[]{DecisionRequirementsMetadataValue::getDecisionRequirementsId, DecisionRequirementsMetadataValue::getDecisionRequirementsVersion}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"force_users", 1}), Assertions.tuple((Object[])new Object[]{"star-wars", 1})});
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.decisionRecords().limit(2L)).hasSize(2)).extracting(Record::getValue).extracting(new Function[]{DecisionRecordValue::getDecisionId, DecisionRecordValue::getVersion}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"jedi_or_sith", 1}), Assertions.tuple((Object[])new Object[]{"jedi_or_sith", 2})});
    }

    @Test
    public void shouldDeployDecisionWithTwoDrg() {
        this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE_RENAMED_DRG).deploy();
        Record<DeploymentRecordValue> deploymentEvent = this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        Assertions.assertThat((List)((DeploymentRecordValue)deploymentEvent.getValue()).getDecisionRequirementsMetadata()).extracting(new Function[]{DecisionRequirementsMetadataValue::getDecisionRequirementsVersion, DecisionRequirementsMetadataValue::isDuplicate}).describedAs("Expect that the DRG version is increased", new Object[0]).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{2, false})});
        Assertions.assertThat((List)((DeploymentRecordValue)deploymentEvent.getValue()).getDecisionsMetadata()).extracting(new Function[]{DecisionRecordValue::getVersion, DecisionRecordValue::isDuplicate}).describedAs("Expect that the decision version is increased", new Object[0]).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{3, false})});
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.decisionRecords().limit(3L)).hasSize(3)).extracting(Record::getValue).extracting(new Function[]{DecisionRecordValue::getDecisionId, DecisionRecordValue::getVersion, DecisionRecordValue::getDecisionRequirementsId}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"jedi_or_sith", 1, "force_users"}), Assertions.tuple((Object[])new Object[]{"jedi_or_sith", 2, "star-wars"}), Assertions.tuple((Object[])new Object[]{"jedi_or_sith", 3, "force_users"})});
    }

    @Test
    public void shouldDeployIfMultipleDrgHaveDifferentId() {
        Record<DeploymentRecordValue> deploymentEvent = this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).withXmlClasspathResource(DMN_DECISION_TABLE_RENAMED_DRG_AND_DECISION).deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentEvent).hasIntent((Intent)DeploymentIntent.CREATED).hasValueType(ValueType.DEPLOYMENT).hasRecordType(RecordType.EVENT);
        Assertions.assertThat((List)((DeploymentRecordValue)deploymentEvent.getValue()).getDecisionRequirementsMetadata()).hasSize(2);
        DecisionRequirementsMetadataValue drgMetadata = (DecisionRequirementsMetadataValue)((DeploymentRecordValue)deploymentEvent.getValue()).getDecisionRequirementsMetadata().get(0);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionRequirementsMetadataValue)drgMetadata).hasDecisionRequirementsId("force_users");
        Assertions.assertThat((long)drgMetadata.getDecisionRequirementsKey()).isPositive();
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])drgMetadata.getChecksum()).describedAs("Expect the MD5 checksum of the DMN resource", new Object[0])).isEqualTo((Object)this.getChecksum(DMN_DECISION_TABLE));
        Assertions.assertThat((List)((DeploymentRecordValue)deploymentEvent.getValue()).getDecisionsMetadata()).hasSize(2);
        DecisionRecordValue decisionMetadata = (DecisionRecordValue)((DeploymentRecordValue)deploymentEvent.getValue()).getDecisionsMetadata().get(0);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionRecordValue)decisionMetadata).hasDecisionId("jedi_or_sith").hasDecisionRequirementsKey(drgMetadata.getDecisionRequirementsKey());
        Assertions.assertThat((long)decisionMetadata.getDecisionKey()).isPositive();
        DecisionRequirementsMetadataValue drgMetadata2 = (DecisionRequirementsMetadataValue)((DeploymentRecordValue)deploymentEvent.getValue()).getDecisionRequirementsMetadata().get(1);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionRequirementsMetadataValue)drgMetadata2).hasDecisionRequirementsId("star-wars");
        Assertions.assertThat((long)drgMetadata2.getDecisionRequirementsKey()).isPositive();
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])drgMetadata2.getChecksum()).describedAs("Expect the MD5 checksum of the DMN resource", new Object[0])).isEqualTo((Object)this.getChecksum(DMN_DECISION_TABLE_RENAMED_DRG_AND_DECISION));
        Assertions.assertThat((List)((DeploymentRecordValue)deploymentEvent.getValue()).getDecisionsMetadata()).hasSize(2);
        DecisionRecordValue decisionMetadata2 = (DecisionRecordValue)((DeploymentRecordValue)deploymentEvent.getValue()).getDecisionsMetadata().get(1);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionRecordValue)decisionMetadata2).hasDecisionId("sith_or_jedi").hasDecisionRequirementsKey(drgMetadata2.getDecisionRequirementsKey());
        Assertions.assertThat((long)decisionMetadata2.getDecisionKey()).isPositive();
    }

    @Test
    public void shouldRejectIfMultipleDrgHaveTheSameId() {
        Record<DeploymentRecordValue> deploymentEvent = this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).withXmlClasspathResource(DMN_DECISION_TABLE_V2).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentEvent).hasIntent((Intent)DeploymentIntent.CREATE).hasRecordType(RecordType.COMMAND_REJECTION).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)deploymentEvent.getRejectionReason()).contains(new CharSequence[]{String.format("Expected the decision requirements ids to be unique within a deployment but found a duplicated id 'force_users' in the resources '%s' and '%s'", DMN_DECISION_TABLE, DMN_DECISION_TABLE_V2)});
    }

    @Test
    public void shouldRejectIfMultipleDecisionsHaveTheSameId() {
        Record<DeploymentRecordValue> deploymentEvent = this.engine.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).withXmlClasspathResource(DMN_DECISION_TABLE_RENAMED_DRG).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentEvent).hasIntent((Intent)DeploymentIntent.CREATE).hasRecordType(RecordType.COMMAND_REJECTION).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)deploymentEvent.getRejectionReason()).contains(new CharSequence[]{String.format("Expected the decision ids to be unique within a deployment but found a duplicated id 'jedi_or_sith' in the resources '%s' and '%s'", DMN_DECISION_TABLE, DMN_DECISION_TABLE_RENAMED_DRG)});
    }

    private byte[] getChecksum(String resourceName) {
        byte[] checksum = new byte[]{};
        try {
            byte[] resource = this.readResource(resourceName);
            MessageDigest digestGenerator = MessageDigest.getInstance("MD5");
            checksum = digestGenerator.digest(resource);
        }
        catch (NoSuchAlgorithmException e) {
            Assertions.fail((String)"Failed to calculate the checksum", (Throwable)e);
        }
        return checksum;
    }

    private byte[] readResource(String resourceName) {
        InputStream resourceAsStream = this.getClass().getResourceAsStream(resourceName);
        Assertions.assertThat((InputStream)resourceAsStream).isNotNull();
        try {
            return resourceAsStream.readAllBytes();
        }
        catch (IOException e) {
            Assertions.fail((String)"Failed to read resource '{}'", (Object[])new Object[]{resourceName, e});
            return new byte[0];
        }
    }

    private void verifyDeploymentForTenant(Record<DeploymentRecordValue> deploymentEvent, String tenant) {
        Assertions.assertThat((List)((DeploymentRecordValue)deploymentEvent.getValue()).getDecisionRequirementsMetadata()).hasSize(1);
        DecisionRequirementsMetadataValue drgMetadata = (DecisionRequirementsMetadataValue)((DeploymentRecordValue)deploymentEvent.getValue()).getDecisionRequirementsMetadata().get(0);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionRequirementsMetadataValue)drgMetadata).hasDecisionRequirementsId("force_users").hasDecisionRequirementsName("Force Users").hasDecisionRequirementsVersion(1).hasNamespace("http://camunda.org/schema/1.0/dmn").hasResourceName(DMN_DECISION_TABLE).hasTenantId(tenant).isNotDuplicate();
        Assertions.assertThat((long)drgMetadata.getDecisionRequirementsKey()).isPositive();
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])drgMetadata.getChecksum()).describedAs("Expect the MD5 checksum of the DMN resource", new Object[0])).isEqualTo((Object)this.getChecksum(DMN_DECISION_TABLE));
        Assertions.assertThat((List)((DeploymentRecordValue)deploymentEvent.getValue()).getDecisionsMetadata()).hasSize(1);
        DecisionRecordValue decisionMetadata = (DecisionRecordValue)((DeploymentRecordValue)deploymentEvent.getValue()).getDecisionsMetadata().get(0);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionRecordValue)decisionMetadata).hasDecisionId("jedi_or_sith").hasDecisionName("Jedi or Sith").hasDecisionRequirementsId("force_users").hasVersion(1).hasDecisionRequirementsId("force_users").hasDecisionRequirementsKey(drgMetadata.getDecisionRequirementsKey()).hasTenantId(tenant).isNotDuplicate();
        Assertions.assertThat((long)decisionMetadata.getDecisionKey()).isPositive();
    }
}

