/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.util.ByteValue;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Rule;
import org.junit.Test;

public class MultiPartitionRejectionTest {
    @Rule
    public final EngineRule engine = EngineRule.multiplePartition(3);

    @Test
    public void shouldRejectDeploymentIfResourceIsTooLarge() {
        Record<DeploymentRecordValue> deploymentRejection = this.engine.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"PROCESS").startEvent().documentation("x".repeat((int)(ByteValue.ofMegabytes((long)2L) - ByteValue.ofKilobytes((long)1L)))).done()).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentRejection).hasRejectionType(RejectionType.EXCEEDED_BATCH_RECORD_SIZE).hasRejectionReason("");
    }

    @Test
    public void shouldNotBeAbleToCreateInstanceWhenDeploymentIsRejected() {
        BpmnModelInstance invalidProcess = Bpmn.createExecutableProcess((String)"too_large_process").startEvent().documentation("x".repeat((int)(ByteValue.ofMegabytes((long)2L) - ByteValue.ofKilobytes((long)2L)))).done();
        BpmnModelInstance validProcess = Bpmn.createExecutableProcess((String)"valid_process").startEvent().task().endEvent().done();
        this.engine.deployment().withXmlResource(invalidProcess).withXmlResource(validProcess).expectRejection().deploy();
        Assertions.assertThat((List)((List)((RecordStream)RecordingExporter.records().limit(r -> r.getRecordType() == RecordType.COMMAND_REJECTION)).collect(Collectors.toList()))).extracting(new Function[]{Record::getIntent, Record::getRecordType}).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ProcessIntent.CREATED, RecordType.EVENT}), Assertions.tuple((Object[])new Object[]{DeploymentIntent.CREATED, RecordType.EVENT})});
        this.engine.processInstance().ofBpmnProcessId("valid_process").expectRejection().create();
    }
}

