/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.BpmnModelElementInstance;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.validation.ValidationResult;
import org.camunda.bpm.model.xml.validation.ValidationResultType;

public final class ExpectedValidationResult {
    private String expectedElementId;
    private Class<? extends BpmnModelElementInstance> expectedElementType;
    private String expectedMessage;
    private ValidationResultType expectedType;

    public static ExpectedValidationResult expect(String elementId, String message) {
        ExpectedValidationResult result = new ExpectedValidationResult();
        result.expectedElementId = elementId;
        result.expectedMessage = message;
        result.expectedType = ValidationResultType.ERROR;
        return result;
    }

    public static ExpectedValidationResult expect(Class<? extends BpmnModelElementInstance> elementType, String message) {
        ExpectedValidationResult result = new ExpectedValidationResult();
        result.expectedElementType = elementType;
        result.expectedMessage = message;
        result.expectedType = ValidationResultType.ERROR;
        return result;
    }

    public boolean matches(ValidationResult result) {
        boolean match = true;
        ModelElementInstance element = result.getElement();
        if (this.expectedElementId != null) {
            if (element instanceof BaseElement) {
                if (!((BaseElement)element).getId().equals(this.expectedElementId)) {
                    match = false;
                }
            } else {
                match = false;
            }
        }
        if (this.expectedElementType != null && !this.expectedElementType.isAssignableFrom(element.getClass())) {
            match = false;
        }
        if (!result.getMessage().startsWith(this.expectedMessage)) {
            match = false;
        }
        if (this.expectedType != result.getType()) {
            match = false;
        }
        return match;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.expectedType);
        sb.append(": {");
        if (this.expectedElementId != null) {
            sb.append("id: ");
            sb.append(this.expectedElementId);
            sb.append(", ");
        }
        if (this.expectedElementType != null) {
            sb.append("type: ");
            sb.append(this.expectedElementType.getSimpleName());
            sb.append(", ");
        }
        sb.append("message: ");
        sb.append(this.expectedMessage);
        sb.append("}");
        return sb.toString();
    }

    public static String toString(ValidationResult result) {
        ModelElementInstance element = result.getElement();
        StringBuilder sb = new StringBuilder();
        sb.append(result.getType());
        sb.append(": {");
        if (element instanceof BaseElement) {
            sb.append("id: ");
            sb.append(((BaseElement)element).getId());
            sb.append(", ");
        }
        sb.append("type: ");
        sb.append(element.getElementType().getInstanceType().getSimpleName());
        sb.append(", ");
        sb.append("message: ");
        sb.append(result.getMessage());
        sb.append("}");
        return sb.toString();
    }
}

