/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.util.FeatureFlags;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class StraightThroughProcessingLoopValidationDisabledTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition().withFeatureFlags(new FeatureFlags(true, false, true, true, false, false));
    @Rule
    public final RecordingExporterTestWatcher recordingExporter = new RecordingExporterTestWatcher();

    @Test
    public void shouldDeployProcessWithRegularLoops() {
        String processId = Strings.newRandomValidBpmnId();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().task("task1").task("task2").connectTo("task1").done()).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment.getKey()).describedAs("Don't reject loops if FeatureFlag is disabled", new Object[0])).isNotNegative();
    }
}

