/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.processing.job.JobBackoffChecker;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValueAssert;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.JobBatchRecordStream;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class FailJobTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static String jobType;
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Before
    public void setup() {
        jobType = Strings.newRandomValidBpmnId();
    }

    @Test
    public void shouldFail() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        JobRecordValue job = (JobRecordValue)((JobBatchRecordValue)batchRecord.getValue()).getJobs().get(0);
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        int retries = 23;
        Record<JobRecordValue> failRecord = ENGINE.job().withKey(jobKey).ofInstance(job.getProcessInstanceKey()).withRetries(23).fail();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(failRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.FAILED);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)failRecord.getValue())).hasWorker(job.getWorker()).hasType(job.getType()).hasRetries(23).hasDeadline(job.getDeadline());
    }

    @Test
    public void shouldFailWithMessage() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        JobRecordValue job = (JobRecordValue)((JobBatchRecordValue)batchRecord.getValue()).getJobs().get(0);
        int retries = 23;
        Record<JobRecordValue> failedRecord = ENGINE.job().withKey(jobKey).ofInstance(job.getProcessInstanceKey()).withRetries(23).withErrorMessage("failed job").fail();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(failedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.FAILED);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)failedRecord.getValue())).hasWorker(job.getWorker()).hasType(job.getType()).hasRetries(23).hasDeadline(job.getDeadline()).hasErrorMessage(((JobRecordValue)failedRecord.getValue()).getErrorMessage());
    }

    @Test
    public void shouldFailJobAndRetry() {
        Record<JobRecordValue> job = ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        Record<JobRecordValue> failRecord = ENGINE.job().withKey(jobKey).ofInstance(((JobRecordValue)job.getValue()).getProcessInstanceKey()).withRetries(3).fail();
        ENGINE.jobs().withType(jobType).activate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(failRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.FAILED);
        List jobBatchActivations = (List)((JobBatchRecordStream)RecordingExporter.jobBatchRecords((JobBatchIntent)JobBatchIntent.ACTIVATED).withType(jobType).limit(2L)).collect(Collectors.toList());
        Assertions.assertThat((List)jobBatchActivations).hasSize(2);
        Assertions.assertThat((Object)((Record)jobBatchActivations.get(0))).isEqualTo(batchRecord);
        Assertions.assertThat((long)((Record)jobBatchActivations.get(1)).getPosition()).isGreaterThan(((Record)jobBatchActivations.get(0)).getPosition());
        Assertions.assertThat((Long)((Long)((JobBatchRecordValue)((Record)jobBatchActivations.get(1)).getValue()).getJobKeys().get(0))).isEqualTo(jobKey);
        List jobEvents = (List)((JobRecordStream)RecordingExporter.jobRecords().limit(3L)).collect(Collectors.toList());
        Assertions.assertThat((List)jobEvents).extracting(new Function[]{Record::getRecordType, Record::getValueType, Record::getIntent}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ValueType.JOB, JobIntent.CREATED}), Assertions.tuple((Object[])new Object[]{RecordType.COMMAND, ValueType.JOB, JobIntent.FAIL}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ValueType.JOB, JobIntent.FAILED})});
        List jobActivateCommands = (List)((JobBatchRecordStream)RecordingExporter.jobBatchRecords().limit(4L)).collect(Collectors.toList());
        Assertions.assertThat((List)jobActivateCommands).extracting(new Function[]{Record::getRecordType, Record::getValueType, Record::getIntent}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{RecordType.COMMAND, ValueType.JOB_BATCH, JobBatchIntent.ACTIVATE}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ValueType.JOB_BATCH, JobBatchIntent.ACTIVATED}), Assertions.tuple((Object[])new Object[]{RecordType.COMMAND, ValueType.JOB_BATCH, JobBatchIntent.ACTIVATE}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ValueType.JOB_BATCH, JobBatchIntent.ACTIVATED})});
    }

    @Test
    public void shouldFailJobAndRetryWithBackOff() {
        Record<JobRecordValue> job = ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        Duration backOff = Duration.ofDays(1L);
        Record<JobRecordValue> failRecord = ENGINE.job().withKey(jobKey).ofInstance(((JobRecordValue)job.getValue()).getProcessInstanceKey()).withRetries(3).withBackOff(backOff).fail();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(failRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.FAILED);
        ENGINE.increaseTime(Duration.ofMillis(JobBackoffChecker.BACKOFF_RESOLUTION));
        Record<JobBatchRecordValue> reactivatedJobs = ENGINE.jobs().withType(jobType).activate();
        Assertions.assertThat((List)((JobBatchRecordValue)reactivatedJobs.getValue()).getJobs()).isEmpty();
        ENGINE.increaseTime(backOff.plus(Duration.ofMillis(JobBackoffChecker.BACKOFF_RESOLUTION)));
        Assertions.assertThat((long)((Record)RecordingExporter.jobRecords((JobIntent)JobIntent.RECURRED_AFTER_BACKOFF).withType(jobType).getFirst()).getKey()).isEqualTo(jobKey);
    }

    @Test
    public void shouldFailJobWithBackOffAndRemainFailed() {
        Record<JobRecordValue> job = ENGINE.createJob(jobType, PROCESS_ID);
        long jobKey = job.getKey();
        Duration backOff = Duration.ofDays(1L);
        Record<JobRecordValue> failRecord = ENGINE.job().withKey(jobKey).ofInstance(((JobRecordValue)job.getValue()).getProcessInstanceKey()).withRetries(3).withBackOff(backOff).fail();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(failRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.FAILED).hasKey(jobKey);
        Record<JobBatchRecordValue> reactivatedJobs = ENGINE.jobs().withType(jobType).activate();
        ((ListAssert)Assertions.assertThat((List)((JobBatchRecordValue)reactivatedJobs.getValue()).getJobKeys()).doesNotContain((Object[])new Long[]{jobKey})).isEmpty();
    }

    @Test
    public void shouldFailIfJobCreated() {
        Record<JobRecordValue> job = ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobRecordValue> jobRecord = ENGINE.job().withKey(job.getKey()).fail();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.FAILED);
    }

    @Test
    public void shouldRejectFailIfJobNotFound() {
        int key = 123;
        Record<JobRecordValue> jobRecord = ENGINE.job().withKey(123L).withRetries(3).expectRejection().fail();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldRejectFailIfJobAlreadyFailed() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        ENGINE.job().withKey(jobKey).withRetries(0).fail();
        Record<JobRecordValue> jobRecord = ENGINE.job().withKey(jobKey).withRetries(3).expectRejection().fail();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobRecord).hasRejectionType(RejectionType.INVALID_STATE);
        Assertions.assertThat((String)jobRecord.getRejectionReason()).contains(new CharSequence[]{"it is in state 'FAILED'"});
    }

    @Test
    public void shouldRejectFailIfJobCompleted() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        ENGINE.job().withKey(jobKey).complete();
        Record<JobRecordValue> jobRecord = ENGINE.job().withKey(jobKey).withRetries(3).expectRejection().fail();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldRejectFailIfErrorThrown() {
        Record<JobRecordValue> job = ENGINE.createJob(jobType, PROCESS_ID);
        ENGINE.job().withKey(job.getKey()).withErrorCode("error").throwError();
        Record<JobRecordValue> jobRecord = ENGINE.job().withKey(job.getKey()).withRetries(3).expectRejection().fail();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobRecord).hasRejectionType(RejectionType.INVALID_STATE);
        Assertions.assertThat((String)jobRecord.getRejectionReason()).contains(new CharSequence[]{"is in state 'ERROR_THROWN'"});
    }

    @Test
    public void shouldFailWithVariables() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        JobRecordValue job = (JobRecordValue)((JobBatchRecordValue)batchRecord.getValue()).getJobs().get(0);
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        int retries = 23;
        Record<JobRecordValue> failRecord = ENGINE.job().withKey(jobKey).ofInstance(job.getProcessInstanceKey()).withRetries(23).withVariables("{'foo':'bar'}").fail();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(failRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.FAILED);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)failRecord.getValue())).hasWorker(job.getWorker()).hasType(job.getType()).hasRetries(23).hasDeadline(job.getDeadline());
        Assertions.assertThat((Map)((JobRecordValue)failRecord.getValue()).getVariables()).containsExactly(new Map.Entry[]{Assertions.entry((Object)"foo", (Object)"bar")});
        Record variableRecord = (Record)RecordingExporter.variableRecords().withProcessInstanceKey(job.getProcessInstanceKey()).getFirst();
        ((VariableRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)variableRecord.getValue())).describedAs("check set failing job variables locally", new Object[0])).hasScopeKey(((JobRecordValue)failRecord.getValue()).getElementInstanceKey()).hasName("foo").hasValue("\"bar\"");
    }

    @Test
    public void shouldTruncateErrorMessage() {
        Record<JobRecordValue> job = ENGINE.createJob(jobType, PROCESS_ID);
        String exceedingErrorMessage = "*".repeat(10001);
        Record<JobRecordValue> failedRecord = ENGINE.job().withKey(job.getKey()).withErrorMessage(exceedingErrorMessage).fail();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(failedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.FAILED);
        String expectedErrorMessage = "*".repeat(10000).concat("...");
        Assertions.assertThat((String)((JobRecordValue)failedRecord.getValue()).getErrorMessage()).isEqualTo(expectedErrorMessage);
        Assertions.assertThat((String)((IncidentRecordValue)incident.getValue()).getErrorMessage()).isEqualTo(expectedErrorMessage);
    }

    @Test
    public void shouldNotTruncateErrorMessage() {
        Record<JobRecordValue> job = ENGINE.createJob(jobType, PROCESS_ID);
        String errorMessage = "*".repeat(10000);
        Record<JobRecordValue> failedRecord = ENGINE.job().withKey(job.getKey()).withErrorMessage(errorMessage).fail();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(failedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.FAILED);
        String expectedErrorMessage = "*".repeat(10000);
        Assertions.assertThat((String)((JobRecordValue)failedRecord.getValue()).getErrorMessage()).isEqualTo(expectedErrorMessage);
        Assertions.assertThat((String)((IncidentRecordValue)incident.getValue()).getErrorMessage()).isEqualTo(expectedErrorMessage);
    }

    @Test
    public void shouldFailForCustomTenant() {
        String tenantId = "acme";
        ENGINE.createJob(jobType, PROCESS_ID, Collections.emptyMap(), "acme");
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).withTenantId("acme").activate();
        JobRecordValue job = (JobRecordValue)((JobBatchRecordValue)batchRecord.getValue()).getJobs().get(0);
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        int retries = 23;
        Record<JobRecordValue> failRecord = ENGINE.job().withKey(jobKey).ofInstance(job.getProcessInstanceKey()).withRetries(23).withAuthorizedTenantIds("acme").fail();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(failRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.FAILED);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)failRecord.getValue())).hasTenantId("acme");
    }

    @Test
    public void shouldRejectFailIfTenantIsUnauthorized() {
        String tenantId = "acme";
        String falseTenantId = "foo";
        ENGINE.createJob(jobType, PROCESS_ID, Collections.emptyMap(), "acme");
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).withTenantId("acme").activate();
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        Record<JobRecordValue> jobRecord = ENGINE.job().withKey(jobKey).withRetries(3).withAuthorizedTenantIds("foo").expectRejection().fail();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }
}

