/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.value.MessageStartEventSubscriptionRecordValue;
import io.camunda.zeebe.test.util.record.MessageStartEventSubscriptionRecordStream;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.Rule;
import org.junit.Test;

public final class MessageStartEventSubscriptionTest {
    private static final String MESSAGE_NAME1 = "startMessage1";
    private static final String EVENT_ID1 = "startEventId1";
    private static final String MESSAGE_NAME2 = "startMessage2";
    private static final String EVENT_ID2 = "startEventId2";
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();

    @Test
    public void shouldOpenMessageSubscriptionOnDeployment() {
        this.engine.deployment().withXmlResource(MessageStartEventSubscriptionTest.createProcessWithOneMessageStartEvent()).deploy();
        Record subscription = (Record)RecordingExporter.messageStartEventSubscriptionRecords((MessageStartEventSubscriptionIntent)MessageStartEventSubscriptionIntent.CREATED).getFirst();
        Assertions.assertThat((String)((MessageStartEventSubscriptionRecordValue)subscription.getValue()).getStartEventId()).isEqualTo(EVENT_ID1);
        Assertions.assertThat((String)((MessageStartEventSubscriptionRecordValue)subscription.getValue()).getMessageName()).isEqualTo(MESSAGE_NAME1);
    }

    @Test
    public void shouldOpenSubscriptionsForAllMessageStartEvents() {
        this.engine.deployment().withXmlResource(MessageStartEventSubscriptionTest.createProcessWithTwoMessageStartEvent()).deploy();
        List subscriptions = ((MessageStartEventSubscriptionRecordStream)RecordingExporter.messageStartEventSubscriptionRecords((MessageStartEventSubscriptionIntent)MessageStartEventSubscriptionIntent.CREATED).limit(2L)).asList();
        Assertions.assertThat((int)subscriptions.size()).isEqualTo(2);
        ((ListAssert)Assertions.assertThat((List)subscriptions).hasSize(2)).extracting(Record::getValue).extracting(s -> Assertions.tuple((Object[])new Object[]{s.getMessageName(), s.getStartEventId()})).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{MESSAGE_NAME1, EVENT_ID1}), Assertions.tuple((Object[])new Object[]{MESSAGE_NAME2, EVENT_ID2})});
    }

    @Test
    public void shouldDeleteSubscriptionForOldVersions() {
        this.engine.deployment().withXmlResource(MessageStartEventSubscriptionTest.createProcessWithOneMessageStartEvent()).deploy();
        this.engine.deployment().withXmlResource(MessageStartEventSubscriptionTest.createProcessWithOneMessageStartEvent()).deploy();
        List subscriptions = ((MessageStartEventSubscriptionRecordStream)RecordingExporter.messageStartEventSubscriptionRecords().limit(3L)).asList();
        List intents = subscriptions.stream().map(Record::getIntent).collect(Collectors.toList());
        Assertions.assertThat(intents).containsExactly((Object[])new Intent[]{MessageStartEventSubscriptionIntent.CREATED, MessageStartEventSubscriptionIntent.DELETED, MessageStartEventSubscriptionIntent.CREATED});
        long closingProcessDefinitionKey = ((MessageStartEventSubscriptionRecordValue)((Record)subscriptions.get(1)).getValue()).getProcessDefinitionKey();
        Assertions.assertThat((long)closingProcessDefinitionKey).isEqualTo(((MessageStartEventSubscriptionRecordValue)((Record)subscriptions.get(0)).getValue()).getProcessDefinitionKey());
    }

    @Test
    public void shouldDeleteSubscriptionsForAllMessageStartEvents() {
        this.engine.deployment().withXmlResource(MessageStartEventSubscriptionTest.createProcessWithTwoMessageStartEvent()).deploy();
        long processDefinitionKey = ((Record)RecordingExporter.processRecords().getFirst()).getKey();
        this.engine.deployment().withXmlResource(MessageStartEventSubscriptionTest.createProcessWithTwoMessageStartEvent()).deploy();
        Assertions.assertThat((Stream)RecordingExporter.messageStartEventSubscriptionRecords((MessageStartEventSubscriptionIntent)MessageStartEventSubscriptionIntent.DELETED).limit(2L)).extracting(new Function[]{r -> ((MessageStartEventSubscriptionRecordValue)r.getValue()).getProcessDefinitionKey(), r -> ((MessageStartEventSubscriptionRecordValue)r.getValue()).getMessageName()}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processDefinitionKey, MESSAGE_NAME1}), Assertions.tuple((Object[])new Object[]{processDefinitionKey, MESSAGE_NAME2})});
    }

    @Test
    public void testLifecycle() {
        this.engine.deployment().withXmlResource(MessageStartEventSubscriptionTest.createProcessWithOneMessageStartEvent()).deploy();
        this.engine.message().withName(MESSAGE_NAME1).withCorrelationKey("key-1").publish();
        this.engine.deployment().withXmlResource(MessageStartEventSubscriptionTest.createProcessWithOneMessageStartEvent()).deploy();
        Assertions.assertThat((Stream)RecordingExporter.messageStartEventSubscriptionRecords().limit(3L)).extracting(new Function[]{Record::getRecordType, Record::getIntent}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{RecordType.EVENT, MessageStartEventSubscriptionIntent.CREATED}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, MessageStartEventSubscriptionIntent.CORRELATED}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, MessageStartEventSubscriptionIntent.DELETED})});
    }

    @Test
    public void shouldHaveSameSubscriptionKey() {
        this.engine.deployment().withXmlResource(MessageStartEventSubscriptionTest.createProcessWithOneMessageStartEvent()).deploy();
        long subscriptionKey = ((Record)RecordingExporter.messageStartEventSubscriptionRecords((MessageStartEventSubscriptionIntent)MessageStartEventSubscriptionIntent.CREATED).getFirst()).getKey();
        this.engine.message().withName(MESSAGE_NAME1).withCorrelationKey("key-1").publish();
        this.engine.deployment().withXmlResource(MessageStartEventSubscriptionTest.createProcessWithOneMessageStartEvent()).deploy();
        Assertions.assertThat((Stream)RecordingExporter.messageStartEventSubscriptionRecords().limit(3L)).extracting(new Function[]{Record::getIntent, Record::getKey}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{MessageStartEventSubscriptionIntent.CREATED, subscriptionKey}), Assertions.tuple((Object[])new Object[]{MessageStartEventSubscriptionIntent.CORRELATED, subscriptionKey}), Assertions.tuple((Object[])new Object[]{MessageStartEventSubscriptionIntent.DELETED, subscriptionKey})});
    }

    @Test
    public void shouldResolveCorrelationKeyDefinedInMessageWhenOpeningSubscriptionForEventSubprocess() {
        BpmnModelInstance process = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").eventSubProcess("subprocess", s -> ((StartEventBuilder)s.startEvent().message(m -> m.name("event_message").zeebeCorrelationKeyExpression("correlation_key"))).endEvent()).startEvent().message("start_message")).endEvent().done();
        this.engine.deployment().withXmlResource(process).deploy();
        this.engine.message().withName("start_message").withCorrelationKey("").withVariables(Map.of("correlation_key", "key")).publish();
        Assertions.assertThat((Optional)RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withMessageName("event_message").withCorrelationKey("key").findAny()).isPresent();
    }

    @Test
    public void shouldResolveCorrelationKeyDefinedByOutputMappingInMessageStartEventWhenOpeningSubscriptionForEventSubprocess() {
        BpmnModelInstance process = ((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").eventSubProcess("subprocess", s -> ((StartEventBuilder)s.startEvent().message(m -> m.name("event_message").zeebeCorrelationKeyExpression("correlation_key"))).endEvent()).startEvent().message("start_message")).zeebeOutputExpression("correlation_key_before_mapping", "correlation_key")).endEvent().done();
        this.engine.deployment().withXmlResource(process).deploy();
        this.engine.message().withName("start_message").withCorrelationKey("").withVariables(Map.of("correlation_key_before_mapping", "key")).publish();
        Assertions.assertThat((Optional)RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withMessageName("event_message").withCorrelationKey("key").findAny()).isPresent();
    }

    @Test
    public void shouldResolveCorrelationKeyDefinedByOutputMappingInNoneStartEventWhenOpeningSubscriptionForEventSubprocess() {
        BpmnModelInstance process = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").eventSubProcess("subprocess", s -> ((StartEventBuilder)s.startEvent().message(m -> m.name("event_message").zeebeCorrelationKeyExpression("correlation_key"))).endEvent()).startEvent().zeebeOutputExpression("correlation_key_before_mapping", "correlation_key")).endEvent().done();
        this.engine.deployment().withXmlResource(process).deploy();
        this.engine.processInstance().ofBpmnProcessId("process").withVariables(Map.of("correlation_key_before_mapping", "key")).create();
        Assertions.assertThat((Optional)RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withMessageName("event_message").withCorrelationKey("key").findAny()).isPresent();
    }

    @Test
    public void shouldOpenSingleMessageSubscriptionOnMultipleDeployments() {
        BpmnModelInstance process = MessageStartEventSubscriptionTest.createProcessWithOneMessageStartEvent();
        this.engine.deployment().withXmlResource(process).deploy();
        this.engine.deployment().withXmlResource(process).deploy();
        long position = this.engine.deployment().expectRejection().deploy().getPosition();
        ((ListAssert)Assertions.assertThat((Stream)((RecordStream)RecordingExporter.records().limit(r -> r.getPosition() >= position)).filter(r -> r.getValueType() == ValueType.MESSAGE_START_EVENT_SUBSCRIPTION)).describedAs("Expect only one message start event subscription for duplicate deployments", new Object[0])).hasSize(1);
    }

    private static BpmnModelInstance createProcessWithOneMessageStartEvent() {
        return ((StartEventBuilder)Bpmn.createExecutableProcess((String)"processId").startEvent(EVENT_ID1).message(m -> m.name(MESSAGE_NAME1).id("startmsgId"))).endEvent().done();
    }

    private static BpmnModelInstance createProcessWithTwoMessageStartEvent() {
        ProcessBuilder process = Bpmn.createExecutableProcess((String)"processId");
        ((StartEventBuilder)process.startEvent(EVENT_ID1).message(m -> m.name(MESSAGE_NAME1).id("startmsgId1"))).endEvent();
        ((StartEventBuilder)process.startEvent(EVENT_ID2).message(m -> m.name(MESSAGE_NAME2).id("startmsgId2"))).endEvent();
        return process.done();
    }
}

