/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.multitenancy;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractBpmnModelElementBuilder;
import io.camunda.zeebe.model.bpmn.builder.CallActivityBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class TenantAwareCallActivityTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID_PARENT = "wf-parent";
    private static final String PROCESS_ID_CHILD = "wf-child";
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();
    private final String tenantOne = "foo";
    private final String tenantTwo = "bar";
    private String jobType;

    private static BpmnModelInstance parentProcess(Consumer<CallActivityBuilder> consumer) {
        CallActivityBuilder builder = Bpmn.createExecutableProcess((String)PROCESS_ID_PARENT).startEvent().callActivity("call", c -> c.zeebeProcessId(PROCESS_ID_CHILD));
        consumer.accept(builder);
        return builder.endEvent().done();
    }

    @Before
    public void init() {
        this.jobType = this.helper.getJobType();
        BpmnModelInstance parentProcess = TenantAwareCallActivityTest.parentProcess(AbstractBpmnModelElementBuilder::done);
        BpmnModelInstance childProcess = Bpmn.createExecutableProcess((String)PROCESS_ID_CHILD).startEvent().serviceTask("child-task", t -> t.zeebeJobType(this.jobType)).endEvent().done();
        ENGINE.deployment().withXmlResource("wf-parent.bpmn", parentProcess).withXmlResource("wf-child.bpmn", childProcess).withTenantId("foo").deploy();
        ENGINE.deployment().withXmlResource("wf-parent.bpmn", parentProcess).withTenantId("bar").deploy();
    }

    @Test
    public void shouldActivateCallActivity() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).withTenantId("foo").create();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey).withTenantId("foo").withElementId("call").limit(2L)).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, ProcessInstanceIntent.ELEMENT_ACTIVATED})});
    }

    @Test
    public void shouldNotActivateCallActivity() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID_PARENT).withTenantId("bar").create();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey).withTenantId("bar").withElementId("call").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).isEmpty();
        Record incident = (Record)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).withElementId("call").getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incident.getValue())).hasErrorType(ErrorType.CALLED_ELEMENT_ERROR).hasErrorMessage("Expected process with BPMN process id 'wf-child' to be deployed, but not found.");
    }
}

