/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.multitenancy;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.DecisionEvaluationIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.DecisionEvaluationRecordValue;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.EvaluatedDecisionValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRecordValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class TenantAwareStandaloneDecisionEvaluationTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String DMN_DECISION_TABLE = "/dmn/decision-table.dmn";
    private static final String DMN_DECISION_TABLE_WITH_ASSERTIONS = "/dmn/decision-table-with-assertions.dmn";
    private static final String DECISION_ID = "jedi_or_sith";
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();
    private final String tenantOne = "foo";
    private final String tenantTwo = "bar";
    private Map<String, DecisionRecordValue> deployedDecisionsById;

    private void deployForTenant(String process, String tenant) {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlClasspathResource(process).withTenantId(tenant).deploy();
        this.deployedDecisionsById = ((DeploymentRecordValue)deployment.getValue()).getDecisionsMetadata().stream().collect(Collectors.toMap(DecisionRecordValue::getDecisionId, Function.identity()));
    }

    @Test
    public void shouldEvaluateDecision() {
        this.deployForTenant(DMN_DECISION_TABLE, "foo");
        Record<DecisionEvaluationRecordValue> record = ENGINE.decision().ofDecisionId(DECISION_ID).withVariable("lightsaberColor", "blue").withTenant("foo").evaluate();
        DecisionRecordValue calledDecision = this.deployedDecisionsById.get(DECISION_ID);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Intent)record.getIntent()).isEqualTo((Object)DecisionEvaluationIntent.EVALUATED);
        DecisionEvaluationRecordValue decisionEvaluationValue = (DecisionEvaluationRecordValue)record.getValue();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionEvaluationRecordValue)decisionEvaluationValue).hasDecisionKey(calledDecision.getDecisionKey()).hasDecisionId(calledDecision.getDecisionId()).hasDecisionName(calledDecision.getDecisionName()).hasDecisionVersion(calledDecision.getVersion()).hasDecisionRequirementsKey(calledDecision.getDecisionRequirementsKey()).hasDecisionRequirementsId(calledDecision.getDecisionRequirementsId()).hasTenantId("foo");
        EvaluatedDecisionValue evaluatedDecision = (EvaluatedDecisionValue)decisionEvaluationValue.getEvaluatedDecisions().get(0);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((EvaluatedDecisionValue)evaluatedDecision).hasTenantId("foo");
    }

    @Test
    public void shouldWriteDecisionEvaluationEventIfEvaluationFailed() {
        this.deployForTenant(DMN_DECISION_TABLE_WITH_ASSERTIONS, "foo");
        Record<DecisionEvaluationRecordValue> record = ENGINE.decision().ofDecisionId(DECISION_ID).withTenant("foo").expectFailure().evaluate();
        DecisionRecordValue calledDecision = this.deployedDecisionsById.get(DECISION_ID);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Intent)record.getIntent()).isEqualTo((Object)DecisionEvaluationIntent.FAILED);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionEvaluationRecordValue)((DecisionEvaluationRecordValue)record.getValue())).hasDecisionKey(calledDecision.getDecisionKey()).hasDecisionId(calledDecision.getDecisionId()).hasDecisionName(calledDecision.getDecisionName()).hasDecisionVersion(calledDecision.getVersion()).hasDecisionRequirementsKey(calledDecision.getDecisionRequirementsKey()).hasDecisionRequirementsId(calledDecision.getDecisionRequirementsId()).hasTenantId("foo").hasEvaluationFailureMessage("Expected to evaluate decision 'jedi_or_sith', but Assertion failure on evaluate the expression 'assert(lightsaberColor, lightsaberColor != null)': The condition is not fulfilled");
        EvaluatedDecisionValue evaluatedDecision = (EvaluatedDecisionValue)((DecisionEvaluationRecordValue)record.getValue()).getEvaluatedDecisions().get(0);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((EvaluatedDecisionValue)evaluatedDecision).hasTenantId("foo");
    }

    @Test
    public void shouldRejectDecisionEvaluationWithCustomTenant() {
        this.deployForTenant(DMN_DECISION_TABLE, "foo");
        Record<DecisionEvaluationRecordValue> record = ENGINE.decision().ofDecisionId(DECISION_ID).withVariable("lightsaberColor", "blue").withTenant("bar").expectRejection().evaluate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((RejectionType)record.getRejectionType()).isEqualTo((Object)RejectionType.INVALID_ARGUMENT);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Intent)record.getIntent()).isEqualTo((Object)DecisionEvaluationIntent.EVALUATE);
        Assertions.assertThat((String)record.getRejectionReason()).isEqualTo("Expected to evaluate decision 'jedi_or_sith', but no decision found for id 'jedi_or_sith'");
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionEvaluationRecordValue)((DecisionEvaluationRecordValue)record.getValue())).hasTenantId("bar");
    }

    @Test
    public void shouldRejectDecisionEvaluationWithDefaultTenant() {
        this.deployForTenant(DMN_DECISION_TABLE, "foo");
        Record<DecisionEvaluationRecordValue> record = ENGINE.decision().ofDecisionId(DECISION_ID).withVariable("lightsaberColor", "blue").expectRejection().evaluate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((RejectionType)record.getRejectionType()).isEqualTo((Object)RejectionType.INVALID_ARGUMENT);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Intent)record.getIntent()).isEqualTo((Object)DecisionEvaluationIntent.EVALUATE);
        Assertions.assertThat((String)record.getRejectionReason()).isEqualTo("Expected to evaluate decision 'jedi_or_sith', but no decision found for id 'jedi_or_sith'");
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionEvaluationRecordValue)((DecisionEvaluationRecordValue)record.getValue())).hasTenantId("<default>");
    }
}

