/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.multitenancy;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.TimerRecordStream;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TenantAwareTimerCatchEventTest {
    private static final String PROCESS_ID = "process";
    private static final String TIMER_ID = "timer";
    private static final String TENANT = "tenant-a";
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();

    private static BpmnModelInstance processWithTimer(Consumer<IntermediateCatchEventBuilder> consumer) {
        IntermediateCatchEventBuilder builder = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().intermediateCatchEvent(TIMER_ID);
        consumer.accept(builder);
        return builder.endEvent().done();
    }

    @Before
    public void init() {
        BpmnModelInstance process = TenantAwareTimerCatchEventTest.processWithTimer(c -> c.timerWithDuration("PT1M"));
        this.engine.deployment().withXmlResource(process).withTenantId(TENANT).deploy();
    }

    @Test
    public void shouldCreateTimer() {
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId(TENANT).create();
        Record timerRecord = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)((TimerRecordValue)timerRecord.getValue())).hasTenantId(TENANT);
    }

    @Test
    public void shouldTriggerTimer() {
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId(TENANT).create();
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).exists()).isTrue();
        this.engine.increaseTime(Duration.ofMinutes(1L));
        Assertions.assertThat((Stream)((TimerRecordStream)RecordingExporter.timerRecords().withIntents(new Intent[]{TimerIntent.TRIGGER, TimerIntent.TRIGGERED})).withProcessInstanceKey(processInstanceKey).limit(2L)).extracting(new Function[]{r -> ((TimerRecordValue)r.getValue()).getTenantId(), Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{TENANT, TimerIntent.TRIGGER}), Assertions.tuple((Object[])new Object[]{TENANT, TimerIntent.TRIGGERED})});
    }

    @Test
    public void shouldCancelTimer() {
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId(TENANT).create();
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).exists()).isTrue();
        this.engine.processInstance().withInstanceKey(processInstanceKey).forAuthorizedTenants(TENANT).cancel();
        Record canceledEvent = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CANCELED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)((TimerRecordValue)canceledEvent.getValue())).hasTenantId(TENANT);
    }

    @Test
    public void shouldRaiseIncident() {
        String faultyDurationExpression = "today() + duration(\"P1D\")";
        BpmnModelInstance process = TenantAwareTimerCatchEventTest.processWithTimer(c -> c.timerWithDurationExpression("today() + duration(\"P1D\")"));
        this.engine.deployment().withXmlResource(process).withTenantId(TENANT).deploy();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId(TENANT).create();
        IncidentRecordValue incidentEvent = (IncidentRecordValue)((Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getValue();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)incidentEvent).hasTenantId(TENANT);
    }

    @Test
    public void shouldRescheduleTimer() {
        BpmnModelInstance process = ((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"RESCHEDULE_PROCESS").startEvent().serviceTask("task", b -> b.zeebeJobType("type")).boundaryEvent(TIMER_ID).cancelActivity(Boolean.valueOf(false))).timerWithCycle("R2/PT1M")).endEvent().moveToNode("task").endEvent().done();
        this.engine.deployment().withXmlResource(process).withTenantId(TENANT).deploy();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId("RESCHEDULE_PROCESS").withTenantId(TENANT).create();
        Record timerCreated = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        this.engine.increaseTime(Duration.ofMinutes(1L));
        Record timerRescheduled = (Record)((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).getLast();
        Assertions.assertThat((long)timerRescheduled.getKey()).isGreaterThan(timerCreated.getKey());
        io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)((TimerRecordValue)timerRescheduled.getValue())).hasTenantId(TENANT);
    }

    @Test
    public void shouldApplyTenantToLifecycleEvents() {
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId(TENANT).create();
        this.engine.increaseTime(Duration.ofMinutes(1L));
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().withElementId(TIMER_ID)).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getTenantId(), Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{TENANT, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{TENANT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{TENANT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{TENANT, ProcessInstanceIntent.COMPLETE_ELEMENT}), Assertions.tuple((Object[])new Object[]{TENANT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{TENANT, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }
}

