/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.multitenancy;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.protocol.record.Assertions;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordAssert;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.record.value.VariableDocumentRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class TenantAwareUpdateVariablesTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldUpdateVariablesForDefaultTenant() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.zeebeJobType("test")).endEvent().done()).withTenantId("<default>").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withTenantId("<default>").create();
        Record<VariableDocumentRecordValue> updated = ENGINE.variables().ofScope(processInstanceKey).forAuthorizedTenants("<default>").withDocument(Map.of("foo", "bar")).update();
        ((RecordAssert)Assertions.assertThat(updated).describedAs("Expect that update was successful", new Object[0])).hasIntent((Intent)VariableDocumentIntent.UPDATED);
    }

    @Test
    public void shouldRejectUpdateVariablesForUnauthorizedTenant() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.zeebeJobType("test")).endEvent().done()).withTenantId("custom-tenant").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withTenantId("custom-tenant").create();
        Record<VariableDocumentRecordValue> rejection = ENGINE.variables().ofScope(processInstanceKey).forAuthorizedTenants("another-tenant").withDocument(Map.of("foo", "bar")).expectRejection().update();
        Assertions.assertThat(rejection).hasRejectionType(RejectionType.NOT_FOUND).hasRejectionReason("Expected to update variables for element with key '%s', but no such element was found".formatted(processInstanceKey));
    }

    @Test
    public void shouldUpdateVariablesForSpecificTenant() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.zeebeJobType("test")).endEvent().done()).withTenantId("custom-tenant").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withTenantId("custom-tenant").create();
        Record<VariableDocumentRecordValue> updated = ENGINE.variables().ofScope(processInstanceKey).forAuthorizedTenants("custom-tenant").withDocument(Map.of("foo", "bar")).update();
        ((RecordAssert)Assertions.assertThat(updated).describedAs("Expect that update was successful", new Object[0])).hasIntent((Intent)VariableDocumentIntent.UPDATED);
    }
}

