/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.RecordToWrite;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceCreationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.ProcessInstanceCreationRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class CreateProcessInstanceTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Test
    public void shouldActivateProcess() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().withElementType(BpmnElementType.PROCESS)).extracting(Record::getIntent).containsSequence((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED});
        Record process = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withElementType(BpmnElementType.PROCESS).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)process.getValue())).hasElementId("process").hasBpmnElementType(BpmnElementType.PROCESS).hasFlowScopeKey(-1L).hasBpmnProcessId("process").hasProcessInstanceKey(processInstanceKey).hasTenantId("<default>");
    }

    @Test
    public void shouldCreateProcessInstanceWithVariables() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withVariables(Map.of("x", 1, "y", 2)).create();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.variableRecords().withProcessInstanceKey(processInstanceKey).limit(2L)).extracting(Record::getValue).allMatch(v -> v.getScopeKey() == processInstanceKey)).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getName(), v.getValue()})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"x", "1"}), Assertions.tuple((Object[])new Object[]{"y", "2"})});
    }

    @Test
    public void shouldActivateNoneStartEvent() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent("start").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.COMPLETE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        Record startEvent = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withElementType(BpmnElementType.START_EVENT).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)startEvent.getValue())).hasElementId("start").hasBpmnElementType(BpmnElementType.START_EVENT).hasFlowScopeKey(processInstanceKey).hasBpmnProcessId("process").hasProcessInstanceKey(processInstanceKey);
    }

    @Test
    public void shouldActivateOnlyNoneStartEvent() {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)"process");
        processBuilder.startEvent("none-start").endEvent();
        ((StartEventBuilder)processBuilder.startEvent("timer-start").timerWithCycle("R/PT1H")).endEvent();
        ((StartEventBuilder)processBuilder.startEvent("message-start").message("start")).endEvent();
        ((StartEventBuilder)processBuilder.startEvent("signal-start").signal("signal")).endEvent();
        ENGINE.deployment().withXmlResource(processBuilder.done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().withElementType(BpmnElementType.START_EVENT)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsOnly((Object[])new String[]{"none-start"});
    }

    @Test
    public void shouldTakeSequenceFlowFromStartEvent() {
        ENGINE.deployment().withXmlResource(((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().sequenceFlowId("flow")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SEQUENCE_FLOW, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ACTIVATE_ELEMENT})});
        Record sequenceFlow = (Record)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SEQUENCE_FLOW).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)sequenceFlow.getValue())).hasElementId("flow").hasBpmnElementType(BpmnElementType.SEQUENCE_FLOW).hasFlowScopeKey(processInstanceKey).hasBpmnProcessId("process").hasProcessInstanceKey(processInstanceKey);
    }

    @Test
    public void shouldCompleteUndefinedTask() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"process").startEvent().task().endEvent().done();
        ENGINE.deployment().withXmlResource(modelInstance).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCreateProcessInstanceForDefaultTenant() {
        String processId = "process";
        String tenantId = "<default>";
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done()).withTenantId("<default>").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        Record process = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withElementType(BpmnElementType.PROCESS).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)process.getValue())).hasBpmnProcessId("process").hasTenantId("<default>");
    }

    @Test
    public void shouldCreateProcessInstanceForCustomTenant() {
        String processId = this.helper.getBpmnProcessId();
        String tenantId = "foo";
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().endEvent().done()).withTenantId("foo").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withTenantId("foo").create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().withElementType(BpmnElementType.PROCESS)).extracting(Record::getIntent).containsSequence((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED});
        Record process = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withElementType(BpmnElementType.PROCESS).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)process.getValue())).hasBpmnProcessId(processId).hasTenantId("foo");
    }

    @Test
    public void shouldActivateNoneStartEventWhenEventTriggerIsAvailableInState() {
        String processId = this.helper.getBpmnProcessId();
        BpmnModelInstance modelInstance = ((StartEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent("noneStart").endEvent().moveToProcess(processId).startEvent("msgStart").message("msg")).endEvent().done();
        ENGINE.deployment().withXmlResource(modelInstance).deploy();
        ENGINE.writeRecords(RecordToWrite.command().processInstanceCreation(ProcessInstanceCreationIntent.CREATE, (ProcessInstanceCreationRecordValue)new ProcessInstanceCreationRecord().setBpmnProcessId(processId).setVersion(1)), RecordToWrite.command().message(MessageIntent.PUBLISH, (MessageRecordValue)new MessageRecord().setName("msg").setCorrelationKey("").setTimeToLive(0L)));
        long processInstanceKey = ((ProcessInstanceCreationRecordValue)((Record)((ProcessInstanceCreationRecordStream)RecordingExporter.processInstanceCreationRecords().withBpmnProcessId(processId).withIntent((Intent)ProcessInstanceCreationIntent.CREATED)).getFirst()).getValue()).getProcessInstanceKey();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, processId, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, processId, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, processId, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, "noneStart", ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, "noneStart", ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, "noneStart", ProcessInstanceIntent.ELEMENT_ACTIVATED})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, "msgStart", ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, "msgStart", ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, "msgStart", ProcessInstanceIntent.ELEMENT_ACTIVATED})});
        ((AbstractListAssert)Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withBpmnProcessId(processId).filter(r -> ((ProcessInstanceRecordValue)r.getValue()).getProcessInstanceKey() != processInstanceKey)).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, processId, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, processId, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, processId, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, "msgStart", ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, "msgStart", ProcessInstanceIntent.ELEMENT_ACTIVATED})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, "noneStart", ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, "noneStart", ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, "noneStart", ProcessInstanceIntent.ELEMENT_ACTIVATED})});
    }
}

