/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.RecordToWrite;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.EventSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.UserTaskBuilder;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationTerminateInstruction;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class ModifyProcessInstanceTerminationTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @ClassRule
    public static final BrokerClassRuleHelper CLASS_RULE_HELPER = new BrokerClassRuleHelper();
    private static final String PROCESS_ID = "process";
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldTerminateElementInRootScope() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long elementInstanceKey = ModifyProcessInstanceTerminationTest.getElementInstanceKeyOfElement(processInstanceKey, "A");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(elementInstanceKey).modify();
        this.assertThatElementIsTerminated(processInstanceKey, "A");
        this.assertThatJobIsCancelled(processInstanceKey, "A");
    }

    @Test
    public void shouldTerminateMultipleElementsInRootScope() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().parallelGateway().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().moveToLastGateway().serviceTask("B", b -> b.zeebeJobType("B")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Map elementsInstanceKeys = (Map)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).limit(2L)).collect(Collectors.toMap(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getKey));
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement((Long)elementsInstanceKeys.get("A")).terminateElement((Long)elementsInstanceKeys.get("B")).modify();
        this.assertThatElementIsTerminated(processInstanceKey, "A");
        this.assertThatElementIsTerminated(processInstanceKey, "B");
        this.assertThatJobIsCancelled(processInstanceKey, "A");
        this.assertThatJobIsCancelled(processInstanceKey, "B");
    }

    @Test
    public void shouldTerminateElementWithIncidentOnJob() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().withType("A").ofInstance(processInstanceKey).fail();
        Record incidentRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId("A").getFirst();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(((IncidentRecordValue)incidentRecord.getValue()).getElementInstanceKey()).modify();
        this.assertThatElementIsTerminated(processInstanceKey, "A");
        this.assertThatJobIsCancelled(processInstanceKey, "A");
        this.assertThatIncidentIsResolved(processInstanceKey, "A");
    }

    @Test
    public void shouldTerminateElementWithIncidentInRootScope() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("A", a -> a.zeebeJobTypeExpression("A")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId("A").getFirst();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(((IncidentRecordValue)incidentRecord.getValue()).getElementInstanceKey()).modify();
        this.assertThatElementIsTerminated(processInstanceKey, "A");
        this.assertThatIncidentIsResolved(processInstanceKey, "A");
    }

    @Test
    public void shouldTerminateElementWithEventSubscriptions() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).boundaryEvent("timer", t -> ((BoundaryEventBuilder)t.timerWithDuration("PT1H")).endEvent()).moveToActivity("A").boundaryEvent("message", b -> b.message(m -> m.name("message").zeebeCorrelationKeyExpression("= \"correlationKey\""))).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long elementInstanceKey = ((ProcessMessageSubscriptionRecordValue)((Record)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).withMessageName("message").getFirst()).getValue()).getElementInstanceKey();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(elementInstanceKey).modify();
        this.assertThatElementIsTerminated(processInstanceKey, "A");
        this.assertThatJobIsCancelled(processInstanceKey, "A");
        this.assertThatTimerEventSubscriptionIsDeleted(processInstanceKey, elementInstanceKey);
        this.assertThatMessageEventSubscriptionIsDeleted(processInstanceKey, elementInstanceKey);
    }

    @Test
    public void shouldBeAbleToCompleteProcessInstanceAfterElementIsTerminated() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().parallelGateway("gateway").serviceTask("A", a -> a.zeebeJobType("A")).endEvent().moveToNode("gateway").serviceTask("B", b -> b.zeebeJobType("B")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long elementInstanceKey = ModifyProcessInstanceTerminationTest.getElementInstanceKeyOfElement(processInstanceKey, "A");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(elementInstanceKey).modify();
        this.assertThatElementIsTerminated(processInstanceKey, "A");
        this.assertThatJobIsCancelled(processInstanceKey, "A");
        Assertions.assertThat((Stream)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(1L)).isNotEmpty();
        ENGINE.job().ofInstance(processInstanceKey).withType("B").complete();
        ((OptionalAssert)Assertions.assertThat((Optional)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).limitToProcessInstanceCompleted().findAny()).describedAs("Expect the process instance to have been completed", new Object[0])).isPresent();
    }

    @Test
    public void shouldTerminateAllElementsInRootScope() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long elementInstanceKey = ModifyProcessInstanceTerminationTest.getElementInstanceKeyOfElement(processInstanceKey, "A");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(elementInstanceKey).modify();
        this.assertThatElementIsTerminated(processInstanceKey, "A");
        this.assertThatElementIsTerminated(processInstanceKey, PROCESS_ID);
    }

    @Test
    public void shouldTerminateAllElementsOfFlowScope() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", subprocess -> subprocess.embeddedSubProcess().startEvent().parallelGateway("fork").userTask("A").moveToNode("fork").userTask("B")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long elementInstanceKeyOfA = ModifyProcessInstanceTerminationTest.getElementInstanceKeyOfElement(processInstanceKey, "A");
        long elementInstanceKeyOfB = ModifyProcessInstanceTerminationTest.getElementInstanceKeyOfElement(processInstanceKey, "B");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(elementInstanceKeyOfA).terminateElement(elementInstanceKeyOfB).modify();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceTerminated()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).describedAs("Expect to terminate the elements and propagate to their flow scopes", new Object[0]).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "A", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "B", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, "subprocess", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, PROCESS_ID, ProcessInstanceIntent.ELEMENT_TERMINATED})});
    }

    @Test
    public void shouldTerminateAllElementsOfNestedFlowScope() {
        Consumer<SubProcessBuilder> subprocessLvl2Builder = subprocessLvl2 -> subprocessLvl2.embeddedSubProcess().startEvent().userTask("A").endEvent();
        Consumer<SubProcessBuilder> subprocessLvl1Builder = subprocessLvl1 -> subprocessLvl1.embeddedSubProcess().startEvent().subProcess("subprocess-lvl-2", subprocessLvl2Builder).endEvent();
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess-lvl-1", subprocessLvl1Builder).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long elementInstanceKeyOfA = ModifyProcessInstanceTerminationTest.getElementInstanceKeyOfElement(processInstanceKey, "A");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(elementInstanceKeyOfA).modify();
        this.assertThatElementIsTerminated(processInstanceKey, "A");
        this.assertThatElementIsTerminated(processInstanceKey, "subprocess-lvl-2");
        this.assertThatElementIsTerminated(processInstanceKey, "subprocess-lvl-1");
        this.assertThatElementIsTerminated(processInstanceKey, PROCESS_ID);
    }

    @Test
    public void shouldDeleteEventSubscriptionsOfTerminatedFlowScope() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", subprocess -> subprocess.embeddedSubProcess().startEvent().userTask("A")).boundaryEvent("boundary-event", b -> b.message(m -> m.name("message").zeebeCorrelationKeyExpression("\"key\""))).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long elementInstanceKeyOfA = ModifyProcessInstanceTerminationTest.getElementInstanceKeyOfElement(processInstanceKey, "A");
        long elementInstanceKeyOfSubprocess = ModifyProcessInstanceTerminationTest.getElementInstanceKeyOfElement(processInstanceKey, "subprocess");
        RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementInstanceKey(elementInstanceKeyOfSubprocess).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(elementInstanceKeyOfA).modify();
        this.assertThatElementIsTerminated(processInstanceKey, "A");
        this.assertThatElementIsTerminated(processInstanceKey, "subprocess");
        this.assertThatMessageEventSubscriptionIsDeleted(processInstanceKey, elementInstanceKeyOfSubprocess);
    }

    @Test
    public void shouldNotCompleteFlowScopeIfElementsAreTerminated() {
        ENGINE.deployment().withXmlResource(((SubProcessBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", subprocess -> subprocess.embeddedSubProcess().startEvent().userTask("A")).sequenceFlowId("to-end")).endEvent("end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long elementInstanceKey = ModifyProcessInstanceTerminationTest.getElementInstanceKeyOfElement(processInstanceKey, "A");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(elementInstanceKey).modify();
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceTerminated()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).describedAs("Expect to terminate the element and its flow scope", new Object[0]).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "A", ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "A", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, "subprocess", ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, "subprocess", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, PROCESS_ID, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, PROCESS_ID, ProcessInstanceIntent.ELEMENT_TERMINATED})})).describedAs("Expect the flow scope not to be completed", new Object[0]).doesNotContain((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, "subprocess", ProcessInstanceIntent.ELEMENT_COMPLETING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, "subprocess", ProcessInstanceIntent.ELEMENT_COMPLETED})})).describedAs("Expect to elements after the flow scope not to be activated", new Object[0]).doesNotContain((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.SEQUENCE_FLOW, "to-end", ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Tuple.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, "end", ProcessInstanceIntent.ELEMENT_ACTIVATED})});
    }

    @Test
    public void shouldNotTerminateFlowScopeIfPendingActivation() {
        ENGINE.deployment().withXmlResource(((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().parallelGateway("fork").userTask("A").moveToNode("fork").userTask("B").sequenceFlowId("b-to-c")).userTask("C").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long elementInstanceKeyOfA = ModifyProcessInstanceTerminationTest.getElementInstanceKeyOfElement(processInstanceKey, "A");
        Record elementRecordOfB = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("B").getFirst();
        ProcessInstanceModificationRecord modificationCommand = new ProcessInstanceModificationRecord().setProcessInstanceKey(processInstanceKey).addTerminateInstruction((ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue)new ProcessInstanceModificationTerminateInstruction().setElementInstanceKey(elementInstanceKeyOfA));
        ENGINE.writeRecords(RecordToWrite.command().processInstance(ProcessInstanceIntent.COMPLETE_ELEMENT, (ProcessInstanceRecordValue)elementRecordOfB.getValue()).key(elementRecordOfB.getKey()), RecordToWrite.command().modification((ProcessInstanceModificationRecordValue)modificationCommand).key(processInstanceKey));
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limit("A", ProcessInstanceIntent.ELEMENT_TERMINATED)).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).describedAs("Ensure the precondition of a pending activation", new Object[0]).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "B", ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SEQUENCE_FLOW, "b-to-c", ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "C", ProcessInstanceIntent.ACTIVATE_ELEMENT}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "A", ProcessInstanceIntent.ELEMENT_TERMINATING})})).describedAs("Expect the flow scope not to be terminated", new Object[0]).doesNotContain((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, "subprocess", ProcessInstanceIntent.ELEMENT_TERMINATED})})).describedAs("Expect the pending element to be activated", new Object[0]).contains((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "C", ProcessInstanceIntent.ELEMENT_ACTIVATED})});
    }

    @Test
    public void shouldTerminateEventSubprocess() {
        String correlationKey = CLASS_RULE_HELPER.getCorrelationValue();
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("event-subprocess", eventSubprocess -> ((StartEventBuilder)eventSubprocess.startEvent().message(m -> m.name("start").zeebeCorrelationKeyExpression("key"))).subProcess("subprocess", subprocess -> subprocess.embeddedSubProcess().startEvent().userTask("B").endEvent()).endEvent()).startEvent().userTask("A").endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", correlationKey).create();
        ENGINE.message().withName("start").withCorrelationKey(correlationKey).publish();
        long eventSubprocessKey = ModifyProcessInstanceTerminationTest.getElementInstanceKeyOfElement(processInstanceKey, "event-subprocess");
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("B").await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(eventSubprocessKey).modify();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceTerminated()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).describedAs("Expect to terminate the event subprocess and all containing elements", new Object[0]).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, "event-subprocess", ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, "subprocess", ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "B", ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "B", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, "subprocess", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, "event-subprocess", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, PROCESS_ID, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, PROCESS_ID, ProcessInstanceIntent.ELEMENT_TERMINATED})});
    }

    @Test
    public void shouldTerminateEmbeddedSubProcess() {
        String correlationKey = CLASS_RULE_HELPER.getCorrelationValue();
        Consumer<EventSubProcessBuilder> eventSubProcess = eventSP -> ((StartEventBuilder)((StartEventBuilder)eventSP.startEvent().message(m -> m.name("start").zeebeCorrelationKeyExpression("key"))).interrupting(false)).userTask("B").endEvent();
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", sp -> sp.embeddedSubProcess().eventSubProcess("event-subprocess", eventSubProcess).startEvent().userTask("A").endEvent()).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", correlationKey).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        ENGINE.message().withName("start").withCorrelationKey(correlationKey).publish();
        long subProcessKey = ModifyProcessInstanceTerminationTest.getElementInstanceKeyOfElement(processInstanceKey, "subprocess");
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("B").await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(subProcessKey).modify();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceTerminated()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).describedAs("Expect to terminate the subprocess and all containing elements", new Object[0]).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, "subprocess", ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "A", ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "A", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, "event-subprocess", ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "B", ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "B", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, "event-subprocess", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, "subprocess", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, PROCESS_ID, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, PROCESS_ID, ProcessInstanceIntent.ELEMENT_TERMINATED})});
    }

    @Test
    public void shouldTerminateCallActivity() {
        String callActivityProcessId = "callActivityProcess";
        BpmnModelInstance callActivityProcess = Bpmn.createExecutableProcess((String)"callActivityProcess").startEvent().userTask("A").endEvent().done();
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().callActivity("callActivity", callActivity -> callActivity.zeebeProcessId("callActivityProcess")).endEvent().done();
        ENGINE.deployment().withXmlResource(callActivityProcess).withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long callActivityKey = ModifyProcessInstanceTerminationTest.getElementInstanceKeyOfElement(processInstanceKey, "callActivity");
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withParentProcessInstanceKey(processInstanceKey).withElementId("A").await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(callActivityKey).modify();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKeyOrParentProcessInstanceKey(processInstanceKey).limit(PROCESS_ID, ProcessInstanceIntent.ELEMENT_TERMINATED)).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).describedAs("Expect to terminate the callActivity and all containing elements", new Object[0]).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, "callActivity", ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, "callActivityProcess", ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "A", ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, "A", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, "callActivityProcess", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.CALL_ACTIVITY, "callActivity", ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, PROCESS_ID, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, PROCESS_ID, ProcessInstanceIntent.ELEMENT_TERMINATED})});
    }

    @Test
    public void shouldTerminateParallelMultiInstanceElement() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("A", s -> ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)s.embeddedSubProcess().startEvent().userTask("B").endEvent().subProcessDone().multiInstance().parallel()).zeebeInputCollectionExpression("[1,2,3]")).multiInstanceDone()).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record multiInstanceElement = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").withElementType(BpmnElementType.MULTI_INSTANCE_BODY).getFirst();
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("B").withElementType(BpmnElementType.USER_TASK).limit(3L)).describedAs("Await until all 3 user tasks are activated as pre-condition", new Object[0])).hasSize(3);
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(multiInstanceElement.getKey()).modify();
        this.assertThatElementIsTerminated(processInstanceKey, "A");
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey).skipUntil(r -> r.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATING)).limitToProcessInstanceTerminated()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).describedAs("Expect that all active instances of the multi-instance have been terminated", new Object[0]).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.MULTI_INSTANCE_BODY, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.MULTI_INSTANCE_BODY, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED})});
    }

    @Test
    public void shouldTerminateSequentialMultiInstanceElement() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("A", s -> ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)s.embeddedSubProcess().startEvent().userTask("B").endEvent().subProcessDone().multiInstance().sequential()).zeebeInputCollectionExpression("[1,2,3]")).multiInstanceDone()).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record multiInstanceElement = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").withElementType(BpmnElementType.MULTI_INSTANCE_BODY).getFirst();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("B").withElementType(BpmnElementType.USER_TASK).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(multiInstanceElement.getKey()).modify();
        this.assertThatElementIsTerminated(processInstanceKey, "A");
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey).skipUntil(r -> r.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATING)).limitToProcessInstanceTerminated()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).describedAs("Expect that all active instances of the multi-instance have been terminated", new Object[0]).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.MULTI_INSTANCE_BODY, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.MULTI_INSTANCE_BODY, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED})});
    }

    @Test
    public void shouldTerminateMultiInstanceBodyAndNestedElements() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("A", s -> ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)s.embeddedSubProcess().startEvent().userTask("B").endEvent().subProcessDone().multiInstance().parallel()).zeebeInputCollectionExpression("[1,2,3]")).multiInstanceDone()).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record multiInstanceElement = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").withElementType(BpmnElementType.MULTI_INSTANCE_BODY).getFirst();
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("B").withElementType(BpmnElementType.USER_TASK).limit(3L)).describedAs("Expect that all 3 user tasks are activated", new Object[0])).hasSize(3);
        List elements = ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SUB_PROCESS).limit(3L)).map(Record::getKey).toList();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(multiInstanceElement.getKey()).terminateElement((Long)elements.get(0)).terminateElement((Long)elements.get(1)).terminateElement((Long)elements.get(2)).modify();
        this.assertThatElementIsTerminated(processInstanceKey, "A");
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey).skipUntil(r -> r.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATING)).limitToProcessInstanceTerminated()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).describedAs("Expect that all active instances of the multi-instance have been terminated", new Object[0]).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.MULTI_INSTANCE_BODY, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.MULTI_INSTANCE_BODY, ProcessInstanceIntent.ELEMENT_TERMINATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED})});
    }

    @Test
    public void shouldTerminateFlowScopeWhenElementInsideIsActivateAndFlowScopeIsTerminated() {
        String correlationKey = CLASS_RULE_HELPER.getCorrelationValue();
        Consumer<EventSubProcessBuilder> eventSubProcess = esp -> ((StartEventBuilder)((StartEventBuilder)esp.startEvent("startEvent").message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).interrupting(false)).userTask("B").endEvent("endEvent");
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("eventSubProcess", eventSubProcess).startEvent().userTask("A").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", correlationKey).create();
        Assertions.assertThat((Optional)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).withMessageName("message").findFirst()).isPresent();
        ENGINE.message().withName("message").withCorrelationKey(correlationKey).publish();
        Assertions.assertThat((Stream)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).hasSize(2);
        long eventSubprocessKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("eventSubProcess").getFirst()).getKey();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(eventSubprocessKey).activateElement("endEvent").modify();
        Record rejectedActivateCommand = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ACTIVATE_ELEMENT).withProcessInstanceKey(processInstanceKey).withElementId("endEvent").onlyCommandRejections()).getFirst();
        Assertions.assertThat((Comparable)rejectedActivateCommand.getRejectionType()).isEqualTo((Object)RejectionType.INVALID_STATE);
        Assertions.assertThat((String)rejectedActivateCommand.getRejectionReason()).isEqualTo("Expected flow scope instance with key '%s' to be present in state but not found.", new Object[]{eventSubprocessKey});
        this.assertThatElementIsTerminated(processInstanceKey, "eventSubProcess");
    }

    private static long getElementInstanceKeyOfElement(long processInstanceKey, String elementId) {
        return ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId(elementId).getFirst()).getKey();
    }

    private void assertThatElementIsTerminated(long processInstanceKey, String elementId) {
        Assertions.assertThat((List)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey).withElementId(elementId).limit(elementId, ProcessInstanceIntent.ELEMENT_TERMINATED).toList()).extracting(Record::getIntent).containsSequence((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_TERMINATING, ProcessInstanceIntent.ELEMENT_TERMINATED});
    }

    private void assertThatJobIsCancelled(long processInstanceKey, String elementId) {
        Assertions.assertThat((boolean)RecordingExporter.jobRecords((JobIntent)JobIntent.CANCELED).withProcessInstanceKey(processInstanceKey).withElementId(elementId).exists()).isTrue();
    }

    private void assertThatIncidentIsResolved(long processInstanceKey, String elementId) {
        Assertions.assertThat((boolean)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.RESOLVED).withProcessInstanceKey(processInstanceKey).withElementId(elementId).exists()).isTrue();
    }

    private void assertThatTimerEventSubscriptionIsDeleted(long processInstanceKey, long elementInstanceKey) {
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CANCELED).withProcessInstanceKey(processInstanceKey).withElementInstanceKey(elementInstanceKey).exists()).isTrue();
    }

    private void assertThatMessageEventSubscriptionIsDeleted(long processInstanceKey, long elementInstanceKey) {
        Assertions.assertThat((boolean)RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.DELETED).withProcessInstanceKey(processInstanceKey).withElementInstanceKey(elementInstanceKey).exists()).isTrue();
    }
}

