/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.streamprocessor;

import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.protocol.impl.record.CopiedRecord;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.impl.records.TypedRecordImpl;
import io.camunda.zeebe.test.util.JsonUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.collection.Tuple;
import org.agrona.DirectBuffer;
import org.junit.Test;
import org.mockito.Mockito;

public final class TypedEventSerializationTest {
    private static Tuple<TypedRecord, CopiedRecord> createRecordTuple() {
        RecordMetadata recordMetadata = new RecordMetadata();
        DeploymentIntent intent = DeploymentIntent.CREATE;
        boolean protocolVersion = true;
        ValueType valueType = ValueType.DEPLOYMENT;
        RecordType recordType = RecordType.COMMAND;
        String rejectionReason = "fails";
        RejectionType rejectionType = RejectionType.INVALID_ARGUMENT;
        int requestId = 23;
        boolean requestStreamId = true;
        recordMetadata.intent((Intent)intent).protocolVersion(1).valueType(valueType).recordType(recordType).rejectionReason("fails").rejectionType(rejectionType).requestId(23L).requestStreamId(1);
        String resourceName = "resource";
        DirectBuffer resource = BufferUtil.wrapString((String)"contents");
        String bpmnProcessId = "testProcess";
        long processDefinitionKey = 123L;
        int processVersion = 12;
        DeploymentRecord record = new DeploymentRecord();
        ((DeploymentResource)record.resources().add()).setResourceName(BufferUtil.wrapString((String)"resource")).setResource(resource);
        ((ProcessMetadata)record.processesMetadata().add()).setBpmnProcessId(BufferUtil.wrapString((String)"testProcess")).setKey(123L).setResourceName(BufferUtil.wrapString((String)"resource")).setVersion(12).setChecksum(BufferUtil.wrapString((String)"checksum"));
        long key = 1234L;
        long position = 4321L;
        long sourcePosition = 231L;
        long timestamp = 2191L;
        LoggedEvent loggedEvent = (LoggedEvent)Mockito.mock(LoggedEvent.class);
        Mockito.when((Object)loggedEvent.getPosition()).thenReturn((Object)4321L);
        Mockito.when((Object)loggedEvent.getKey()).thenReturn((Object)1234L);
        Mockito.when((Object)loggedEvent.getSourceEventPosition()).thenReturn((Object)231L);
        Mockito.when((Object)loggedEvent.getTimestamp()).thenReturn((Object)2191L);
        TypedRecordImpl typedEvent = new TypedRecordImpl(0);
        typedEvent.wrap(loggedEvent, recordMetadata, (UnifiedRecordValue)record);
        CopiedRecord copiedRecord = new CopiedRecord((UnifiedRecordValue)record, recordMetadata, 1234L, 0, 4321L, 231L, 2191L);
        return new Tuple((Object)typedEvent, (Object)copiedRecord);
    }

    @Test
    public void shouldCreateSameJson() {
        Tuple<TypedRecord, CopiedRecord> records = TypedEventSerializationTest.createRecordTuple();
        String expectedJson = ((CopiedRecord)records.getRight()).toJson();
        String actualJson = ((TypedRecord)records.getLeft()).toJson();
        JsonUtil.assertEquality((String)actualJson, (String)expectedJson);
    }
}

