/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.timer;

import io.camunda.zeebe.engine.processing.timer.DueDateTimerChecker;
import io.camunda.zeebe.engine.state.immutable.TimerInstanceState;
import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.stream.api.scheduling.TaskResultBuilder;
import java.time.Duration;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class DueDateTimerCheckerTest {
    DueDateTimerCheckerTest() {
    }

    private final class TestTimerInstanceStateThatSimulatesAnEndlessListOfDueTimers
    implements TimerInstanceState {
        private final TimerInstance timer;
        private final TestActorClock testActorClock;

        private TestTimerInstanceStateThatSimulatesAnEndlessListOfDueTimers(DueDateTimerCheckerTest dueDateTimerCheckerTest, TimerInstance timer, TestActorClock testActorClock) {
            this.timer = timer;
            this.testActorClock = testActorClock;
        }

        public long processTimersWithDueDateBefore(long timestamp, TimerInstanceState.TimerVisitor consumer) {
            boolean yield = false;
            while (!yield) {
                this.testActorClock.update();
                yield = !consumer.visit(this.timer);
            }
            return 0L;
        }

        public void forEachTimerForElementInstance(long elementInstanceKey, Consumer<TimerInstance> action) {
        }

        public TimerInstance get(long elementInstanceKey, long timerKey) {
            return null;
        }
    }

    private final class TestActorClock
    implements ActorClock {
        private long time = 0L;

        private TestActorClock(DueDateTimerCheckerTest dueDateTimerCheckerTest) {
        }

        public void setTime(long time) {
            this.time = time;
        }

        public boolean update() {
            this.time += 10L;
            return true;
        }

        public long getTimeMillis() {
            return this.time;
        }

        public long getNanosSinceLastMillisecond() {
            return 0L;
        }

        public long getNanoTime() {
            return Duration.ofMillis(this.getTimeMillis()).toNanos();
        }
    }

    @Nested
    final class YieldingDecoratorTest {
        private static final int TIME_TO_YIELD = 100;
        private TimerInstance mockTimer;
        private TimerInstanceState.TimerVisitor mockDelegate;
        private final TestActorClock testActorClock;

        YieldingDecoratorTest() {
            this.testActorClock = new TestActorClock(DueDateTimerCheckerTest.this);
        }

        @BeforeEach
        void setUpMocks() {
            this.mockTimer = (TimerInstance)Mockito.mock(TimerInstance.class);
            this.mockDelegate = (TimerInstanceState.TimerVisitor)Mockito.mock(TimerInstanceState.TimerVisitor.class);
            Mockito.when((Object)this.mockDelegate.visit((TimerInstance)ArgumentMatchers.any())).thenReturn((Object)true);
        }

        @Test
        void shouldForwardCallToDelegateWhenTimeToYieldIsNotYetReached() {
            this.testActorClock.setTime(50L);
            DueDateTimerChecker.YieldingDecorator sut = new DueDateTimerChecker.YieldingDecorator((ActorClock)this.testActorClock, 100L, this.mockDelegate);
            boolean actual = sut.visit(this.mockTimer);
            Assertions.assertThat((boolean)actual).isTrue();
            ((TimerInstanceState.TimerVisitor)Mockito.verify((Object)this.mockDelegate)).visit(this.mockTimer);
        }

        @Test
        void shouldNotForwardCallToDelegateWhenTimeToYieldIsReached() {
            this.testActorClock.setTime(100L);
            DueDateTimerChecker.YieldingDecorator sut = new DueDateTimerChecker.YieldingDecorator((ActorClock)this.testActorClock, 100L, this.mockDelegate);
            boolean actual = sut.visit(this.mockTimer);
            Assertions.assertThat((boolean)actual).isFalse();
            Mockito.verifyNoInteractions((Object[])new Object[]{this.mockDelegate});
        }

        @Test
        void shouldNotForwardCallToDelegateWhenTimeToYieldHasPassed() {
            this.testActorClock.setTime(150L);
            DueDateTimerChecker.YieldingDecorator sut = new DueDateTimerChecker.YieldingDecorator((ActorClock)this.testActorClock, 100L, this.mockDelegate);
            boolean actual = sut.visit(this.mockTimer);
            Assertions.assertThat((boolean)actual).isFalse();
            Mockito.verifyNoInteractions((Object[])new Object[]{this.mockDelegate});
        }
    }

    @Nested
    final class TriggerTimersSideEffectTest {
        TriggerTimersSideEffectTest() {
        }

        @Test
        void shouldAbortIterationAndGiveYieldAfterSomeTimeHasPassed() {
            TaskResultBuilder mockTaskResultBuilder = (TaskResultBuilder)Mockito.mock(TaskResultBuilder.class);
            Mockito.when((Object)mockTaskResultBuilder.appendCommandRecord(ArgumentMatchers.anyLong(), (Intent)ArgumentMatchers.any(), (UnifiedRecordValue)ArgumentMatchers.any())).thenReturn((Object)true);
            TimerInstance mockTimer = (TimerInstance)Mockito.mock(TimerInstance.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            long timerKey = 42L;
            Mockito.when((Object)mockTimer.getKey()).thenReturn((Object)42L);
            Mockito.when((Object)mockTimer.getTenantId()).thenReturn((Object)"<default>");
            TestActorClock testActorClock = new TestActorClock(DueDateTimerCheckerTest.this);
            TestTimerInstanceStateThatSimulatesAnEndlessListOfDueTimers testTimerInstanceState = new TestTimerInstanceStateThatSimulatesAnEndlessListOfDueTimers(DueDateTimerCheckerTest.this, mockTimer, testActorClock);
            DueDateTimerChecker.TriggerTimersSideEffect sut = new DueDateTimerChecker.TriggerTimersSideEffect((TimerInstanceState)testTimerInstanceState, (ActorClock)testActorClock, true);
            sut.apply(mockTaskResultBuilder);
            ((TaskResultBuilder)Mockito.verify((Object)mockTaskResultBuilder, (VerificationMode)Mockito.times((int)4))).appendCommandRecord(ArgumentMatchers.eq((long)42L), (Intent)ArgumentMatchers.eq((Object)TimerIntent.TRIGGER), (UnifiedRecordValue)ArgumentMatchers.any());
        }

        @Test
        void shouldAbortIterationWhenRecordBatchReturnsFalseOnAppend() {
            TaskResultBuilder mockTaskResultBuilder = (TaskResultBuilder)Mockito.mock(TaskResultBuilder.class);
            Mockito.when((Object)mockTaskResultBuilder.appendCommandRecord(ArgumentMatchers.anyLong(), (Intent)ArgumentMatchers.any(), (UnifiedRecordValue)ArgumentMatchers.any())).thenReturn((Object)true).thenReturn((Object)false);
            TimerInstance mockTimer = (TimerInstance)Mockito.mock(TimerInstance.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            long timerKey = 42L;
            Mockito.when((Object)mockTimer.getKey()).thenReturn((Object)42L);
            Mockito.when((Object)mockTimer.getTenantId()).thenReturn((Object)"<default>");
            TestActorClock testActorClock = new TestActorClock(DueDateTimerCheckerTest.this);
            TestTimerInstanceStateThatSimulatesAnEndlessListOfDueTimers testTimerInstanceState = new TestTimerInstanceStateThatSimulatesAnEndlessListOfDueTimers(DueDateTimerCheckerTest.this, mockTimer, testActorClock);
            DueDateTimerChecker.TriggerTimersSideEffect sut = new DueDateTimerChecker.TriggerTimersSideEffect((TimerInstanceState)testTimerInstanceState, (ActorClock)testActorClock, true);
            sut.apply(mockTaskResultBuilder);
            ((TaskResultBuilder)Mockito.verify((Object)mockTaskResultBuilder, (VerificationMode)Mockito.times((int)2))).appendCommandRecord(ArgumentMatchers.eq((long)42L), (Intent)ArgumentMatchers.eq((Object)TimerIntent.TRIGGER), (UnifiedRecordValue)ArgumentMatchers.any());
        }
    }
}

