/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.usertask;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.UserTaskBuilder;
import io.camunda.zeebe.msgpack.spec.MsgPackHelper;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;
import io.camunda.zeebe.protocol.record.value.UserTaskRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class CompleteUserTaskTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    private static BpmnModelInstance process() {
        return ((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("task").zeebeUserTask()).endEvent().done();
    }

    @Test
    public void shouldEmitCompletingEventForUserTask() {
        ENGINE.deployment().withXmlResource(CompleteUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long userTaskKey = ((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getKey();
        Record<UserTaskRecordValue> completedRecord = ENGINE.userTask().withKey(userTaskKey).complete();
        UserTaskRecordValue recordValue = (UserTaskRecordValue)completedRecord.getValue();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(completedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.COMPLETING);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)recordValue).hasUserTaskKey(userTaskKey).hasTenantId("<default>");
    }

    @Test
    public void shouldRejectCompletionIfUserTaskNotFound() {
        int key = 123;
        Record<UserTaskRecordValue> completedRecord = ENGINE.userTask().withKey(123L).expectRejection().complete();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(completedRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldCompleteUserTaskWithVariables() {
        ENGINE.deployment().withXmlResource(CompleteUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<UserTaskRecordValue> completedRecord = ENGINE.userTask().ofInstance(processInstanceKey).withVariables("{'foo':'bar'}").complete();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(completedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.COMPLETING);
        Assertions.assertThat((Map)((UserTaskRecordValue)completedRecord.getValue()).getVariables()).containsExactly(new Map.Entry[]{Map.entry("foo", "bar")});
    }

    @Test
    public void shouldCompleteUserTaskWithNilVariables() {
        ENGINE.deployment().withXmlResource(CompleteUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<UserTaskRecordValue> completedRecord = ENGINE.userTask().ofInstance(processInstanceKey).withVariables((DirectBuffer)new UnsafeBuffer(MsgPackHelper.NIL)).complete();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(completedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.COMPLETING);
        Assertions.assertThat((Map)((UserTaskRecordValue)completedRecord.getValue()).getVariables()).isEmpty();
    }

    @Test
    public void shouldCompleteUserTaskWithZeroLengthVariables() {
        ENGINE.deployment().withXmlResource(CompleteUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<UserTaskRecordValue> completedRecord = ENGINE.userTask().ofInstance(processInstanceKey).withVariables((DirectBuffer)new UnsafeBuffer(new byte[0])).complete();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(completedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.COMPLETING);
        Assertions.assertThat((Map)((UserTaskRecordValue)completedRecord.getValue()).getVariables()).isEmpty();
    }

    @Test
    public void shouldThrowExceptionOnCompletionIfVariablesAreInvalid() {
        ENGINE.deployment().withXmlResource(CompleteUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        byte[] invalidVariables = new byte[]{1};
        Throwable throwable = Assertions.catchThrowable(() -> ENGINE.userTask().ofInstance(processInstanceKey).withVariables((DirectBuffer)new UnsafeBuffer(invalidVariables)).expectRejection().complete());
        Assertions.assertThat((Throwable)throwable).isInstanceOf(RuntimeException.class);
        Assertions.assertThat((String)throwable.getMessage()).contains(new CharSequence[]{"Property 'variables' is invalid"});
        Assertions.assertThat((String)throwable.getMessage()).contains(new CharSequence[]{"Expected document to be a root level object, but was 'INTEGER'"});
    }

    @Test
    public void shouldRejectCompletionIfUserTaskIsCompleted() {
        ENGINE.deployment().withXmlResource(CompleteUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.userTask().ofInstance(processInstanceKey).complete();
        Record<UserTaskRecordValue> completedRecord = ENGINE.userTask().ofInstance(processInstanceKey).expectRejection().complete();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(completedRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldCompleteUserTaskForCustomTenant() {
        String tenantId = "acme";
        ENGINE.deployment().withXmlResource(CompleteUserTaskTest.process()).withTenantId("acme").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("acme").create();
        Record<UserTaskRecordValue> completedRecord = ENGINE.userTask().ofInstance(processInstanceKey).withAuthorizedTenantIds("acme").complete();
        UserTaskRecordValue recordValue = (UserTaskRecordValue)completedRecord.getValue();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(completedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.COMPLETING);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)recordValue).hasTenantId("acme");
    }

    @Test
    public void shouldRejectCompletionIfTenantIsUnauthorized() {
        String tenantId = "acme";
        String falseTenantId = "foo";
        ENGINE.deployment().withXmlResource(CompleteUserTaskTest.process()).withTenantId("acme").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("acme").create();
        Record<UserTaskRecordValue> completedRecord = ENGINE.userTask().ofInstance(processInstanceKey).withAuthorizedTenantIds("foo").expectRejection().complete();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(completedRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }
}

