/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state;

import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateRule;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.MessageBatchIntent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.SignalSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.impl.records.TypedRecordImpl;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=Parameterized.class)
public final class BanInstanceTest {
    @ClassRule
    public static final ProcessingStateRule ZEEBE_STATE_RULE = new ProcessingStateRule();
    private static final AtomicLong KEY_GENERATOR = new AtomicLong(0L);
    @Parameterized.Parameter(value=0)
    public ValueType recordValueType;
    @Parameterized.Parameter(value=1)
    public Intent recordIntent;
    @Parameterized.Parameter(value=2)
    public boolean expectedToBan;
    private long processInstanceKey;

    @Parameterized.Parameters(name="{0} {1} should ban instance {2}")
    public static Object[][] parameters() {
        return new Object[][]{{ValueType.DEPLOYMENT, DeploymentIntent.CREATE, false}, {ValueType.DEPLOYMENT, DeploymentIntent.CREATED, false}, {ValueType.DEPLOYMENT, DeploymentIntent.DISTRIBUTE, false}, {ValueType.DEPLOYMENT, DeploymentIntent.DISTRIBUTED, false}, {ValueType.INCIDENT, IncidentIntent.CREATED, true}, {ValueType.INCIDENT, IncidentIntent.RESOLVED, true}, {ValueType.INCIDENT, IncidentIntent.RESOLVE, false}, {ValueType.JOB_BATCH, JobBatchIntent.ACTIVATE, false}, {ValueType.JOB_BATCH, JobBatchIntent.ACTIVATED, false}, {ValueType.JOB, JobIntent.CREATED, true}, {ValueType.JOB, JobIntent.COMPLETED, true}, {ValueType.JOB, JobIntent.TIME_OUT, true}, {ValueType.JOB, JobIntent.TIMED_OUT, true}, {ValueType.JOB, JobIntent.FAILED, true}, {ValueType.JOB, JobIntent.RETRIES_UPDATED, true}, {ValueType.JOB, JobIntent.CANCEL, true}, {ValueType.JOB, JobIntent.CANCELED, true}, {ValueType.JOB, JobIntent.COMPLETE, false}, {ValueType.JOB, JobIntent.FAIL, false}, {ValueType.JOB, JobIntent.UPDATE_RETRIES, false}, {ValueType.MESSAGE, MessageIntent.PUBLISH, false}, {ValueType.MESSAGE, MessageIntent.PUBLISHED, false}, {ValueType.MESSAGE, MessageIntent.EXPIRE, false}, {ValueType.MESSAGE, MessageIntent.EXPIRED, false}, {ValueType.MESSAGE_BATCH, MessageBatchIntent.EXPIRE, false}, {ValueType.MESSAGE_START_EVENT_SUBSCRIPTION, MessageStartEventSubscriptionIntent.CREATED, false}, {ValueType.MESSAGE_START_EVENT_SUBSCRIPTION, MessageStartEventSubscriptionIntent.DELETED, false}, {ValueType.MESSAGE_SUBSCRIPTION, MessageSubscriptionIntent.CREATE, true}, {ValueType.MESSAGE_SUBSCRIPTION, MessageSubscriptionIntent.CREATED, true}, {ValueType.MESSAGE_SUBSCRIPTION, MessageSubscriptionIntent.CORRELATE, true}, {ValueType.MESSAGE_SUBSCRIPTION, MessageSubscriptionIntent.CORRELATED, true}, {ValueType.MESSAGE_SUBSCRIPTION, MessageSubscriptionIntent.DELETE, true}, {ValueType.MESSAGE_SUBSCRIPTION, MessageSubscriptionIntent.DELETED, true}, {ValueType.SIGNAL_SUBSCRIPTION, SignalSubscriptionIntent.CREATED, false}, {ValueType.SIGNAL_SUBSCRIPTION, SignalSubscriptionIntent.DELETED, false}, {ValueType.TIMER, TimerIntent.CREATED, true}, {ValueType.TIMER, TimerIntent.TRIGGER, true}, {ValueType.TIMER, TimerIntent.TRIGGERED, true}, {ValueType.TIMER, TimerIntent.CANCEL, true}, {ValueType.TIMER, TimerIntent.CANCELED, true}, {ValueType.VARIABLE_DOCUMENT, VariableDocumentIntent.UPDATE, false}, {ValueType.VARIABLE_DOCUMENT, VariableDocumentIntent.UPDATED, false}, {ValueType.VARIABLE, VariableIntent.CREATED, false}, {ValueType.VARIABLE, VariableIntent.UPDATED, false}, {ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN, true}, {ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_ACTIVATING, true}, {ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_ACTIVATED, true}, {ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_COMPLETING, true}, {ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_COMPLETED, true}, {ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_TERMINATING, true}, {ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_TERMINATED, true}, {ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.CANCEL, false}, {ValueType.PROCESS_INSTANCE_CREATION, ProcessInstanceCreationIntent.CREATE, false}, {ValueType.PROCESS_INSTANCE_CREATION, ProcessInstanceCreationIntent.CREATED, true}, {ValueType.PROCESS_MESSAGE_SUBSCRIPTION, ProcessMessageSubscriptionIntent.CREATE, true}, {ValueType.PROCESS_MESSAGE_SUBSCRIPTION, ProcessMessageSubscriptionIntent.CREATED, true}, {ValueType.PROCESS_MESSAGE_SUBSCRIPTION, ProcessMessageSubscriptionIntent.CORRELATE, true}, {ValueType.PROCESS_MESSAGE_SUBSCRIPTION, ProcessMessageSubscriptionIntent.CORRELATED, true}, {ValueType.PROCESS_MESSAGE_SUBSCRIPTION, ProcessMessageSubscriptionIntent.DELETE, true}, {ValueType.PROCESS_MESSAGE_SUBSCRIPTION, ProcessMessageSubscriptionIntent.DELETED, true}};
    }

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.processInstanceKey = KEY_GENERATOR.getAndIncrement();
    }

    @Test
    public void shouldBanInstance() {
        RecordMetadata metadata = new RecordMetadata();
        metadata.intent(this.recordIntent);
        metadata.valueType(this.recordValueType);
        TypedRecordImpl typedEvent = new TypedRecordImpl(1);
        LoggedEvent loggedEvent = (LoggedEvent)Mockito.mock(LoggedEvent.class);
        Mockito.when((Object)loggedEvent.getPosition()).thenReturn((Object)1024L);
        typedEvent.wrap(loggedEvent, metadata, (UnifiedRecordValue)new Value());
        MutableProcessingState processingState = ZEEBE_STATE_RULE.getProcessingState();
        processingState.getBannedInstanceState().tryToBanInstance((TypedRecord)typedEvent, processInstanceKey -> {});
        metadata.intent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING);
        metadata.valueType(ValueType.PROCESS_INSTANCE);
        typedEvent.wrap(null, metadata, (UnifiedRecordValue)new Value());
        Assertions.assertThat((boolean)processingState.getBannedInstanceState().isBanned((TypedRecord)typedEvent)).isEqualTo(this.expectedToBan);
    }

    private final class Value
    extends UnifiedRecordValue
    implements ProcessInstanceRelated {
        public Value() {
            super(10);
        }

        public long getProcessInstanceKey() {
            return BanInstanceTest.this.processInstanceKey;
        }
    }
}

