/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.TransactionOperation;
import io.camunda.zeebe.db.ZeebeDbTransaction;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.migration.DbMigratorImpl;
import io.camunda.zeebe.engine.state.migration.MigrationTask;
import io.camunda.zeebe.engine.state.mutable.MutableMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DbMigratorImplTest {
    @Test
    void shouldRunMigrationThatNeedsToBeRun() {
        MutableProcessingState mockProcessingState = (MutableProcessingState)Mockito.mock(MutableProcessingState.class);
        MutableMigrationState mockMigrationState = (MutableMigrationState)Mockito.mock(MutableMigrationState.class);
        Mockito.when((Object)mockProcessingState.getMigrationState()).thenReturn((Object)mockMigrationState);
        MigrationTask mockMigration = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration.needsToRun((ProcessingState)mockProcessingState)).thenReturn((Object)true);
        DbMigratorImpl sut = new DbMigratorImpl(mockProcessingState, Collections.singletonList(mockMigration));
        sut.runMigrations();
        ((MigrationTask)Mockito.verify((Object)mockMigration)).runMigration(mockProcessingState);
    }

    @Test
    void shouldNotRunMigrationThatDoesNotNeedToBeRun() {
        MutableProcessingState mockProcessingState = (MutableProcessingState)Mockito.mock(MutableProcessingState.class);
        MutableMigrationState mockMigrationState = (MutableMigrationState)Mockito.mock(MutableMigrationState.class);
        Mockito.when((Object)mockProcessingState.getMigrationState()).thenReturn((Object)mockMigrationState);
        MigrationTask mockMigration = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration.needsToRun((ProcessingState)mockProcessingState)).thenReturn((Object)false);
        DbMigratorImpl sut = new DbMigratorImpl(mockProcessingState, Collections.singletonList(mockMigration));
        sut.runMigrations();
        ((MigrationTask)Mockito.verify((Object)mockMigration, (VerificationMode)Mockito.never())).runMigration(mockProcessingState);
    }

    @Test
    void shouldRunMigrationsInOrder() {
        MutableProcessingState mockProcessingState = (MutableProcessingState)Mockito.mock(MutableProcessingState.class);
        MutableMigrationState mockMigrationState = (MutableMigrationState)Mockito.mock(MutableMigrationState.class);
        Mockito.when((Object)mockProcessingState.getMigrationState()).thenReturn((Object)mockMigrationState);
        MigrationTask mockMigration1 = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration1.needsToRun((ProcessingState)mockProcessingState)).thenReturn((Object)true);
        MigrationTask mockMigration2 = (MigrationTask)Mockito.mock(MigrationTask.class);
        Mockito.when((Object)mockMigration2.needsToRun((ProcessingState)mockProcessingState)).thenReturn((Object)true);
        DbMigratorImpl sut = new DbMigratorImpl(mockProcessingState, List.of(mockMigration1, mockMigration2));
        sut.runMigrations();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockMigration1, mockMigration2});
        ((MigrationTask)inOrder.verify((Object)mockMigration1)).runMigration(mockProcessingState);
        ((MigrationTask)inOrder.verify((Object)mockMigration2)).runMigration(mockProcessingState);
    }

    private static final class RunInTransactionContext
    implements TransactionContext {
        private final ZeebeDbTransaction transaction;

        private RunInTransactionContext(ZeebeDbTransaction transaction) {
            this.transaction = transaction;
        }

        public void runInTransaction(TransactionOperation operations) {
            try {
                operations.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public ZeebeDbTransaction getCurrentTransaction() {
            return this.transaction;
        }
    }
}

