/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_1_1;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.ObjectProperty;
import io.camunda.zeebe.msgpack.value.ObjectValue;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;

public final class LegacyProcessMessageSubscription
extends UnpackedObject
implements DbValue {
    private final ObjectProperty<ProcessMessageSubscriptionRecord> recordProp = new ObjectProperty("record", (ObjectValue)new ProcessMessageSubscriptionRecord());
    private final LongProperty commandSentTimeProp = new LongProperty("commandSentTime", 0L);
    private final EnumProperty<State> stateProp = new EnumProperty("state", State.class, (Enum)State.STATE_OPENING);
    private final LongProperty keyProp = new LongProperty("key");

    public LegacyProcessMessageSubscription() {
        super(4);
        this.declareProperty((BaseProperty)this.recordProp).declareProperty((BaseProperty)this.commandSentTimeProp).declareProperty(this.stateProp).declareProperty((BaseProperty)this.keyProp);
    }

    public ProcessMessageSubscriptionRecord getRecord() {
        return (ProcessMessageSubscriptionRecord)this.recordProp.getValue();
    }

    public LegacyProcessMessageSubscription setRecord(ProcessMessageSubscriptionRecord record) {
        ((ProcessMessageSubscriptionRecord)this.recordProp.getValue()).wrap(record);
        return this;
    }

    public long getCommandSentTime() {
        return this.commandSentTimeProp.getValue();
    }

    public LegacyProcessMessageSubscription setCommandSentTime(long commandSentTime) {
        this.commandSentTimeProp.setValue(commandSentTime);
        return this;
    }

    public boolean isOpening() {
        return this.stateProp.getValue() == State.STATE_OPENING;
    }

    public LegacyProcessMessageSubscription setOpened() {
        this.stateProp.setValue((Enum)State.STATE_OPENED);
        return this;
    }

    public boolean isClosing() {
        return this.stateProp.getValue() == State.STATE_CLOSING;
    }

    public LegacyProcessMessageSubscription setClosing() {
        this.stateProp.setValue((Enum)State.STATE_CLOSING);
        return this;
    }

    public long getKey() {
        return this.keyProp.getValue();
    }

    public LegacyProcessMessageSubscription setKey(long key) {
        this.keyProp.setValue(key);
        return this;
    }

    private static enum State {
        STATE_OPENING,
        STATE_OPENED,
        STATE_CLOSING;

    }
}

