/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_1_1;

import io.camunda.zeebe.engine.state.migration.to_1_1.LegacyMessageSubscription;
import io.camunda.zeebe.engine.state.migration.to_1_1.LegacyProcessMessageSubscription;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;

class TestUtilities {
    TestUtilities() {
    }

    static LegacyMessageSubscription createLegacyMessageSubscription(long key, long elementInstanceKey) {
        LegacyMessageSubscription subscription = new LegacyMessageSubscription();
        MessageSubscriptionRecord record = TestUtilities.createMessageSubscriptionRecord(elementInstanceKey);
        subscription.setRecord(record);
        subscription.setKey(key);
        return subscription;
    }

    static MessageSubscriptionRecord createMessageSubscriptionRecord(long elementInstanceKey) {
        MessageSubscriptionRecord record = new MessageSubscriptionRecord();
        record.setProcessInstanceKey(0L);
        record.setElementInstanceKey(elementInstanceKey);
        record.setMessageName(BufferUtil.wrapString((String)"messageName"));
        return record;
    }

    static LegacyProcessMessageSubscription createLegacyProcessMessageSubscription(long key, long elementInstanceKey) {
        LegacyProcessMessageSubscription subscription = new LegacyProcessMessageSubscription();
        ProcessMessageSubscriptionRecord record = TestUtilities.createProcessMessageSubscriptionRecord(elementInstanceKey);
        subscription.setRecord(record);
        subscription.setKey(key);
        return subscription;
    }

    static ProcessMessageSubscriptionRecord createProcessMessageSubscriptionRecord(long elementInstanceKey) {
        ProcessMessageSubscriptionRecord record = new ProcessMessageSubscriptionRecord();
        record.setProcessInstanceKey(0L);
        record.setSubscriptionPartitionId(0);
        record.setElementInstanceKey(elementInstanceKey);
        record.setMessageName(BufferUtil.wrapString((String)"messageName"));
        return record;
    }
}

