/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_2;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.migration.to_8_2.DecisionRequirementsMigration;
import io.camunda.zeebe.engine.state.migration.to_8_2.LegacyDecisionState;
import io.camunda.zeebe.engine.state.mutable.MutableMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class DecisionRequirementsMigrationTest {
    final DecisionRequirementsMigration sutMigration = new DecisionRequirementsMigration();

    @Nested
    @ExtendWith(value={ProcessingStateExtension.class})
    public class BlackboxTest {
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private MutableProcessingState processingState;
        private TransactionContext transactionContext;
        private LegacyDecisionState legacyDecisionState;
        private DbLong dbDecisionRequirementsKey;
        private DbForeignKey<DbLong> fkDecisionRequirements;
        private DbString dbDecisionRequirementsId;
        private DbInt dbDecisionRequirementsVersion;
        private DbCompositeKey<DbString, DbInt> decisionRequirementsIdAndVersion;
        private ColumnFamily<DbCompositeKey<DbString, DbInt>, DbForeignKey<DbLong>> decisionRequirementsKeyByIdAndVersion;

        @BeforeEach
        public void setup() {
            this.legacyDecisionState = new LegacyDecisionState(this.zeebeDb, this.transactionContext);
            this.dbDecisionRequirementsKey = new DbLong();
            this.fkDecisionRequirements = new DbForeignKey((DbKey)this.dbDecisionRequirementsKey, (Enum)ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS);
            this.dbDecisionRequirementsId = new DbString();
            this.dbDecisionRequirementsVersion = new DbInt();
            this.decisionRequirementsIdAndVersion = new DbCompositeKey((DbKey)this.dbDecisionRequirementsId, (DbKey)this.dbDecisionRequirementsVersion);
            this.decisionRequirementsKeyByIdAndVersion = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS_KEY_BY_DECISION_REQUIREMENT_ID_AND_VERSION, this.transactionContext, this.decisionRequirementsIdAndVersion, this.fkDecisionRequirements);
        }

        @Test
        public void afterMigrationRunNoFurtherMigrationIsNeeded() {
            long key = 123L;
            this.legacyDecisionState.putDecisionRequirements(123L, this.sampleDecisionRequirementsRecord().setDecisionRequirementsKey(123L));
            DecisionRequirementsMigrationTest.this.sutMigration.runMigration(this.processingState);
            boolean shouldRun = DecisionRequirementsMigrationTest.this.sutMigration.needsToRun((ProcessingState)this.processingState);
            Assertions.assertThat((boolean)shouldRun).isFalse();
        }

        @Test
        public void shouldFindCorrectDrgKeyAfterMigration() {
            DecisionRequirementsRecord drg1 = this.sampleDecisionRequirementsRecord().setDecisionRequirementsVersion(1).setDecisionRequirementsKey(111L);
            DecisionRequirementsRecord drg2 = this.sampleDecisionRequirementsRecord().setDecisionRequirementsVersion(2).setDecisionRequirementsKey(222L);
            this.legacyDecisionState.putDecisionRequirements(drg1.getDecisionRequirementsKey(), drg1);
            this.legacyDecisionState.putDecisionRequirements(drg2.getDecisionRequirementsKey(), drg2);
            DecisionRequirementsMigrationTest.this.sutMigration.runMigration(this.processingState);
            this.assertContainsDecisionRequirements(drg1);
            this.assertContainsDecisionRequirements(drg2);
        }

        private DecisionRequirementsRecord sampleDecisionRequirementsRecord() {
            return new DecisionRequirementsRecord().setDecisionRequirementsId("drg-id").setDecisionRequirementsName("drg-name").setDecisionRequirementsVersion(1).setDecisionRequirementsKey(1L).setNamespace("namespace").setResourceName("resource-name").setChecksum(BufferUtil.wrapString((String)"checksum")).setResource(BufferUtil.wrapString((String)"dmn-resource"));
        }

        private void assertContainsDecisionRequirements(DecisionRequirementsRecord drgRecord) {
            this.dbDecisionRequirementsId.wrapString(drgRecord.getDecisionRequirementsId());
            this.dbDecisionRequirementsKey.wrapLong(drgRecord.getDecisionRequirementsKey());
            this.dbDecisionRequirementsVersion.wrapInt(drgRecord.getDecisionRequirementsVersion());
            Assertions.assertThat((boolean)this.decisionRequirementsKeyByIdAndVersion.exists(this.decisionRequirementsIdAndVersion)).isTrue();
            Assertions.assertThat((long)((DbLong)((DbForeignKey)this.decisionRequirementsKeyByIdAndVersion.get(this.decisionRequirementsIdAndVersion)).inner()).getValue()).isEqualTo(drgRecord.getDecisionRequirementsKey());
        }
    }

    @Nested
    public class MockBasedTests {
        @Test
        public void noMigrationNeededWhenDecisionsRequirementsColumnFamilyIsEmpty() {
            ProcessingState mockProcessingState = (ProcessingState)Mockito.mock(ProcessingState.class);
            Mockito.when((Object)mockProcessingState.isEmpty(ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS)).thenReturn((Object)true);
            Mockito.when((Object)mockProcessingState.isEmpty(ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS_KEY_BY_DECISION_REQUIREMENT_ID_AND_VERSION)).thenReturn((Object)true);
            boolean actual = DecisionRequirementsMigrationTest.this.sutMigration.needsToRun(mockProcessingState);
            Assertions.assertThat((boolean)actual).isFalse();
        }

        @Test
        public void noMigrationNeededWhenVersionColumnFamilyIsPopulated() {
            ProcessingState mockProcessingState = (ProcessingState)Mockito.mock(ProcessingState.class);
            Mockito.when((Object)mockProcessingState.isEmpty(ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS)).thenReturn((Object)false);
            Mockito.when((Object)mockProcessingState.isEmpty(ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS_KEY_BY_DECISION_REQUIREMENT_ID_AND_VERSION)).thenReturn((Object)false);
            boolean actual = DecisionRequirementsMigrationTest.this.sutMigration.needsToRun(mockProcessingState);
            Assertions.assertThat((boolean)actual).isFalse();
        }

        @Test
        public void migrationNeededWhenDecisionHaveNotBeenMigratedYet() {
            ProcessingState mockProcessingState = (ProcessingState)Mockito.mock(ProcessingState.class);
            Mockito.when((Object)mockProcessingState.isEmpty(ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS)).thenReturn((Object)false);
            Mockito.when((Object)mockProcessingState.isEmpty(ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS_KEY_BY_DECISION_REQUIREMENT_ID_AND_VERSION)).thenReturn((Object)true);
            boolean actual = DecisionRequirementsMigrationTest.this.sutMigration.needsToRun(mockProcessingState);
            Assertions.assertThat((boolean)actual).isTrue();
        }

        @Test
        public void migrationCallsMethodInMigrationState() {
            MutableProcessingState mockProcessingState = (MutableProcessingState)Mockito.mock(MutableProcessingState.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            DecisionRequirementsMigrationTest.this.sutMigration.runMigration(mockProcessingState);
            ((MutableMigrationState)Mockito.verify((Object)mockProcessingState.getMigrationState())).migrateDrgPopulateDrgVersionByDrgIdAndKey();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockProcessingState.getMigrationState()});
        }
    }
}

