/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util.client;

import io.camunda.zeebe.engine.util.client.CommandWriter;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.List;
import java.util.function.Function;

public final class IncidentClient {
    private final CommandWriter writer;

    public IncidentClient(CommandWriter writer) {
        this.writer = writer;
    }

    public ResolveIncidentClient ofInstance(long processInstanceKey) {
        return new ResolveIncidentClient(this.writer, processInstanceKey);
    }

    public static class ResolveIncidentClient {
        private static final long DEFAULT_KEY = -1L;
        private static final Function<Long, Record<IncidentRecordValue>> SUCCESS_SUPPLIER = position -> (Record)((IncidentRecordStream)((IncidentRecordStream)RecordingExporter.incidentRecords().withSourceRecordPosition(position.longValue())).withIntent((Intent)IncidentIntent.RESOLVED)).getFirst();
        private static final Function<Long, Record<IncidentRecordValue>> REJECTION_SUPPLIER = position -> (Record)((IncidentRecordStream)((IncidentRecordStream)RecordingExporter.incidentRecords().onlyCommandRejections()).withSourceRecordPosition(position.longValue())).getFirst();
        private final CommandWriter writer;
        private final long processInstanceKey;
        private final IncidentRecord incidentRecord;
        private long incidentKey = -1L;
        private List<String> authorizedTenantIds = List.of("<default>");
        private Function<Long, Record<IncidentRecordValue>> expectation = SUCCESS_SUPPLIER;

        public ResolveIncidentClient(CommandWriter writer, long processInstanceKey) {
            this.writer = writer;
            this.processInstanceKey = processInstanceKey;
            this.incidentRecord = new IncidentRecord();
        }

        public ResolveIncidentClient withKey(long incidentKey) {
            this.incidentKey = incidentKey;
            return this;
        }

        public ResolveIncidentClient withAuthorizedTenantIds(String ... tenantIds) {
            this.authorizedTenantIds = List.of(tenantIds);
            return this;
        }

        public ResolveIncidentClient expectRejection() {
            this.expectation = REJECTION_SUPPLIER;
            return this;
        }

        public Record<IncidentRecordValue> resolve() {
            if (this.incidentKey == -1L) {
                this.incidentKey = ((Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(this.processInstanceKey).getFirst()).getKey();
            }
            long position = this.writer.writeCommandOnPartition(Protocol.decodePartitionId((long)this.incidentKey), this.incidentKey, (Intent)IncidentIntent.RESOLVE, (UnifiedRecordValue)this.incidentRecord, this.authorizedTenantIds.toArray(new String[0]));
            return this.expectation.apply(position);
        }
    }
}

