/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util.client;

import io.camunda.zeebe.engine.util.client.CommandWriter;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.SignalIntent;
import io.camunda.zeebe.protocol.record.value.SignalRecordValue;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.SignalRecordStream;
import java.util.Map;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class SignalClient {
    private static final Function<Long, Record<SignalRecordValue>> SUCCESS_EXPECTATION = position -> (Record)((SignalRecordStream)RecordingExporter.signalRecords((SignalIntent)SignalIntent.BROADCASTED).withSourceRecordPosition(position.longValue())).getFirst();
    private final CommandWriter writer;
    private final SignalRecord signalRecord = new SignalRecord();
    private final Function<Long, Record<SignalRecordValue>> expectation = SUCCESS_EXPECTATION;

    public SignalClient(CommandWriter writer) {
        this.writer = writer;
    }

    public SignalClient withSignalName(String signalName) {
        this.signalRecord.setSignalName(signalName);
        return this;
    }

    public SignalClient withVariables(String variables) {
        this.signalRecord.setVariables((DirectBuffer)new UnsafeBuffer(MsgPackConverter.convertToMsgPack((String)variables)));
        return this;
    }

    public SignalClient withVariables(DirectBuffer variables) {
        this.signalRecord.setVariables(variables);
        return this;
    }

    public SignalClient withVariable(String key, Object value) {
        this.signalRecord.setVariables(MsgPackUtil.asMsgPack((String)key, (Object)value));
        return this;
    }

    public SignalClient withVariables(Map<String, Object> variables) {
        this.signalRecord.setVariables(MsgPackUtil.asMsgPack(variables));
        return this;
    }

    public SignalClient withTenantId(String tenantId) {
        this.signalRecord.setTenantId(tenantId);
        return this;
    }

    public Record<SignalRecordValue> broadcast() {
        long position = this.writer.writeCommand((Intent)SignalIntent.BROADCAST, (UnifiedRecordValue)this.signalRecord);
        return this.expectation.apply(position);
    }
}

