/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.activity;

import io.camunda.zeebe.engine.processing.variable.mapping.VariableValue;
import io.camunda.zeebe.engine.state.immutable.UserTaskState;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.UserTaskBuilder;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.UserTaskRecordValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.groups.Tuple;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class NativeUserTaskTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final String FOLLOW_UP_DATE = "2023-02-28T08:16:23+02:00";
    private static final String DUE_DATE = "2023-02-28T09:16:23+02:00";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private UserTaskState userTaskState;

    private static BpmnModelInstance process() {
        return NativeUserTaskTest.process(b -> {});
    }

    private static BpmnModelInstance process(Consumer<UserTaskBuilder> consumer) {
        UserTaskBuilder builder = (UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("task").zeebeUserTask();
        consumer.accept(builder);
        return builder.endEvent().done();
    }

    @Before
    public void setUp() {
        this.userTaskState = ENGINE.getProcessingState().getUserTaskState();
    }

    @Test
    public void shouldActivateUserTask() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.USER_TASK).withTenantId("<default>").limit(3L)).extracting(new Function[]{Record::getRecordType, Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{RecordType.COMMAND, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED})});
        Record userTask = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withTenantId("<default>").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withElementType(BpmnElementType.USER_TASK).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)userTask.getValue())).hasElementId("task").hasBpmnElementType(BpmnElementType.USER_TASK).hasFlowScopeKey(processInstanceKey).hasBpmnProcessId(PROCESS_ID).hasProcessInstanceKey(processInstanceKey);
    }

    @Test
    public void shouldActivateUserTaskForCustomTenant() {
        String tenantId = "foo";
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process()).withTenantId("foo").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("foo").create();
        Record userTask = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withElementType(BpmnElementType.USER_TASK).withTenantId("foo").getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)userTask.getValue())).hasTenantId("foo");
    }

    @Test
    public void shouldCreateUserTask() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record taskActivated = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withElementType(BpmnElementType.USER_TASK).getFirst();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasElementInstanceKey(taskActivated.getKey()).hasElementId(((ProcessInstanceRecordValue)taskActivated.getValue()).getElementId()).hasProcessDefinitionKey(((ProcessInstanceRecordValue)taskActivated.getValue()).getProcessDefinitionKey()).hasBpmnProcessId(((ProcessInstanceRecordValue)taskActivated.getValue()).getBpmnProcessId()).hasProcessDefinitionVersion(((ProcessInstanceRecordValue)taskActivated.getValue()).getVersion());
        Assertions.assertThat((long)((UserTaskRecordValue)userTask.getValue()).getUserTaskKey()).isGreaterThan(0L);
    }

    @Test
    public void shouldCreateUserTaskWithCustomHeaders() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> ((UserTaskBuilder)t.zeebeTaskHeader("a", "b")).zeebeTaskHeader("c", "d"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Map customHeaders = ((UserTaskRecordValue)userTask.getValue()).getCustomHeaders();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)customHeaders).hasSize(2)).containsEntry((Object)"a", (Object)"b")).containsEntry((Object)"c", (Object)"d");
    }

    @Test
    public void shouldPickUpCustomFormForUserTask() {
        String externalReference = "http://example.com/my-external-form";
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeExternalFormReference("http://example.com/my-external-form"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasFormKey(-1L).hasExternalFormReference("http://example.com/my-external-form");
    }

    @Test
    public void shouldPickUpCustomFormExpressionForUserTask() {
        String externalReference = "http://example.com/my-external-form";
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeExternalFormReferenceExpression("externalReference"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("externalReference", "http://example.com/my-external-form").create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasFormKey(-1L).hasExternalFormReference("http://example.com/my-external-form");
    }

    @Test
    public void shouldNotPickUpEmbeddedFormForUserTask() {
        String formKey = Strings.newRandomValidBpmnId();
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> ((UserTaskBuilder)t.zeebeFormKey(formKey)).zeebeExternalFormReference("foo"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasFormKey(-1L);
    }

    @Test
    public void shouldNotPickUpEmbeddedFormWithJsonForUserTask() {
        String formKey = Strings.newRandomValidBpmnId();
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> ((UserTaskBuilder)t.zeebeUserTaskForm(formKey, "User Task Form")).zeebeExternalFormReference("foo"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasFormKey(-1L);
    }

    @Test
    public void shouldCreateUserTaskWithAssignee() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeAssignee("alice"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasAssignee("alice");
    }

    @Test
    public void shouldCreateUserTaskWithStaticNumberValueAssignee() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeAssignee("1234567891011121314"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasAssignee("1234567891011121314");
    }

    @Test
    public void shouldCreateUserTaskWithEvaluatedAssigneeExpression() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeAssigneeExpression("user"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("user", "alice")).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasAssignee("alice");
    }

    @Test
    public void shouldCreateUserTaskWithEmptyEvaluatedAssigneeExpression() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeAssigneeExpression("user"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("user", "")).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasAssignee("");
    }

    @Test
    public void shouldCreateUserTaskWithCandidateGroups() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeCandidateGroups("alice,bob"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasCandidateGroupsList(new String[]{"alice", "bob"});
    }

    @Test
    public void shouldCreateUserTaskWithEvaluatedCandidateGroupsExpression() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeCandidateGroupsExpression("users"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables("{ \"users\": [\"alice\", \"bob\"] }").create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasCandidateGroupsList(new String[]{"alice", "bob"});
    }

    @Test
    public void shouldCreateUserTaskWithCandidateUsers() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeCandidateUsers("jack,rose"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasCandidateUsersList(new String[]{"jack", "rose"});
    }

    @Test
    public void shouldCreateUserTaskWithEvaluatedCandidateUsersExpression() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeCandidateUsersExpression("users"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables("{ \"users\": [\"jack\", \"rose\"] }").create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasCandidateUsersList(new String[]{"jack", "rose"});
    }

    @Test
    public void shouldCreateUserTaskWithDueDate() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeDueDate(DUE_DATE))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasDueDate(DUE_DATE);
    }

    @Test
    public void shouldCreateUserTaskWithEvaluatedDueDateExpression() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeDueDateExpression("dueDate"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("dueDate", DUE_DATE)).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasDueDate(DUE_DATE);
    }

    @Test
    public void shouldCreateUserTaskAndIgnoreEmptyDueDate() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeDueDate(""))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasDueDate("");
    }

    @Test
    public void shouldCreateUserTaskAndIgnoreEmptyEvaluatedDueDateExpression() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeDueDateExpression("=dueDate"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("dueDate", "")).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasDueDate("");
    }

    @Test
    public void shouldCreateUserTaskAndIgnoreNullEvaluatedDueDateExpression() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeDueDateExpression("=null"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasDueDate("");
    }

    @Test
    public void shouldCreateUserTaskWithFollowUpDate() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeFollowUpDate(FOLLOW_UP_DATE))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasFollowUpDate(FOLLOW_UP_DATE);
    }

    @Test
    public void shouldCreateUserTaskWithEvaluatedFollowUpDateExpression() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeFollowUpDateExpression("followUpDate"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("followUpDate", FOLLOW_UP_DATE)).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasFollowUpDate(FOLLOW_UP_DATE);
    }

    @Test
    public void shouldCreateUserTaskAndIgnoreEmptyFollowUpDate() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeFollowUpDate(""))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasFollowUpDate("");
    }

    @Test
    public void shouldCreateUserTaskAndIgnoreEmptyEvaluatedFollowUpDateExpression() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeFollowUpDateExpression("=followUpDate"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("followUpDate", "")).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasFollowUpDate("");
    }

    @Test
    public void shouldCreateUserTaskAndIgnoreNullEvaluatedFollowUpDateExpression() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeFollowUpDateExpression("=null"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)userTask.getValue())).hasFollowUpDate("");
    }

    @Test
    public void shouldCreateUserTaskWithCreationTimestampGreaterThanZero() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTask = (Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Assertions.assertThat((long)((UserTaskRecordValue)userTask.getValue()).getCreationTimestamp()).isGreaterThan(0L);
    }

    @Test
    public void shouldAssignUserTask() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.userTask().ofInstance(processInstanceKey).withAssignee("foo").assign();
        UserTaskRecordValue createdUserTask = (UserTaskRecordValue)((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getValue();
        Assertions.assertThat((Stream)RecordingExporter.userTaskRecords().withProcessInstanceKey(processInstanceKey)).extracting(new Function[]{Record::getValueType, Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ValueType.USER_TASK, UserTaskIntent.ASSIGNING}), Assertions.tuple((Object[])new Object[]{ValueType.USER_TASK, UserTaskIntent.ASSIGNED})});
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.ASSIGNED).withProcessInstanceKey(processInstanceKey).getFirst()).getValue())).hasAssignee("foo");
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)this.userTaskState.getUserTask(createdUserTask.getUserTaskKey())).hasAssignee("foo");
    }

    @Test
    public void shouldClaimUserTask() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.userTask().ofInstance(processInstanceKey).withAssignee("foo").claim();
        UserTaskRecordValue createdUserTask = (UserTaskRecordValue)((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getValue();
        Assertions.assertThat((Stream)RecordingExporter.userTaskRecords().withProcessInstanceKey(processInstanceKey)).extracting(new Function[]{Record::getValueType, Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ValueType.USER_TASK, UserTaskIntent.ASSIGNING}), Assertions.tuple((Object[])new Object[]{ValueType.USER_TASK, UserTaskIntent.ASSIGNED})});
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.ASSIGNED).withProcessInstanceKey(processInstanceKey).getFirst()).getValue())).hasAssignee("foo");
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)this.userTaskState.getUserTask(createdUserTask.getUserTaskKey())).hasAssignee("foo");
    }

    @Test
    public void shouldUpdateUserTaskAttributes() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)t.zeebeCandidateGroups("foo, bar")).zeebeCandidateUsers("oof, rab")).zeebeFollowUpDate("2023-03-02T15:35+02:00")).zeebeDueDate("2023-03-02T16:35+02:00"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.userTask().ofInstance(processInstanceKey).update(new UserTaskRecord());
        UserTaskRecordValue createdUserTask = (UserTaskRecordValue)((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getValue();
        Assertions.assertThat((Stream)RecordingExporter.userTaskRecords().withProcessInstanceKey(processInstanceKey)).extracting(new Function[]{Record::getValueType, Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ValueType.USER_TASK, UserTaskIntent.UPDATING}), Assertions.tuple((Object[])new Object[]{ValueType.USER_TASK, UserTaskIntent.UPDATED})});
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)createdUserTask).hasCandidateGroupsList(new String[]{"foo", "bar"}).hasCandidateUsersList(new String[]{"oof", "rab"}).hasDueDate("2023-03-02T16:35+02:00").hasFollowUpDate("2023-03-02T15:35+02:00").hasNoChangedAttributes();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.UPDATED).withProcessInstanceKey(processInstanceKey).getFirst()).getValue())).hasNoCandidateGroupsList().hasNoCandidateUsersList().hasDueDate("").hasFollowUpDate("").hasChangedAttributes(new String[]{"candidateGroupsList", "candidateUsersList", "dueDate", "followUpDate"});
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)this.userTaskState.getUserTask(createdUserTask.getUserTaskKey())).hasNoCandidateGroupsList().hasNoCandidateUsersList().hasDueDate("").hasFollowUpDate("").hasNoChangedAttributes();
    }

    @Test
    public void shouldCompleteUserTask() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.userTask().ofInstance(processInstanceKey).complete();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SEQUENCE_FLOW, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        Assertions.assertThat((Stream)RecordingExporter.userTaskRecords().withProcessInstanceKey(processInstanceKey)).extracting(new Function[]{Record::getValueType, Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ValueType.USER_TASK, UserTaskIntent.COMPLETING}), Assertions.tuple((Object[])new Object[]{ValueType.USER_TASK, UserTaskIntent.COMPLETED})});
    }

    @Test
    public void shouldCompleteUserTaskWithVariables() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.userTask().ofInstance(processInstanceKey).withVariable("foo", "bar").complete();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SEQUENCE_FLOW, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        Assertions.assertThat((Stream)RecordingExporter.userTaskRecords().withProcessInstanceKey(processInstanceKey)).extracting(new Function[]{Record::getValueType, Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ValueType.USER_TASK, UserTaskIntent.COMPLETING}), Assertions.tuple((Object[])new Object[]{ValueType.USER_TASK, UserTaskIntent.COMPLETED})});
        Assertions.assertThat((Stream)RecordingExporter.variableRecords().withProcessInstanceKey(processInstanceKey).limit(1L)).extracting(Record::getValue).extracting(v -> VariableValue.variable(v.getName(), v.getValue())).containsExactly((Object[])new VariableValue[]{VariableValue.variable("foo", "\"bar\"")});
    }

    @Test
    public void shouldResolveIncidentsWhenTerminating() {
        ENGINE.deployment().withXmlResource(NativeUserTaskTest.process(t -> t.zeebeInputExpression("assert(nonexisting_variable, nonexisting_variable != null)", "target"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("foo", 10).create();
        Assertions.assertThat((Stream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).limit(1L)).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{IncidentIntent.CREATED});
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceTerminated()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED})});
        Assertions.assertThat((Stream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).limit(2L)).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{IncidentIntent.CREATED, IncidentIntent.RESOLVED});
    }
}

