/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.compensation;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractActivityBuilder;
import io.camunda.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.camunda.zeebe.model.bpmn.builder.AbstractTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.BusinessRuleTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import io.camunda.zeebe.model.bpmn.builder.ScriptTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompensationEventCompatibilityTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final String CHILD_PROCESS_ID = "child-process";
    private static final String DECISION_ID = "jedi_or_sith";
    private static final String JOB_TYPE = "job-type";
    private static final List<Scenario> SCENARIOS = List.of(Scenario.of("undefined task", BpmnElementType.TASK, AbstractFlowNodeBuilder::task), Scenario.of("manual task", BpmnElementType.MANUAL_TASK, AbstractFlowNodeBuilder::manualTask), Scenario.of("service task", BpmnElementType.SERVICE_TASK, b -> b.serviceTask().zeebeJobType(JOB_TYPE), CompensationEventCompatibilityTest::completeJob), Scenario.of("user task (job worker)", BpmnElementType.USER_TASK, AbstractFlowNodeBuilder::userTask, processInstanceKey -> ENGINE.job().ofInstance(processInstanceKey).withType("io.camunda.zeebe:userTask").complete()), Scenario.of("user task (native)", BpmnElementType.USER_TASK, b -> b.userTask().zeebeUserTask(), processInstanceKey -> ENGINE.userTask().ofInstance(processInstanceKey).complete()), Scenario.of("receive task", BpmnElementType.RECEIVE_TASK, b -> b.receiveTask().message(m -> m.name("message").zeebeCorrelationKeyExpression("1")), processInstanceKey -> ENGINE.message().withName("message").withCorrelationKey("1").publish()), Scenario.of("send task", BpmnElementType.SEND_TASK, b -> b.sendTask().zeebeJobType(JOB_TYPE), CompensationEventCompatibilityTest::completeJob), Scenario.of("business rule task (job worker)", BpmnElementType.BUSINESS_RULE_TASK, b -> b.businessRuleTask().zeebeJobType(JOB_TYPE), CompensationEventCompatibilityTest::completeJob), Scenario.of("business rule task (DMN)", BpmnElementType.BUSINESS_RULE_TASK, b -> ((BusinessRuleTaskBuilder)b.businessRuleTask().zeebeCalledDecisionId(DECISION_ID)).zeebeResultVariable("result")), Scenario.of("script task (job worker)", BpmnElementType.SCRIPT_TASK, b -> b.scriptTask().zeebeJobType(JOB_TYPE), CompensationEventCompatibilityTest::completeJob), Scenario.of("script task (FEEL)", BpmnElementType.SCRIPT_TASK, b -> ((ScriptTaskBuilder)b.scriptTask().zeebeExpression("true")).zeebeResultVariable("result")), Scenario.of("subprocess", BpmnElementType.SUB_PROCESS, b -> b.subProcess("subprocess", subprocess -> subprocess.embeddedSubProcess().startEvent().endEvent())), Scenario.of("call activity", BpmnElementType.CALL_ACTIVITY, b -> b.callActivity().zeebeProcessId(CHILD_PROCESS_ID)), Scenario.of("parallel multi-instance", BpmnElementType.MULTI_INSTANCE_BODY, b -> b.manualTask().multiInstance(m -> ((MultiInstanceLoopCharacteristicsBuilder)m.zeebeInputCollectionExpression("[1,2]")).parallel())), Scenario.of("sequential multi-instance", BpmnElementType.MULTI_INSTANCE_BODY, b -> b.manualTask().multiInstance(m -> ((MultiInstanceLoopCharacteristicsBuilder)m.zeebeInputCollectionExpression("[1,2]")).sequential())));
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private final Scenario scenario;

    public CompensationEventCompatibilityTest(Scenario scenario) {
        this.scenario = scenario;
    }

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> scenarios() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @BeforeClass
    public static void deployResources() {
        BpmnModelInstance childProcess = Bpmn.createExecutableProcess((String)CHILD_PROCESS_ID).startEvent().endEvent().done();
        ENGINE.deployment().withXmlResource(childProcess).withXmlClasspathResource("/dmn/decision-table.dmn").deploy();
    }

    @Test
    public void shouldCompensateActivity() {
        StartEventBuilder processBuilder = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent();
        AbstractActivityBuilder<?, ?> compensationActivity = this.scenario.builder.apply((AbstractFlowNodeBuilder<?, ?>)processBuilder);
        compensationActivity.boundaryEvent().compensation(compensation -> compensation.task("compensation-handler"));
        BpmnModelInstance process = compensationActivity.endEvent().compensateEventDefinition().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        this.scenario.completionAction.accept(processInstanceKey);
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnEventType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{this.scenario.bpmnElementType, this.scenario.bpmnEventType, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, BpmnEventType.COMPENSATION, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.TASK, BpmnEventType.COMPENSATION, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, BpmnEventType.COMPENSATION, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, BpmnEventType.UNSPECIFIED, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldInvokeCompensationHandler() {
        StartEventBuilder processBuilder = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent();
        AbstractTaskBuilder compensationActivity = processBuilder.task("compensation-activity");
        compensationActivity.boundaryEvent().compensation(this.scenario.builder::apply);
        BpmnModelInstance process = compensationActivity.endEvent().compensateEventDefinition().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        this.scenario.completionAction.accept(processInstanceKey);
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnEventType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, BpmnEventType.COMPENSATION, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{this.scenario.bpmnElementType, BpmnEventType.COMPENSATION, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{this.scenario.bpmnElementType, BpmnEventType.COMPENSATION, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, BpmnEventType.COMPENSATION, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, BpmnEventType.UNSPECIFIED, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    private static void completeJob(long processInstanceKey) {
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).complete();
    }

    private record Scenario(String name, BpmnElementType bpmnElementType, BpmnEventType bpmnEventType, Function<AbstractFlowNodeBuilder<?, ?>, AbstractActivityBuilder<?, ?>> builder, LongConsumer completionAction) {
        @Override
        public String toString() {
            return this.name;
        }

        private static Scenario of(String name, BpmnElementType bpmnElementType, Function<AbstractFlowNodeBuilder<?, ?>, AbstractActivityBuilder<?, ?>> builder) {
            return Scenario.of(name, bpmnElementType, builder, key -> {});
        }

        private static Scenario of(String name, BpmnElementType bpmnElementType, Function<AbstractFlowNodeBuilder<?, ?>, AbstractActivityBuilder<?, ?>> builder, LongConsumer completionAction) {
            BpmnEventType bpmnEventType = bpmnElementType == BpmnElementType.RECEIVE_TASK ? BpmnEventType.MESSAGE : BpmnEventType.UNSPECIFIED;
            return new Scenario(name, bpmnElementType, bpmnEventType, builder, completionAction);
        }
    }
}

