/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.subprocess;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.RecordToWrite;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.EmbeddedSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.EventSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessEventIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessEventRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class EmbeddedSubProcessConcurrencyTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition().maxCommandsInBatch(1);
    private static final String PROCESS_ID = "process-with-sub-process";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldNotTriggerBoundaryEventWhenFlowscopeIsInterrupted() {
        Consumer<EmbeddedSubProcessBuilder> subProcessBuilder = subprocess -> subprocess.startEvent().parallelGateway().serviceTask("task", b -> b.zeebeJobType("task")).moveToLastGateway().serviceTask("task2", b -> b.zeebeJobType("task2")).endEvent().moveToActivity("subProcess").boundaryEvent("errorBoundary", boundary -> ((BoundaryEventBuilder)boundary.cancelActivity(Boolean.valueOf(true))).error("boundaryError")).endEvent().done();
        Consumer<EventSubProcessBuilder> eventSubProcessBuilder = eventSubProcess -> ((StartEventBuilder)eventSubProcess.startEvent("eventSubProcessStartEvent").error("espError")).endEvent();
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("eventSubProcess", eventSubProcessBuilder).startEvent().subProcess("subProcess", subProcess -> subProcessBuilder.accept(subProcess.embeddedSubProcess())).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        List jobs = ((JobRecordStream)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).toList();
        Record firstJob = (Record)jobs.get(0);
        Record secondJob = (Record)jobs.get(1);
        JobRecord boundaryJobRecord = new JobRecord();
        boundaryJobRecord.wrapWithoutVariables((JobRecord)firstJob.getValue());
        boundaryJobRecord.setErrorCode(BufferUtil.wrapString((String)"boundaryError"));
        JobRecord espJobRecord = new JobRecord();
        espJobRecord.wrapWithoutVariables((JobRecord)secondJob.getValue());
        espJobRecord.setErrorCode(BufferUtil.wrapString((String)"espError"));
        ENGINE.writeRecords(RecordToWrite.command().key(firstJob.getKey()).job(JobIntent.THROW_ERROR, (JobRecordValue)boundaryJobRecord), RecordToWrite.command().key(secondJob.getKey()).job(JobIntent.THROW_ERROR, (JobRecordValue)espJobRecord));
        Assertions.assertThat((Stream)RecordingExporter.records().limitToProcessInstance(processInstanceKey).filter(r -> r.getValueType() == ValueType.PROCESS_EVENT)).extracting(new Function[]{Record::getIntent, r -> ((ProcessEventRecordValue)r.getValue()).getTargetElementId()}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ProcessEventIntent.TRIGGERING, "errorBoundary"}), Assertions.tuple((Object[])new Object[]{ProcessEventIntent.TRIGGERING, "eventSubProcessStartEvent"}), Assertions.tuple((Object[])new Object[]{ProcessEventIntent.TRIGGERED, "eventSubProcessStartEvent"})});
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).onlyEvents()).limitToProcessInstanceCompleted()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED})})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED})});
    }
}

