/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.subprocess;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.EmbeddedSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.EndEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class EmbeddedSubProcessTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process-with-sub-process";
    private static final BpmnModelInstance NO_TASK_SUB_PROCESS = EmbeddedSubProcessTest.processWithSubProcess(subProcess -> subProcess.startEvent().endEvent());
    private static final BpmnModelInstance ONE_TASK_SUB_PROCESS = EmbeddedSubProcessTest.processWithSubProcess(subProcess -> subProcess.startEvent().serviceTask("task", b -> b.zeebeJobType("task")).endEvent());
    private static final BpmnModelInstance PARALLEL_TASKS_SUB_PROCESS = EmbeddedSubProcessTest.processWithSubProcess(subProcess -> ((ServiceTaskBuilder)((ServiceTaskBuilder)subProcess.startEvent().parallelGateway("fork").serviceTask("task-1", b -> b.zeebeJobType("task-1")).sequenceFlowId("join-1")).parallelGateway("join").moveToNode("fork").serviceTask("task-2", b -> b.zeebeJobType("task-2")).sequenceFlowId("join-2")).connectTo("join").endEvent());
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    private static BpmnModelInstance processWithSubProcess(Consumer<EmbeddedSubProcessBuilder> subProcessBuilder) {
        return EmbeddedSubProcessTest.processWithSubProcessBuilder(subProcessBuilder).done();
    }

    private static EndEventBuilder processWithSubProcessBuilder(Consumer<EmbeddedSubProcessBuilder> subProcessBuilder) {
        return Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("sub-process", subProcess -> subProcessBuilder.accept(subProcess.embeddedSubProcess())).endEvent();
    }

    @Test
    public void shouldActivateSubProcess() {
        ENGINE.deployment().withXmlResource(NO_TASK_SUB_PROCESS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withTenantId("<default>").limitToProcessInstanceCompleted()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.SEQUENCE_FLOW, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED})});
        Record subProcessActivating = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SUB_PROCESS).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)subProcessActivating.getValue())).hasFlowScopeKey(processInstanceKey).hasElementId("sub-process");
    }

    @Test
    public void shouldActivateSubProcessWithCustomTenant() {
        String tenantId = "foo";
        ENGINE.deployment().withXmlResource(NO_TASK_SUB_PROCESS).withTenantId("foo").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("foo").create();
        Record subProcessActivating = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SUB_PROCESS).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withTenantId("foo").getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)subProcessActivating.getValue())).hasFlowScopeKey(processInstanceKey).hasElementId("sub-process").hasTenantId("foo");
    }

    @Test
    public void shouldTerminateSubProcessWithNonInterruptingBoundaryEvent() {
        BpmnModelInstance model = EmbeddedSubProcessTest.processWithSubProcess(subProcess -> subProcess.startEvent().serviceTask("task-1", b -> b.zeebeJobType("task-1")).endEvent().subProcessDone().boundaryEvent("boundary", b -> ((BoundaryEventBuilder)((BoundaryEventBuilder)b.cancelActivity(Boolean.valueOf(false))).timerWithDuration("PT15S")).endEvent()));
        ENGINE.deployment().withXmlResource(model).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).await();
        ENGINE.increaseTime(Duration.ofMinutes(1L));
        ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withElementType(BpmnElementType.BOUNDARY_EVENT).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceTerminated()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED})});
    }

    @Test
    public void shouldTerminateSubProcessWithNonInterruptingEventSubProcess() {
        BpmnModelInstance model = EmbeddedSubProcessTest.processWithSubProcess(subProcess -> {
            ((StartEventBuilder)((StartEventBuilder)subProcess.eventSubProcess().startEvent().interrupting(false)).timerWithDuration("PT15S")).endEvent();
            subProcess.startEvent().serviceTask("task-1", b -> b.zeebeJobType("task-1")).endEvent();
        });
        ENGINE.deployment().withXmlResource(model).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).await();
        ENGINE.increaseTime(Duration.ofMinutes(1L));
        ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withElementType(BpmnElementType.EVENT_SUB_PROCESS).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceTerminated()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED})});
    }

    @Test
    public void shouldCompleteSubProcess() {
        ENGINE.deployment().withXmlResource(NO_TASK_SUB_PROCESS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SEQUENCE_FLOW, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ACTIVATE_ELEMENT})});
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).limitToProcessInstanceCompleted()).extracting(Record::getIntent).contains((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_COMPLETED});
    }

    @Test
    public void shouldCreateJobForInnerTask() {
        ENGINE.deployment().withXmlResource(ONE_TASK_SUB_PROCESS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record serviceTaskActivated = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).getFirst();
        Record jobCreated = (Record)((JobRecordStream)RecordingExporter.jobRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)JobIntent.CREATED)).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)jobCreated.getValue())).hasElementId("task").hasElementInstanceKey(serviceTaskActivated.getKey()).hasBpmnProcessId(((ProcessInstanceRecordValue)serviceTaskActivated.getValue()).getBpmnProcessId()).hasProcessDefinitionVersion(((ProcessInstanceRecordValue)serviceTaskActivated.getValue()).getVersion()).hasProcessDefinitionKey(((ProcessInstanceRecordValue)serviceTaskActivated.getValue()).getProcessDefinitionKey());
    }

    @Test
    public void shouldTerminateSubProcess() {
        ENGINE.deployment().withXmlResource(ONE_TASK_SUB_PROCESS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceTerminated()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED})});
    }

    @Test
    public void shouldInterruptSubProcess() {
        BpmnModelInstance process = EmbeddedSubProcessTest.processWithSubProcess(subProcess -> subProcess.startEvent().serviceTask("task", t -> t.zeebeJobType("task")).endEvent().subProcessDone().boundaryEvent("cancel", b -> b.message(m -> m.name("cancel").zeebeCorrelationKeyExpression("key"))).endEvent());
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", "key-1").create();
        ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).await();
        ENGINE.message().withName("cancel").withCorrelationKey("key-1").publish();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED})});
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).limitToProcessInstanceCompleted()).extracting(Record::getIntent).contains((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_COMPLETED});
    }

    @Test
    public void shouldCompleteNestedSubProcess() {
        Consumer<SubProcessBuilder> nestedSubProcess = subProcess -> subProcess.embeddedSubProcess().startEvent().endEvent();
        BpmnModelInstance process = EmbeddedSubProcessTest.processWithSubProcess(subProcess -> subProcess.startEvent().subProcess("nestedSubProcess", nestedSubProcess).endEvent());
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCompleteSubProcessWithParallelFlow() {
        BpmnModelInstance process = EmbeddedSubProcessTest.processWithSubProcess(subProcess -> subProcess.startEvent().parallelGateway("fork").serviceTask("task-1", b -> b.zeebeJobType("task-1")).endEvent().moveToLastGateway().serviceTask("task-2", b -> b.zeebeJobType("task-2")).endEvent());
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType("task-1").complete();
        ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.END_EVENT).withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).await();
        ENGINE.job().ofInstance(processInstanceKey).withType("task-2").complete();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.PARALLEL_GATEWAY, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldTerminateSubProcessWithParallelFlow() {
        ENGINE.deployment().withXmlResource(PARALLEL_TASKS_SUB_PROCESS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ((JobRecordStream)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).onlyEvents()).limitToProcessInstanceTerminated()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED})});
    }

    @Test
    public void shouldTerminateSubProcessWithPendingParallelGateway() {
        ENGINE.deployment().withXmlResource(PARALLEL_TASKS_SUB_PROCESS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType("task-1").complete();
        ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementId("join-1").withIntent((Intent)ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN)).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).onlyEvents()).limitToProcessInstanceTerminated()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED})});
    }

    @Test
    public void shouldNotOverrideVariablesOnCompleteSubProcess() {
        ENGINE.deployment().withXmlResource(EmbeddedSubProcessTest.processWithSubProcessBuilder(subprocess -> subprocess.startEvent().serviceTask("task", b -> b.zeebeJobType("task")).endEvent()).moveToActivity("sub-process").boundaryEvent("msg-boundary", boundary -> ((BoundaryEventBuilder)boundary.cancelActivity(Boolean.valueOf(false))).message(msg -> msg.name("foo").zeebeCorrelationKeyExpression("bar"))).endEvent("msg-end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("bar", "bar").create();
        Record job = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.message().withName("foo").withCorrelationKey("bar").withVariables("{\"x\":1}").publish();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementId("msg-end").await();
        ENGINE.variables().ofScope(processInstanceKey).withDocument("{\"x\":2}").update();
        RecordingExporter.variableRecords((VariableIntent)VariableIntent.UPDATED).withProcessInstanceKey(processInstanceKey).withName("x").withValue("2").await();
        ENGINE.job().withKey(job.getKey()).complete();
        Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey).variableRecords().withName("x").withScopeKey(processInstanceKey)).extracting(var -> Assertions.tuple((Object[])new Object[]{var.getIntent(), ((VariableRecordValue)var.getValue()).getValue()})).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{VariableIntent.CREATED, "1"}), Assertions.tuple((Object[])new Object[]{VariableIntent.UPDATED, "2"})});
    }
}

