/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.FormIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import io.camunda.zeebe.protocol.record.value.deployment.Form;
import io.camunda.zeebe.protocol.record.value.deployment.FormMetadataValue;
import io.camunda.zeebe.test.util.record.FormRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.Rule;
import org.junit.Test;

public class FormDeploymentTest {
    private static final String TEST_FORM_1 = "/form/test-form-1.form";
    private static final String TEST_FORM_1_V2 = "/form/test-form-1_v2.form";
    private static final String TEST_FORM_2 = "/form/test-form-2.form";
    private static final String TEST_FORM_WITHOUT_ID = "/form/test-form_without_id.form";
    private static final String TEST_FORM_WITH_BLANK_ID = "/form/test-form_with_blank_id.form";
    private static final String TEST_FORM_1_ID = "Form_0w7r08e";
    private static final String TEST_FORM_2_ID = "Form_6s1b76p";
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();

    @Test
    public void shouldDeployFormResource() {
        Record<DeploymentRecordValue> deploymentEvent = this.engine.deployment().withJsonClasspathResource(TEST_FORM_1).deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentEvent).hasIntent((Intent)DeploymentIntent.CREATED).hasValueType(ValueType.DEPLOYMENT).hasRecordType(RecordType.EVENT);
    }

    @Test
    public void shouldRejectWhenFormIdIsMissing() {
        Record<DeploymentRecordValue> deploymentEvent = this.engine.deployment().withJsonClasspathResource(TEST_FORM_WITHOUT_ID).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentEvent).hasIntent((Intent)DeploymentIntent.CREATE).hasRecordType(RecordType.COMMAND_REJECTION).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)deploymentEvent.getRejectionReason()).contains(new CharSequence[]{String.format("Expected the form id to be present, but none given", new Object[0])});
    }

    @Test
    public void shouldRejectWhenFormIdIsBlank() {
        Record<DeploymentRecordValue> deploymentEvent = this.engine.deployment().withJsonClasspathResource(TEST_FORM_WITH_BLANK_ID).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentEvent).hasIntent((Intent)DeploymentIntent.CREATE).hasRecordType(RecordType.COMMAND_REJECTION).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)deploymentEvent.getRejectionReason()).contains(new CharSequence[]{String.format("Expected the form id to be filled, but it is blank", new Object[0])});
    }

    @Test
    public void shouldWriteFormRecord() {
        this.engine.deployment().withJsonClasspathResource(TEST_FORM_1).deploy();
        Record record = (Record)RecordingExporter.formRecords().getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)record).hasIntent((Intent)FormIntent.CREATED).hasValueType(ValueType.FORM).hasRecordType(RecordType.EVENT);
        Assertions.assertThat((long)record.getKey()).isPositive();
        Form formRecord = (Form)record.getValue();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Form)formRecord).hasFormId(TEST_FORM_1_ID).hasResourceName(TEST_FORM_1).hasVersion(1);
        Assertions.assertThat((long)formRecord.getFormKey()).isPositive();
        Assertions.assertThat((boolean)formRecord.isDuplicate()).isFalse();
    }

    @Test
    public void shouldDeployDuplicateInSeparateCommand() {
        Record<DeploymentRecordValue> firstDeployment = this.engine.deployment().withJsonClasspathResource(TEST_FORM_1).deploy();
        FormMetadataValue formV1 = (FormMetadataValue)((DeploymentRecordValue)firstDeployment.getValue()).getFormMetadata().get(0);
        Record<DeploymentRecordValue> secondDeployment = this.engine.deployment().withJsonClasspathResource(TEST_FORM_1).deploy();
        Assertions.assertThat((List)((DeploymentRecordValue)secondDeployment.getValue()).getFormMetadata()).hasSize(1);
        FormMetadataValue formMetadata = (FormMetadataValue)((DeploymentRecordValue)secondDeployment.getValue()).getFormMetadata().get(0);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((FormMetadataValue)formMetadata).hasVersion(1).hasFormKey(formV1.getFormKey()).isDuplicate();
    }

    @Test
    public void shouldOmitRecordsForDuplicate() {
        this.engine.deployment().withJsonClasspathResource(TEST_FORM_1).deploy();
        this.engine.deployment().withJsonClasspathResource(TEST_FORM_1).deploy();
        this.engine.deployment().withJsonClasspathResource(TEST_FORM_1_V2).deploy();
        Assertions.assertThat((Stream)RecordingExporter.formRecords().limit(2L)).extracting(Record::getValue).extracting(FormMetadataValue::getVersion).describedAs("Expect to omit form record for duplicate", new Object[0]).containsExactly((Object[])new Integer[]{1, 2});
    }

    @Test
    public void shouldIncreaseVersionIfResourceNameDiffers() {
        byte[] formResource = this.readResource(TEST_FORM_1);
        this.engine.deployment().withJsonResource(formResource, "test-form-1.form").deploy();
        Record<DeploymentRecordValue> deploymentEvent = this.engine.deployment().withJsonResource(formResource, "renamed-test-form-1.form").deploy();
        Assertions.assertThat((List)((DeploymentRecordValue)deploymentEvent.getValue()).getFormMetadata()).extracting(FormMetadataValue::getVersion).describedAs("Expect that the Form version is increased", new Object[0]).containsExactly((Object[])new Integer[]{2});
    }

    @Test
    public void shouldIncreaseVersionIfFormJSONDiffers() {
        this.engine.deployment().withJsonClasspathResource(TEST_FORM_1).deploy();
        Record<DeploymentRecordValue> deploymentEvent = this.engine.deployment().withJsonClasspathResource(TEST_FORM_1_V2).deploy();
        Assertions.assertThat((List)((DeploymentRecordValue)deploymentEvent.getValue()).getFormMetadata()).extracting(FormMetadataValue::getVersion).describedAs("Expect that the Form version is increased", new Object[0]).containsExactly((Object[])new Integer[]{2});
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.formRecords().limit(2L)).hasSize(2)).extracting(Record::getValue).extracting(new Function[]{FormMetadataValue::getFormId, FormMetadataValue::getVersion}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{TEST_FORM_1_ID, 1}), Assertions.tuple((Object[])new Object[]{TEST_FORM_1_ID, 2})});
    }

    @Test
    public void shouldSetInitialVersionForDifferentFormIds() {
        Record<DeploymentRecordValue> deploymentEvent1 = this.engine.deployment().withXmlClasspathResource(TEST_FORM_1).deploy();
        Record<DeploymentRecordValue> deploymentEvent2 = this.engine.deployment().withXmlClasspathResource(TEST_FORM_2).deploy();
        Assertions.assertThat((List)((DeploymentRecordValue)deploymentEvent1.getValue()).getFormMetadata()).extracting(FormMetadataValue::getVersion).describedAs("Expect that the Form version is 1", new Object[0]).containsExactly((Object[])new Integer[]{1});
        Assertions.assertThat((List)((DeploymentRecordValue)deploymentEvent2.getValue()).getFormMetadata()).extracting(FormMetadataValue::getVersion).describedAs("Expect that the Form version is 1", new Object[0]).containsExactly((Object[])new Integer[]{1});
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.formRecords().limit(2L)).hasSize(2)).extracting(Record::getValue).extracting(new Function[]{FormMetadataValue::getFormId, FormMetadataValue::getVersion}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{TEST_FORM_1_ID, 1}), Assertions.tuple((Object[])new Object[]{TEST_FORM_2_ID, 1})});
    }

    @Test
    public void shouldDeployIfMultipleFormsHaveDifferentId() {
        Record<DeploymentRecordValue> deploymentEvent = this.engine.deployment().withXmlClasspathResource(TEST_FORM_1).withXmlClasspathResource(TEST_FORM_2).deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentEvent).hasIntent((Intent)DeploymentIntent.CREATED).hasValueType(ValueType.DEPLOYMENT).hasRecordType(RecordType.EVENT);
        Assertions.assertThat((List)((DeploymentRecordValue)deploymentEvent.getValue()).getFormMetadata()).hasSize(2);
        FormMetadataValue formMetadata1 = (FormMetadataValue)((DeploymentRecordValue)deploymentEvent.getValue()).getFormMetadata().get(0);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((FormMetadataValue)formMetadata1).hasFormId(TEST_FORM_1_ID);
        Assertions.assertThat((long)formMetadata1.getFormKey()).isPositive();
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])formMetadata1.getChecksum()).describedAs("Expect the MD5 checksum of the Form resource", new Object[0])).isEqualTo((Object)this.getChecksum(TEST_FORM_1));
        FormMetadataValue formMetadata2 = (FormMetadataValue)((DeploymentRecordValue)deploymentEvent.getValue()).getFormMetadata().get(1);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((FormMetadataValue)formMetadata2).hasFormId(TEST_FORM_2_ID);
        Assertions.assertThat((long)formMetadata2.getFormKey()).isPositive();
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])formMetadata2.getChecksum()).describedAs("Expect the MD5 checksum of the DMN resource", new Object[0])).isEqualTo((Object)this.getChecksum(TEST_FORM_2));
    }

    @Test
    public void shouldRejectIfMultipleFormHaveTheSameId() {
        Record<DeploymentRecordValue> deploymentEvent = this.engine.deployment().withXmlClasspathResource(TEST_FORM_1).withXmlClasspathResource(TEST_FORM_1_V2).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentEvent).hasIntent((Intent)DeploymentIntent.CREATE).hasRecordType(RecordType.COMMAND_REJECTION).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)deploymentEvent.getRejectionReason()).contains(new CharSequence[]{String.format("Expected the form ids to be unique within a deployment but found a duplicated id '%s' in the resources '%s' and '%s'.", TEST_FORM_1_ID, TEST_FORM_1, TEST_FORM_1_V2)});
    }

    @Test
    public void shouldCreateFormForTenant() {
        String tenant = "tenant";
        Record<DeploymentRecordValue> deployment = this.engine.deployment().withXmlClasspathResource(TEST_FORM_1).withTenantId("tenant").deploy();
        Assertions.assertThat((String)((DeploymentRecordValue)deployment.getValue()).getTenantId()).isEqualTo("tenant");
        Assertions.assertThat((Stream)((FormRecordStream)RecordingExporter.formRecords().withIntent((Intent)FormIntent.CREATED)).withFormId(TEST_FORM_1_ID).limit(1L)).extracting(Record::getValue).extracting(new Function[]{FormMetadataValue::getFormId, FormMetadataValue::getVersion, TenantOwned::getTenantId}).describedAs("Form is created for correct tenant", new Object[0]).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{TEST_FORM_1_ID, 1, "tenant"})});
    }

    @Test
    public void shouldCreateFormsForTenant() {
        String tenant = "tenant";
        Record<DeploymentRecordValue> deployment = this.engine.deployment().withXmlClasspathResource(TEST_FORM_1).withXmlClasspathResource(TEST_FORM_2).withTenantId("tenant").deploy();
        Assertions.assertThat((String)((DeploymentRecordValue)deployment.getValue()).getTenantId()).isEqualTo("tenant");
        Assertions.assertThat((Stream)((FormRecordStream)RecordingExporter.formRecords().withIntent((Intent)FormIntent.CREATED)).limit(2L)).extracting(Record::getValue).extracting(new Function[]{FormMetadataValue::getFormId, FormMetadataValue::getVersion, TenantOwned::getTenantId}).describedAs("Forms are created for correct tenant", new Object[0]).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{TEST_FORM_1_ID, 1, "tenant"}), Assertions.tuple((Object[])new Object[]{TEST_FORM_2_ID, 1, "tenant"})});
    }

    @Test
    public void shouldCreateFormsForTenants() {
        String tenant1 = "tenant1";
        String tenant2 = "tenant2";
        Record<DeploymentRecordValue> deployment1 = this.engine.deployment().withXmlClasspathResource(TEST_FORM_1).withTenantId("tenant1").deploy();
        Record<DeploymentRecordValue> deployment2 = this.engine.deployment().withXmlClasspathResource(TEST_FORM_1).withTenantId("tenant2").deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment1.getKey()).describedAs("Does two different deployments", new Object[0])).isNotEqualTo(deployment2.getKey());
        ((AbstractLongAssert)Assertions.assertThat((long)((FormMetadataValue)((DeploymentRecordValue)deployment1.getValue()).getFormMetadata().get(0)).getFormKey()).describedAs("Created 2 different forms", new Object[0])).isNotEqualTo(((DeploymentRecordValue)deployment2.getValue()).getFormMetadata().get(0));
        Assertions.assertThat((String)((DeploymentRecordValue)deployment1.getValue()).getTenantId()).isEqualTo("tenant1");
        Assertions.assertThat((String)((DeploymentRecordValue)deployment2.getValue()).getTenantId()).isEqualTo("tenant2");
        Assertions.assertThat((Stream)((FormRecordStream)RecordingExporter.formRecords().withIntent((Intent)FormIntent.CREATED)).withFormId(TEST_FORM_1_ID).limit(2L)).extracting(Record::getValue).extracting(new Function[]{FormMetadataValue::getFormId, FormMetadataValue::getVersion, TenantOwned::getTenantId}).describedAs("Forms are created for correct tenants", new Object[0]).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{TEST_FORM_1_ID, 1, "tenant1"}), Assertions.tuple((Object[])new Object[]{TEST_FORM_1_ID, 1, "tenant2"})});
    }

    private byte[] readResource(String resourceName) {
        InputStream resourceAsStream = this.getClass().getResourceAsStream(resourceName);
        Assertions.assertThat((InputStream)resourceAsStream).isNotNull();
        try {
            return resourceAsStream.readAllBytes();
        }
        catch (IOException e) {
            Assertions.fail((String)"Failed to read resource '{}'", (Object[])new Object[]{resourceName, e});
            return new byte[0];
        }
    }

    private byte[] getChecksum(String resourceName) {
        byte[] checksum = new byte[]{};
        try {
            byte[] resource = this.readResource(resourceName);
            MessageDigest digestGenerator = MessageDigest.getInstance("MD5");
            checksum = digestGenerator.digest(resource);
        }
        catch (NoSuchAlgorithmException e) {
            Assertions.fail((String)"Failed to calculate the checksum", (Throwable)e);
        }
        return checksum;
    }
}

