/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.impl.StaticExpression;
import io.camunda.zeebe.engine.processing.deployment.model.validation.ZeebeExpressionValidator;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ZeebeExpressionValidatorTest {
    ZeebeExpressionValidatorTest() {
    }

    @Nested
    @DisplayName(value="ZeebeExpressionValidator.isListOfCsv(Expression)")
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class IsListOfValues {
        IsListOfValues(ZeebeExpressionValidatorTest this$0) {
        }

        @ParameterizedTest
        @MethodSource(value={"csv"})
        void shouldAcceptCsv(String value) {
            StaticExpression expression = new StaticExpression(value);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)ZeebeExpressionValidator.isListOfCsv((Expression)expression)).describedAs("\"%s\" is CSV", new Object[]{value})).isTrue();
        }

        @ParameterizedTest
        @MethodSource(value={"notCsv"})
        void shouldRejectNotCsv(String value) {
            StaticExpression expression = new StaticExpression(value);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)ZeebeExpressionValidator.isListOfCsv((Expression)expression)).describedAs("\"%s\" is not CSV", new Object[]{value})).isFalse();
        }

        Stream<Arguments> csv() {
            return Stream.of(Arguments.of((Object[])new Object[]{""}), Arguments.of((Object[])new Object[]{"a"}), Arguments.of((Object[])new Object[]{"a,b"}), Arguments.of((Object[])new Object[]{"a,b,c"}), Arguments.of((Object[])new Object[]{"\"abcd\",\"efgh\",\"ijkl\""}), Arguments.of((Object[])new Object[]{"1"}), Arguments.of((Object[])new Object[]{"1,2"}), Arguments.of((Object[])new Object[]{"1,a,3"}), Arguments.of((Object[])new Object[]{" a"}), Arguments.of((Object[])new Object[]{"a "}), Arguments.of((Object[])new Object[]{" a "}), Arguments.of((Object[])new Object[]{" a,b "}), Arguments.of((Object[])new Object[]{" a ,b "}), Arguments.of((Object[])new Object[]{" a, b "}), Arguments.of((Object[])new Object[]{" a , b "}), Arguments.of((Object[])new Object[]{"_variable"}));
        }

        Stream<Arguments> notCsv() {
            return Stream.of(Arguments.of((Object[])new Object[]{","}), Arguments.of((Object[])new Object[]{"a,"}), Arguments.of((Object[])new Object[]{",b"}), Arguments.of((Object[])new Object[]{",b,"}), Arguments.of((Object[])new Object[]{"a,,c"}), Arguments.of((Object[])new Object[]{"a, ,c"}), Arguments.of((Object[])new Object[]{" ,"}), Arguments.of((Object[])new Object[]{", "}), Arguments.of((Object[])new Object[]{" , "}));
        }
    }
}

