/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.ExpressionLanguageFactory;
import io.camunda.zeebe.engine.processing.bpmn.clock.ZeebeFeelEngineClock;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.ExpressionTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.validation.ExpectedValidationResult;
import io.camunda.zeebe.engine.processing.deployment.model.validation.ZeebeRuntimeValidators;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import io.camunda.zeebe.model.bpmn.builder.ReceiveTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.UserTaskBuilder;
import io.camunda.zeebe.model.bpmn.instance.ConditionExpression;
import io.camunda.zeebe.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeAssignmentDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeCalledElement;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeInput;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeLoopCharacteristics;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeOutput;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeSubscription;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskHeaders;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskSchedule;
import io.camunda.zeebe.model.bpmn.traversal.ModelElementVisitor;
import io.camunda.zeebe.model.bpmn.traversal.ModelWalker;
import io.camunda.zeebe.model.bpmn.validation.ValidationVisitor;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.camunda.bpm.model.xml.validation.ValidationResult;
import org.camunda.bpm.model.xml.validation.ValidationResults;
import org.camunda.feel.FeelEngineClock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class ZeebeRuntimeValidationTest {
    private static final String INVALID_EXPRESSION = "a & b";
    private static final String INVALID_EXPRESSION_MESSAGE = "failed to parse expression 'a & b'";
    private static final String STATIC_EXPRESSION = "x";
    private static final String STATIC_EXPRESSION_MESSAGE = "Expected expression but found static value 'x'. An expression must start with '=' (e.g. '=x').";
    private static final String MISSING_EXPRESSION_MESSAGE = "Expected expression but not found.";
    private static final String MISSING_PATH_EXPRESSION_MESSAGE = "Expected path expression but not found.";
    private static final String INVALID_PATH_EXPRESSION = "a ? b";
    private static final String INVALID_PATH_EXPRESSION_MESSAGE = "Expected path expression 'a ? b' but doesn't match the pattern '[a-zA-Z_][a-zA-Z0-9_]*(\\.[a-zA-Z_][a-zA-Z0-9_]*)*'.";
    private static final String RESERVED_TASK_HEADER_KEY = "io.camunda.zeebe:reserved-header-key";
    private static final String RESERVED_TASK_HEADER_MESSAGE = "Attribute 'key' contains '%s', but header keys starting with '%s' are reserved for internal use.";
    public BpmnModelInstance modelInstance;
    @Parameterized.Parameter(value=0)
    public Object modelSource;
    @Parameterized.Parameter(value=1)
    public List<ExpectedValidationResult> expectedResults;

    @Parameterized.Parameters(name="{index}: {1}")
    public static Object[][] parameters() {
        return new Object[][]{{((ExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().exclusiveGateway().sequenceFlowId("flow")).conditionExpression(INVALID_EXPRESSION)).endEvent().done(), List.of(ExpectedValidationResult.expect(ConditionExpression.class, INVALID_EXPRESSION_MESSAGE))}, {((ExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().exclusiveGateway().sequenceFlowId("flow")).condition(STATIC_EXPRESSION)).endEvent().done(), List.of(ExpectedValidationResult.expect(ConditionExpression.class, STATIC_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", s -> s.zeebeInputExpression(INVALID_EXPRESSION, "foo")).endEvent().done(), List.of(ExpectedValidationResult.expect(ZeebeInput.class, INVALID_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", s -> s.zeebeInput("", "bar")).endEvent().done(), List.of(ExpectedValidationResult.expect(ZeebeInput.class, MISSING_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", s -> s.zeebeInputExpression("foo", "")).endEvent().done(), List.of(ExpectedValidationResult.expect(ZeebeInput.class, MISSING_PATH_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", s -> s.zeebeInputExpression("foo", INVALID_PATH_EXPRESSION)).endEvent().done(), List.of(ExpectedValidationResult.expect(ZeebeInput.class, INVALID_PATH_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", s -> s.zeebeOutputExpression(INVALID_EXPRESSION, "foo")).endEvent().done(), List.of(ExpectedValidationResult.expect(ZeebeOutput.class, INVALID_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", s -> s.zeebeOutput(STATIC_EXPRESSION, "bar")).endEvent().done(), List.of(ExpectedValidationResult.expect(ZeebeOutput.class, STATIC_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", s -> s.zeebeOutput("", "bar")).endEvent().done(), List.of(ExpectedValidationResult.expect(ZeebeOutput.class, MISSING_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", s -> s.zeebeOutputExpression("foo", INVALID_PATH_EXPRESSION)).endEvent().done(), List.of(ExpectedValidationResult.expect(ZeebeOutput.class, INVALID_PATH_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", s -> s.zeebeOutputExpression("foo", "")).endEvent().done(), List.of(ExpectedValidationResult.expect(ZeebeOutput.class, MISSING_PATH_EXPRESSION_MESSAGE))}, {((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().intermediateCatchEvent("catch").message(b -> b.name("message").zeebeCorrelationKeyExpression(INVALID_EXPRESSION))).endEvent().done(), List.of(ExpectedValidationResult.expect(ZeebeSubscription.class, INVALID_EXPRESSION_MESSAGE))}, {((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().intermediateCatchEvent("catch").message(b -> b.name("message").zeebeCorrelationKey(STATIC_EXPRESSION))).endEvent().done(), List.of(ExpectedValidationResult.expect(ZeebeSubscription.class, STATIC_EXPRESSION_MESSAGE))}, {((ReceiveTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().receiveTask("catch").message(b -> b.name("message").zeebeCorrelationKeyExpression(INVALID_EXPRESSION))).endEvent().done(), List.of(ExpectedValidationResult.expect(ZeebeSubscription.class, INVALID_EXPRESSION_MESSAGE))}, {((ReceiveTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().receiveTask("catch").message(b -> b.name("message").zeebeCorrelationKey(STATIC_EXPRESSION))).endEvent().done(), List.of(ExpectedValidationResult.expect(ZeebeSubscription.class, STATIC_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.multiInstance(m -> m.zeebeInputCollectionExpression(INVALID_EXPRESSION))).done(), List.of(ExpectedValidationResult.expect(ZeebeLoopCharacteristics.class, INVALID_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.multiInstance(m -> m.zeebeInputCollection(STATIC_EXPRESSION))).done(), List.of(ExpectedValidationResult.expect(ZeebeLoopCharacteristics.class, STATIC_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.multiInstance(m -> ((MultiInstanceLoopCharacteristicsBuilder)m.zeebeInputCollectionExpression(STATIC_EXPRESSION)).zeebeOutputElementExpression(INVALID_EXPRESSION))).done(), List.of(ExpectedValidationResult.expect(ZeebeLoopCharacteristics.class, INVALID_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.multiInstance(m -> ((MultiInstanceLoopCharacteristicsBuilder)m.zeebeInputCollectionExpression(STATIC_EXPRESSION)).zeebeOutputElement(STATIC_EXPRESSION))).done(), List.of(ExpectedValidationResult.expect(ZeebeLoopCharacteristics.class, STATIC_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.multiInstance(m -> ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)m.zeebeInputCollectionExpression("foo")).zeebeOutputCollection("bar")).zeebeOutputElementExpression(INVALID_EXPRESSION))).done(), List.of(ExpectedValidationResult.expect(ZeebeLoopCharacteristics.class, INVALID_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().callActivity("call", c -> c.zeebeProcessIdExpression(INVALID_EXPRESSION)).done(), List.of(ExpectedValidationResult.expect(ZeebeCalledElement.class, INVALID_EXPRESSION_MESSAGE))}, {((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().message(messageBuilder -> messageBuilder.nameExpression("variableReference"))).done(), List.of(ExpectedValidationResult.expect(StartEvent.class, "Expected constant expression of type String for message name '=variableReference', but was NULL"))}, {((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().message(messageBuilder -> messageBuilder.nameExpression("false"))).done(), List.of(ExpectedValidationResult.expect(StartEvent.class, "Expected constant expression of type String for message name '=false', but was BOOLEAN"))}, {Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", task -> ((ServiceTaskBuilder)task.zeebeJobType("test")).zeebeInputExpression(STATIC_EXPRESSION, "null")).done(), List.of(ExpectedValidationResult.expect(ZeebeInput.class, "Expected path expression 'null' but is one of the reserved words (null, true, false, function, if, then, else, for, between, instance, of)."))}, {Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", task -> ((ServiceTaskBuilder)task.zeebeJobType("test")).zeebeOutputExpression(STATIC_EXPRESSION, "true")).done(), List.of(ExpectedValidationResult.expect(ZeebeOutput.class, "Expected path expression 'true' but is one of the reserved words (null, true, false, function, if, then, else, for, between, instance, of)."))}, {Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task", b -> b.zeebeAssigneeExpression(INVALID_EXPRESSION)).done(), List.of(ExpectedValidationResult.expect(ZeebeAssignmentDefinition.class, INVALID_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task", b -> b.zeebeCandidateGroupsExpression(INVALID_EXPRESSION)).done(), List.of(ExpectedValidationResult.expect(ZeebeAssignmentDefinition.class, INVALID_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task", b -> b.zeebeCandidateUsersExpression(INVALID_EXPRESSION)).done(), List.of(ExpectedValidationResult.expect(ZeebeAssignmentDefinition.class, INVALID_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task", b -> b.zeebeCandidateGroups("1,,")).done(), List.of(ExpectedValidationResult.expect(ZeebeAssignmentDefinition.class, "Expected static value to be a list of comma-separated values, e.g. 'a,b,c', but found '1,,'"))}, {Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task", b -> b.zeebeCandidateUsers("1,,")).done(), List.of(ExpectedValidationResult.expect(ZeebeAssignmentDefinition.class, "Expected static value to be a list of comma-separated values, e.g. 'a,b,c', but found '1,,'"))}, {Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task", b -> b.zeebeDueDateExpression(INVALID_EXPRESSION)).done(), List.of(ExpectedValidationResult.expect(ZeebeTaskSchedule.class, INVALID_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task", b -> b.zeebeDueDate("12345")).done(), List.of(ExpectedValidationResult.expect(ZeebeTaskSchedule.class, "Expected static value to be a valid DateTime String, e.g. '2023-03-02T15:35+02:00', but found '12345'."))}, {Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task", b -> b.zeebeFollowUpDateExpression(INVALID_EXPRESSION)).done(), List.of(ExpectedValidationResult.expect(ZeebeTaskSchedule.class, INVALID_EXPRESSION_MESSAGE))}, {Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task", b -> b.zeebeFollowUpDate("12345")).done(), List.of(ExpectedValidationResult.expect(ZeebeTaskSchedule.class, "Expected static value to be a valid DateTime String, e.g. '2023-03-02T15:35+02:00', but found '12345'."))}, {((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("task").zeebeTaskHeader(RESERVED_TASK_HEADER_KEY, STATIC_EXPRESSION)).done(), List.of(ExpectedValidationResult.expect(ZeebeTaskHeaders.class, String.format(RESERVED_TASK_HEADER_MESSAGE, RESERVED_TASK_HEADER_KEY, "io.camunda.zeebe:")))}, {Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.multiInstance(m -> m.completionCondition(ExpressionTransformer.asFeelExpressionString((String)INVALID_EXPRESSION)))).done(), List.of(ExpectedValidationResult.expect(MultiInstanceLoopCharacteristics.class, INVALID_EXPRESSION_MESSAGE))}};
    }

    private static ValidationResults validate(BpmnModelInstance model) {
        ModelWalker walker = new ModelWalker(model);
        ExpressionLanguage expressionLanguage = ExpressionLanguageFactory.createExpressionLanguage((FeelEngineClock)new ZeebeFeelEngineClock(ActorClock.current()));
        ExpressionProcessor.EvaluationContextLookup emptyLookup = scopeKey -> name -> null;
        ExpressionProcessor expressionProcessor = new ExpressionProcessor(expressionLanguage, emptyLookup);
        ValidationVisitor visitor = new ValidationVisitor(ZeebeRuntimeValidators.getValidators((ExpressionLanguage)expressionLanguage, (ExpressionProcessor)expressionProcessor));
        walker.walk((ModelElementVisitor)visitor);
        return visitor.getValidationResult();
    }

    @Before
    public void prepareModel() {
        if (this.modelSource instanceof BpmnModelInstance) {
            this.modelInstance = (BpmnModelInstance)this.modelSource;
        } else if (this.modelSource instanceof String) {
            InputStream modelStream = ZeebeRuntimeValidationTest.class.getResourceAsStream((String)this.modelSource);
            this.modelInstance = Bpmn.readModelFromStream((InputStream)modelStream);
        } else {
            throw new RuntimeException("Cannot convert parameter to bpmn model");
        }
    }

    @Test
    public void validateModel() {
        ValidationResults results = ZeebeRuntimeValidationTest.validate(this.modelInstance);
        Bpmn.validateModel((BpmnModelInstance)this.modelInstance);
        ArrayList<ExpectedValidationResult> unmatchedExpectations = new ArrayList<ExpectedValidationResult>(this.expectedResults);
        List<ValidationResult> unmatchedResults = results.getResults().values().stream().flatMap(l -> l.stream()).collect(Collectors.toList());
        this.match(unmatchedResults, unmatchedExpectations);
        if (!unmatchedResults.isEmpty() || !unmatchedExpectations.isEmpty()) {
            this.failWith(unmatchedExpectations, unmatchedResults);
        }
    }

    private void match(List<ValidationResult> unmatchedResults, List<ExpectedValidationResult> unmatchedExpectations) {
        Iterator<ExpectedValidationResult> expectationIt = unmatchedExpectations.iterator();
        block0: while (expectationIt.hasNext()) {
            ExpectedValidationResult currentExpectation = expectationIt.next();
            Iterator<ValidationResult> resultsIt = unmatchedResults.iterator();
            while (resultsIt.hasNext()) {
                ValidationResult currentResult = resultsIt.next();
                if (!currentExpectation.matches(currentResult)) continue;
                expectationIt.remove();
                resultsIt.remove();
                continue block0;
            }
        }
    }

    private void failWith(List<ExpectedValidationResult> unmatchedExpectations, List<ValidationResult> unmatchedResults) {
        StringBuilder sb = new StringBuilder();
        sb.append("Not all expecations were matched by results (or vice versa)\n\n");
        ZeebeRuntimeValidationTest.describeUnmatchedExpectations(sb, unmatchedExpectations);
        sb.append("\n");
        ZeebeRuntimeValidationTest.describeUnmatchedResults(sb, unmatchedResults);
        Assert.fail((String)sb.toString());
    }

    private static void describeUnmatchedResults(StringBuilder sb, List<ValidationResult> results) {
        sb.append("Unmatched results:\n");
        results.forEach(e -> {
            sb.append(ExpectedValidationResult.toString(e));
            sb.append("\n");
        });
    }

    private static void describeUnmatchedExpectations(StringBuilder sb, List<ExpectedValidationResult> expectations) {
        sb.append("Unmatched expectations:\n");
        expectations.forEach(e -> {
            sb.append(e);
            sb.append("\n");
        });
    }
}

