/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.CompensationSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class CompensationIncidentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "compensation-process";
    private static final String COMPENSATION_HANDLER_ID = "Undo-A";
    private static final String COMPENSATION_HANDLER_JOB_TYPE = "Undo-A";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    private BpmnModelInstance processWithCompensation(Consumer<ServiceTaskBuilder> elementModifier) {
        return Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().manualTask("A").boundaryEvent().compensation(compensation -> {
            ServiceTaskBuilder serviceTask = (ServiceTaskBuilder)compensation.serviceTask("Undo-A").zeebeJobType("Undo-A");
            elementModifier.accept(serviceTask);
        }).moveToActivity("A").endEvent().compensateEventDefinition().done();
    }

    @Test
    public void shouldCreateIncidentForCompensationHandler() {
        ENGINE.deployment().withXmlResource(this.processWithCompensation(compensationHandler -> {})).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType("Undo-A").fail();
        Record compensationHandlerActivated = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("Undo-A").getFirst();
        Record jobCreated = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentCreated.getValue())).hasErrorType(ErrorType.JOB_NO_RETRIES).hasErrorMessage("No more retries left.").hasElementId("Undo-A").hasElementInstanceKey(compensationHandlerActivated.getKey()).hasVariableScopeKey(compensationHandlerActivated.getKey()).hasJobKey(jobCreated.getKey()).hasProcessInstanceKey(processInstanceKey).hasProcessDefinitionKey(((ProcessInstanceRecordValue)compensationHandlerActivated.getValue()).getProcessDefinitionKey()).hasBpmnProcessId(PROCESS_ID).hasTenantId(((ProcessInstanceRecordValue)compensationHandlerActivated.getValue()).getTenantId());
    }

    @Test
    public void shouldCreateIncidentIfCompensationHandlerFails() {
        ENGINE.deployment().withXmlResource(this.processWithCompensation(compensationHandler -> {})).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType("Undo-A").fail();
        ENGINE.incident().ofInstance(processInstanceKey).resolve();
        ENGINE.job().ofInstance(processInstanceKey).withType("Undo-A").complete();
        Assertions.assertThat((Stream)RecordingExporter.records().limitToProcessInstance(processInstanceKey)).extracting(new Function[]{Record::getValueType, Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ValueType.COMPENSATION_SUBSCRIPTION, CompensationSubscriptionIntent.TRIGGERED}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{ValueType.JOB, JobIntent.FAILED}), Assertions.tuple((Object[])new Object[]{ValueType.INCIDENT, IncidentIntent.CREATED}), Assertions.tuple((Object[])new Object[]{ValueType.INCIDENT, IncidentIntent.RESOLVED}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{ValueType.COMPENSATION_SUBSCRIPTION, CompensationSubscriptionIntent.COMPLETED})});
    }

    @Test
    public void shouldCreateIncidentIfInputMappingsFail() {
        ENGINE.deployment().withXmlResource(this.processWithCompensation(compensationHandler -> compensationHandler.zeebeInputExpression("assert(x, x != null)", "not_null"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.variables().ofScope(processInstanceKey).withDocument(Map.of("x", "1")).update();
        ENGINE.incident().ofInstance(processInstanceKey).resolve();
        ENGINE.job().ofInstance(processInstanceKey).withType("Undo-A").complete();
        Assertions.assertThat((Stream)RecordingExporter.records().limitToProcessInstance(processInstanceKey)).extracting(new Function[]{Record::getValueType, Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ValueType.COMPENSATION_SUBSCRIPTION, CompensationSubscriptionIntent.TRIGGERED}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{ValueType.INCIDENT, IncidentIntent.CREATED}), Assertions.tuple((Object[])new Object[]{ValueType.INCIDENT, IncidentIntent.RESOLVED}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{ValueType.COMPENSATION_SUBSCRIPTION, CompensationSubscriptionIntent.COMPLETED})});
    }

    @Test
    public void shouldCreateIncidentIfOutputMappingsFail() {
        ENGINE.deployment().withXmlResource(this.processWithCompensation(compensationHandler -> compensationHandler.zeebeOutputExpression("assert(x, x != null)", "not_null"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType("Undo-A").complete();
        ENGINE.variables().ofScope(processInstanceKey).withDocument(Map.of("x", "1")).update();
        ENGINE.incident().ofInstance(processInstanceKey).resolve();
        Assertions.assertThat((Stream)RecordingExporter.records().limitToProcessInstance(processInstanceKey)).extracting(new Function[]{Record::getValueType, Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ValueType.COMPENSATION_SUBSCRIPTION, CompensationSubscriptionIntent.TRIGGERED}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{ValueType.INCIDENT, IncidentIntent.CREATED}), Assertions.tuple((Object[])new Object[]{ValueType.INCIDENT, IncidentIntent.RESOLVED}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{ValueType.COMPENSATION_SUBSCRIPTION, CompensationSubscriptionIntent.COMPLETED})});
    }

    @Test
    public void shouldResolveIncidentIfCompensationHandlerTerminates() {
        ENGINE.deployment().withXmlResource(this.processWithCompensation(compensationHandler -> {})).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType("Undo-A").fail();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Assertions.assertThat((Stream)RecordingExporter.records().limitToProcessInstance(processInstanceKey)).extracting(new Function[]{Record::getValueType, Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ValueType.COMPENSATION_SUBSCRIPTION, CompensationSubscriptionIntent.TRIGGERED}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{ValueType.INCIDENT, IncidentIntent.CREATED}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.CANCEL}), Assertions.tuple((Object[])new Object[]{ValueType.COMPENSATION_SUBSCRIPTION, CompensationSubscriptionIntent.DELETED}), Assertions.tuple((Object[])new Object[]{ValueType.INCIDENT, IncidentIntent.RESOLVED}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, ProcessInstanceIntent.ELEMENT_TERMINATED})});
    }
}

