/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class JobUpdateTimeoutTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static String jobType;
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Before
    public void setup() {
        jobType = Strings.newRandomValidBpmnId();
    }

    @Test
    public void shouldIncreaseJobTimeout() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).withTimeout(Duration.ofMinutes(5L).toMillis()).activate();
        JobRecordValue job = (JobRecordValue)((JobBatchRecordValue)batchRecord.getValue()).getJobs().get(0);
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        long timeout = Duration.ofMinutes(10L).toMillis();
        Record<JobRecordValue> updatedRecord = ENGINE.job().withKey(jobKey).withTimeout(timeout).updateTimeout();
        JobUpdateTimeoutTest.assertJobDeadline(updatedRecord, jobKey, job, timeout);
    }

    @Test
    public void shouldDecreaseJobTimeout() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).withTimeout(Duration.ofMinutes(15L).toMillis()).activate();
        JobRecordValue job = (JobRecordValue)((JobBatchRecordValue)batchRecord.getValue()).getJobs().get(0);
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        long timeout = Duration.ofMinutes(10L).toMillis();
        Record<JobRecordValue> updatedRecord = ENGINE.job().withKey(jobKey).withTimeout(timeout).updateTimeout();
        JobUpdateTimeoutTest.assertJobDeadline(updatedRecord, jobKey, job, timeout);
    }

    @Test
    public void shouldRejectUpdateTimoutIfJobNotFound() {
        long jobKey = 123L;
        long timeout = Duration.ofMinutes(10L).toMillis();
        Record<JobRecordValue> jobRecord = ENGINE.job().withKey(123L).withTimeout(timeout).expectRejection().updateTimeout();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobRecord).hasRejectionType(RejectionType.NOT_FOUND).hasRejectionReason("Expected to update job deadline with key '%d', but no such job was found".formatted(123L));
    }

    @Test
    public void shouldRejectUpdateTimoutIfDeadlineNotFound() {
        Record<JobRecordValue> job = ENGINE.createJob(jobType, PROCESS_ID);
        long timeout = Duration.ofMinutes(10L).toMillis();
        Record<JobRecordValue> jobRecord = ENGINE.job().withKey(job.getKey()).withTimeout(timeout).expectRejection().updateTimeout();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobRecord).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason("Expected to update the timeout of job with key '%d', but it is not active".formatted(job.getKey()));
    }

    @Test
    public void shouldIncreaseJobTimeoutSecondTime() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).withTimeout(Duration.ofMinutes(5L).toMillis()).activate();
        JobRecordValue job = (JobRecordValue)((JobBatchRecordValue)batchRecord.getValue()).getJobs().get(0);
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        long firstTimeout = Duration.ofMinutes(10L).toMillis();
        long secondTimeout = Duration.ofMinutes(20L).toMillis();
        ENGINE.job().withKey(jobKey).withTimeout(firstTimeout).updateTimeout();
        Record<JobRecordValue> updatedRecord = ENGINE.job().withKey(jobKey).withTimeout(secondTimeout).updateTimeout();
        JobUpdateTimeoutTest.assertJobDeadline(updatedRecord, jobKey, job, secondTimeout);
    }

    @Test
    public void shouldTimeOutAfterDecreasingTimeout() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).withTimeout(Duration.ofMinutes(10L).toMillis()).activate();
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        long timeout = Duration.ofMinutes(5L).toMillis();
        ENGINE.job().withKey(jobKey).withTimeout(timeout).updateTimeout();
        ENGINE.increaseTime(Duration.ofMinutes(6L));
        List jobEvents = (List)((JobRecordStream)RecordingExporter.jobRecords().withType(jobType).limit(4L)).collect(Collectors.toList());
        Assertions.assertThat((List)jobEvents).extracting(Record::getKey).contains((Object[])new Long[]{jobKey});
        Assertions.assertThat((List)jobEvents).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{JobIntent.CREATED, JobIntent.TIMEOUT_UPDATED, JobIntent.TIME_OUT, JobIntent.TIMED_OUT});
    }

    @Test
    public void shouldTimeOutAfterIncreasingTimeout() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).withTimeout(Duration.ofMinutes(10L).toMillis()).activate();
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        long timeout = Duration.ofMinutes(15L).toMillis();
        ENGINE.job().withKey(jobKey).withTimeout(timeout).updateTimeout();
        ENGINE.increaseTime(Duration.ofMinutes(16L));
        List jobEvents = (List)((JobRecordStream)RecordingExporter.jobRecords().withType(jobType).limit(4L)).collect(Collectors.toList());
        Assertions.assertThat((List)jobEvents).extracting(Record::getKey).contains((Object[])new Long[]{jobKey});
        Assertions.assertThat((List)jobEvents).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{JobIntent.CREATED, JobIntent.TIMEOUT_UPDATED, JobIntent.TIME_OUT, JobIntent.TIMED_OUT});
    }

    @Test
    public void shouldUpdateJobTimeoutForCustomTenant() {
        String tenantId = "acme";
        ENGINE.createJob(jobType, PROCESS_ID, Collections.emptyMap(), "acme");
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).withTimeout(Duration.ofMinutes(5L).toMillis()).withTenantId("acme").activate();
        JobRecordValue job = (JobRecordValue)((JobBatchRecordValue)batchRecord.getValue()).getJobs().get(0);
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        long timeout = Duration.ofMinutes(10L).toMillis();
        Record<JobRecordValue> updatedRecord = ENGINE.job().withKey(jobKey).withTimeout(timeout).withAuthorizedTenantIds("acme").updateTimeout();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)updatedRecord.getValue())).hasTenantId("acme");
        JobUpdateTimeoutTest.assertJobDeadline(updatedRecord, jobKey, job, timeout);
    }

    @Test
    public void shouldRejectUpdateRetriesIfTenantIsUnauthorized() {
        String tenantId = "acme";
        String falseTenantId = "foo";
        ENGINE.createJob(jobType, PROCESS_ID, Collections.emptyMap(), "acme");
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).withTimeout(Duration.ofMinutes(5L).toMillis()).withTenantId("acme").activate();
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        long timeout = Duration.ofMinutes(10L).toMillis();
        Record<JobRecordValue> jobRecord = ENGINE.job().withKey(jobKey).withTimeout(timeout).withAuthorizedTenantIds("foo").expectRejection().updateTimeout();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }

    private static void assertJobDeadline(Record<JobRecordValue> updatedRecord, long jobKey, JobRecordValue job, long timeout) {
        io.camunda.zeebe.protocol.record.Assertions.assertThat(updatedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.TIMEOUT_UPDATED);
        Assertions.assertThat((long)updatedRecord.getKey()).isEqualTo(jobKey);
        Assertions.assertThat((long)((JobRecordValue)updatedRecord.getValue()).getDeadline()).isNotEqualTo(job.getDeadline());
        Assertions.assertThat((long)((JobRecordValue)updatedRecord.getValue()).getDeadline()).isCloseTo(ENGINE.getClock().getCurrentTimeInMillis() + timeout, Assertions.within((Long)Duration.ofMillis(100L).toMillis()));
    }
}

