/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.multitenancy;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordAssert;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ResourceDeletionIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ResourceDeletionRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsMetadataValue;
import io.camunda.zeebe.protocol.record.value.deployment.FormMetadataValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.ResourceDeletionRecordStream;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class TenantAwareResourceDeletionTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String DRG_SINGLE_DECISION = "/dmn/decision-table.dmn";
    private static final String TEST_FORM_1 = "/form/test-form-1.form";
    private static final BpmnModelInstance PROCESS = Bpmn.createExecutableProcess((String)"test").startEvent().endEvent().done();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();
    private final String tenantIdA = "tenant-a";
    private final String tenantIdB = "tenant-b";

    @Test
    public void shouldDeleteProcessForAuthorizedTenant() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(PROCESS).withTenantId("tenant-a").deploy();
        long resourceKey = ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        Record<ResourceDeletionRecordValue> deleted = ENGINE.resourceDeletion().withResourceKey(resourceKey).withAuthorizedTenantIds("tenant-a").delete();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ResourceDeletionRecordValue)((ResourceDeletionRecordValue)deleted.getValue())).hasTenantId("tenant-a");
        this.verifyResourceIsDeleted(resourceKey);
    }

    @Test
    public void shouldDeleteDecisionForAuthorizedTenant() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlClasspathResource(DRG_SINGLE_DECISION).withTenantId("tenant-a").deploy();
        long resourceKey = ((DecisionRequirementsMetadataValue)((DeploymentRecordValue)deployment.getValue()).getDecisionRequirementsMetadata().get(0)).getDecisionRequirementsKey();
        Record<ResourceDeletionRecordValue> deleted = ENGINE.resourceDeletion().withResourceKey(resourceKey).withAuthorizedTenantIds("tenant-a").delete();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ResourceDeletionRecordValue)((ResourceDeletionRecordValue)deleted.getValue())).hasTenantId("tenant-a");
        this.verifyResourceIsDeleted(resourceKey);
    }

    @Test
    public void shouldDeleteFormForAuthorizedTenant() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlClasspathResource(TEST_FORM_1).withTenantId("tenant-a").deploy();
        long resourceKey = ((FormMetadataValue)((DeploymentRecordValue)deployment.getValue()).getFormMetadata().get(0)).getFormKey();
        Record<ResourceDeletionRecordValue> deleted = ENGINE.resourceDeletion().withResourceKey(resourceKey).withAuthorizedTenantIds("tenant-a").delete();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ResourceDeletionRecordValue)((ResourceDeletionRecordValue)deleted.getValue())).hasTenantId("tenant-a");
        this.verifyResourceIsDeleted(resourceKey);
    }

    @Test
    public void shouldNotDeleteResourceForUnauthorizedTenant() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(PROCESS).withTenantId("tenant-a").deploy();
        long resourceKey = ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        Record<ResourceDeletionRecordValue> rejection = ENGINE.resourceDeletion().withResourceKey(resourceKey).withAuthorizedTenantIds("tenant-b").expectRejection().delete();
        ((RecordAssert)RecordAssert.assertThat(rejection).describedAs("Expect resource is not found", new Object[0])).hasRejectionType(RejectionType.NOT_FOUND).hasRejectionReason("Expected to delete resource but no resource found with key `%d`".formatted(resourceKey));
        Assertions.assertThat((boolean)((ResourceDeletionRecordStream)RecordingExporter.resourceDeletionRecords().withIntent((Intent)ResourceDeletionIntent.DELETED)).exists()).isFalse();
    }

    private void verifyResourceIsDeleted(long key) {
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.resourceDeletionRecords().limit(r -> r.getIntent().equals((Object)ResourceDeletionIntent.DELETED))).describedAs("Expect resource to be deleted", new Object[0])).extracting(new Function[]{Record::getIntent, r -> ((ResourceDeletionRecordValue)r.getValue()).getResourceKey()}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ResourceDeletionIntent.DELETE, key}), Assertions.tuple((Object[])new Object[]{ResourceDeletionIntent.DELETING, key}), Assertions.tuple((Object[])new Object[]{ResourceDeletionIntent.DELETED, key})});
    }
}

