/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance.migration;

import io.camunda.zeebe.engine.processing.processinstance.migration.MigrationTestUtil;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceMigrationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValueAssert;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class MigrateBoundaryEventTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Test
    public void shouldUnsubscribeUnmappedMessageBoundaryEvent() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().userTask("A").boundaryEvent("boundary").message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).endEvent().moveToActivity("A").endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().userTask("B").endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("key", "key").create();
        RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.DELETED).withProcessInstanceKey(processInstanceKey).withMessageName("message").withCorrelationKey("key").exists()).describedAs("Expect that the message boundary event is unsubscribed", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.DELETED).withProcessInstanceKey(processInstanceKey).withMessageName("message").withCorrelationKey("key").exists()).describedAs("Expect that the message boundary event is unsubscribed", new Object[0])).isTrue();
    }

    @Test
    public void shouldSubscribeUnmappedMessageBoundaryEvent() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().userTask("A").endEvent().done()).withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)targetProcessId).startEvent().userTask("B").boundaryEvent("boundary").message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).endEvent().moveToActivity("B").endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("key", "key").create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).withMessageName("message").withCorrelationKey("key").exists()).describedAs("Expect that the message boundary event is subscribed", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).withMessageName("message").withCorrelationKey("key").exists()).describedAs("Expect that the message boundary event is subscribed", new Object[0])).isTrue();
    }

    @Test
    public void shouldUnsubscribeAndSubscribeUnmappedMessageBoundaryEvents() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().userTask("A").boundaryEvent("boundary").message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).endEvent().moveToActivity("A").endEvent().done()).withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)targetProcessId).startEvent().userTask("B").boundaryEvent("boundary").message(m -> m.name("message2").zeebeCorrelationKeyExpression("key"))).endEvent().moveToActivity("B").endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("key", "key").create();
        RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        Assertions.assertThat((Stream)RecordingExporter.records().between(r -> r.getIntent() == ProcessInstanceMigrationIntent.MIGRATE, r -> r.getIntent() == ProcessMessageSubscriptionIntent.DELETED)).extracting(Record::getIntent).describedAs("Expect that the message boundary event is unsubscribed after the migration", new Object[0]).contains((Object[])new Intent[]{MessageSubscriptionIntent.DELETE, ProcessMessageSubscriptionIntent.DELETED});
        Assertions.assertThat((Stream)RecordingExporter.records().between(r -> r.getIntent() == ProcessInstanceMigrationIntent.MIGRATE, r -> r.getIntent() == ProcessMessageSubscriptionIntent.CREATED)).extracting(Record::getIntent).describedAs("Expect that the message boundary event is subscribed to after the migration", new Object[0]).contains((Object[])new Intent[]{MessageSubscriptionIntent.CREATED, ProcessMessageSubscriptionIntent.CREATED});
    }

    @Test
    public void shouldMigrateSubprocessWithBoundaryEvent() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().subProcess("sub1", s -> s.embeddedSubProcess().startEvent().serviceTask("A", t -> t.zeebeJobType("task")).endEvent()).boundaryEvent("boundary").message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).endEvent().moveToActivity("sub1").endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().subProcess("sub2", s -> s.embeddedSubProcess().startEvent().serviceTask("B", t -> t.zeebeJobType("task")).endEvent()).endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("key", "key").create();
        RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").addMappingInstruction("sub1", "sub2").migrate();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.DELETED).withProcessInstanceKey(processInstanceKey).withMessageName("message").withCorrelationKey("key").exists()).describedAs("Expect that the message boundary event is unsubscribed", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.DELETED).withProcessInstanceKey(processInstanceKey).withMessageName("message").withCorrelationKey("key").exists()).describedAs("Expect that the process message subscription is unsubscribed", new Object[0])).isTrue();
        ((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_MIGRATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SUB_PROCESS).getFirst()).getValue())).describedAs("Expect that process definition key changed", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).describedAs("Expect that bpmn process id and element id changed", new Object[0])).hasBpmnProcessId(targetProcessId).hasElementId("sub2").describedAs("Expect that version number did not change", new Object[0])).hasVersion(1);
    }

    @Test
    public void shouldMigrateSubprocessWithBoundaryEventInTarget() {
        String processId = "process";
        String targetProcessId = "process2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().subProcess("sub1", s -> s.embeddedSubProcess().startEvent().serviceTask("A", t -> t.zeebeJobType("task")).endEvent()).endEvent().done()).withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process2").startEvent().subProcess("sub2", s -> s.embeddedSubProcess().startEvent().serviceTask("B", t -> t.zeebeJobType("task")).endEvent()).boundaryEvent("boundary").message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).endEvent().moveToActivity("sub2").endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, "process2");
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withVariable("key", "key").create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementId("A").await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").addMappingInstruction("sub1", "sub2").migrate();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).withMessageName("message").withCorrelationKey("key").exists()).describedAs("Expect that the message boundary event is subscribed", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).withMessageName("message").withCorrelationKey("key").exists()).describedAs("Expect that the process message subscription is subscribed", new Object[0])).isTrue();
        ((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_MIGRATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SUB_PROCESS).getFirst()).getValue())).describedAs("Expect that process definition key changed", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).describedAs("Expect that bpmn process id and element id changed", new Object[0])).hasBpmnProcessId("process2").hasElementId("sub2").describedAs("Expect that version number did not change", new Object[0])).hasVersion(1);
    }
}

