/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance.migration;

import io.camunda.zeebe.engine.processing.processinstance.migration.MigrationTestUtil;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValueAssert;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Optional;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class MigrateIncidentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Test
    public void shouldWriteMigratedEventWhenActiveElementHasAJobIncident() {
        String sourceProcessId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)sourceProcessId).startEvent().serviceTask("A", t -> t.zeebeJobType("jobTypeA")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("B", t -> t.zeebeJobType("jobTypeB")).endEvent("target_process_end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(sourceProcessId).create();
        Record<JobRecordValue> failedEvent = ENGINE.job().withType("jobTypeA").ofInstance(processInstanceKey).withRetries(0).fail();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withJobKey(failedEvent.getKey()).getFirst();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)((Record)((IncidentRecordStream)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.MIGRATED).withRecordKey(incident.getKey())).getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).describedAs("Expect that element id changed due to mapping", new Object[0])).hasElementId("B").describedAs("Expect that other properties of the incident did not change", new Object[0])).hasErrorType(((IncidentRecordValue)incident.getValue()).getErrorType()).hasErrorMessage(((IncidentRecordValue)incident.getValue()).getErrorMessage()).hasProcessInstanceKey(((IncidentRecordValue)incident.getValue()).getProcessInstanceKey()).hasElementInstanceKey(((IncidentRecordValue)incident.getValue()).getElementInstanceKey()).hasJobKey(((IncidentRecordValue)incident.getValue()).getJobKey()).hasVariableScopeKey(((IncidentRecordValue)incident.getValue()).getVariableScopeKey()).hasTenantId(((IncidentRecordValue)incident.getValue()).getTenantId());
        Record<IncidentRecordValue> incidentRecord = ENGINE.incident().ofInstance(processInstanceKey).withKey(incident.getKey()).resolve();
        ((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentRecord.getValue())).describedAs("Expect that the incident resolved event contains updated fields", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).hasElementId("B");
        ENGINE.job().ofInstance(processInstanceKey).withType("jobTypeA").complete();
        ((OptionalAssert)Assertions.assertThat((Optional)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.END_EVENT).withElementId("target_process_end").findAny()).describedAs("Expect that the process instance is continued in the target process", new Object[0])).isPresent();
    }

    @Test
    public void shouldWriteMigratedEventWhenActiveElementHasAProcessIncident() {
        String sourceProcessId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)sourceProcessId).startEvent().serviceTask("A", b -> ((ServiceTaskBuilder)b.zeebeJobType("jobTypeA")).zeebeInputExpression("assert(x, x != null)", "y")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("B", t -> t.zeebeJobType("jobTypeB")).endEvent("target_process_end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(sourceProcessId).create();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        ((IncidentRecordValueAssert)((IncidentRecordValueAssert)((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)((Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.MIGRATED).withProcessInstanceKey(processInstanceKey).getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).describedAs("Expect that element id changed due to mapping", new Object[0])).hasElementId("B").describedAs("Expect that other properties of the incident did not change", new Object[0])).hasErrorType(((IncidentRecordValue)incident.getValue()).getErrorType()).hasErrorMessage(((IncidentRecordValue)incident.getValue()).getErrorMessage()).hasProcessInstanceKey(((IncidentRecordValue)incident.getValue()).getProcessInstanceKey()).hasElementInstanceKey(((IncidentRecordValue)incident.getValue()).getElementInstanceKey()).hasJobKey(((IncidentRecordValue)incident.getValue()).getJobKey()).hasVariableScopeKey(((IncidentRecordValue)incident.getValue()).getVariableScopeKey()).hasTenantId(((IncidentRecordValue)incident.getValue()).getTenantId());
        Record<IncidentRecordValue> incidentRecord = ENGINE.incident().ofInstance(processInstanceKey).withKey(incident.getKey()).resolve();
        ((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentRecord.getValue())).describedAs("Expect that the incident resolved event contains updated fields", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).hasElementId("B");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId("B").exists()).describedAs("Expect that the job is created in the migrated process", new Object[0])).isTrue();
        ENGINE.job().ofInstance(processInstanceKey).withType("jobTypeB").complete();
        ((OptionalAssert)Assertions.assertThat((Optional)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.END_EVENT).withElementId("target_process_end").findAny()).describedAs("Expect that the process instance is continued in the target process", new Object[0])).isPresent();
    }
}

