/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance.migration;

import io.camunda.zeebe.engine.processing.processinstance.migration.MigrationTestUtil;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.RecordToWrite;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceMigrationMappingInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceMigrationRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceMigrationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceMigrationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.ProcessInstanceMigrationRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.time.Duration;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class MigrateProcessInstanceConcurrentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Test
    public void shouldContinueMigratedInstanceWithJobCompleteBefore() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).serviceTask("B_v1", s -> s.zeebeJobType("B")).endEvent("end_v1").done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).serviceTask("B_v2", s -> s.zeebeJobType("B")).endEvent("end_v2").done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        long jobKey = ((Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getKey();
        ENGINE.writeRecords(RecordToWrite.command().job(JobIntent.COMPLETE, (JobRecordValue)new JobRecord()).key(jobKey), RecordToWrite.command().migration((ProcessInstanceMigrationRecordValue)new ProcessInstanceMigrationRecord().setProcessInstanceKey(processInstanceKey).setTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction(new ProcessInstanceMigrationMappingInstruction().setSourceElementId("A").setTargetElementId("A"))));
        Record migrationRejection = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords((ProcessInstanceMigrationIntent)ProcessInstanceMigrationIntent.MIGRATE).withProcessInstanceKey(processInstanceKey).onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)migrationRejection).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(MigrateProcessInstanceConcurrentTest.createMigrationRejectionDueMissingMappingReason(processInstanceKey));
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("B_v1", "B_v2").migrate();
        ENGINE.job().ofInstance(processInstanceKey).withType("B").complete();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"B_v2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end_v2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{targetProcessId, ProcessInstanceIntent.ELEMENT_COMPLETED})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"B_v1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end_v1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{processId, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldContinueMigratedInstanceWithJobCompleteAfter() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).serviceTask("B_v1", s -> s.zeebeJobType("B")).endEvent("end_v1").done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).serviceTask("B_v2", s -> s.zeebeJobType("B")).endEvent("end_v2").done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        long jobKey = ((Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getKey();
        ENGINE.writeRecords(RecordToWrite.command().migration((ProcessInstanceMigrationRecordValue)new ProcessInstanceMigrationRecord().setProcessInstanceKey(processInstanceKey).setTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction(new ProcessInstanceMigrationMappingInstruction().setSourceElementId("A").setTargetElementId("A"))), RecordToWrite.command().job(JobIntent.COMPLETE, (JobRecordValue)new JobRecord()).key(jobKey));
        ENGINE.job().ofInstance(processInstanceKey).withType("B").complete();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"A", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"B_v2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end_v2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{targetProcessId, ProcessInstanceIntent.ELEMENT_COMPLETED})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"B_v1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end_v1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{processId, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Ignore(value="Ignore until the migration is supported for tasks with boundary events")
    @Test
    public void shouldContinueMigratedInstanceWithTimerBefore() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", t -> t.zeebeJobType("A")).boundaryEvent("timer", b -> b.timerWithDuration("PT1H")).serviceTask("B_v1", t -> t.zeebeJobType("B")).endEvent("end_v1").moveToActivity("A").endEvent("end_2_v1").done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("A", t -> t.zeebeJobType("A")).boundaryEvent("timer", b -> b.timerWithDuration("PT1H")).serviceTask("B_v2", t -> t.zeebeJobType("B")).endEvent("end_v2").moveToActivity("A").endEvent("end_2_v2").done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        Record timerCreated = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.writeRecords(RecordToWrite.command().timer(TimerIntent.TRIGGER, (TimerRecordValue)timerCreated.getValue()).key(timerCreated.getKey()), RecordToWrite.command().migration((ProcessInstanceMigrationRecordValue)new ProcessInstanceMigrationRecord().setProcessInstanceKey(processInstanceKey).setTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction(new ProcessInstanceMigrationMappingInstruction().setSourceElementId("A").setTargetElementId("A"))));
        Record migrationRejection = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords((ProcessInstanceMigrationIntent)ProcessInstanceMigrationIntent.MIGRATE).withProcessInstanceKey(processInstanceKey).onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)migrationRejection).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(MigrateProcessInstanceConcurrentTest.createMigrationRejectionDueMissingMappingReason(processInstanceKey));
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("B_v1", "B_v2").migrate();
        ENGINE.job().ofInstance(processInstanceKey).withType("B").complete();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"B_v2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end_v2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{targetProcessId, ProcessInstanceIntent.ELEMENT_COMPLETED})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"B_v1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end_v1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{processId, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Ignore(value="Ignore until the migration is supported for tasks with boundary events")
    @Test
    public void shouldContinueMigratedInstanceWithTimerAfter() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", t -> t.zeebeJobType("A")).boundaryEvent("timer", b -> b.timerWithDuration("PT1H")).serviceTask("B_v1", t -> t.zeebeJobType("B")).endEvent("end_v1").moveToActivity("A").endEvent("end_2_v1").done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("A", t -> t.zeebeJobType("A")).boundaryEvent("timer", b -> b.timerWithDuration("PT1H")).serviceTask("B_v2", t -> t.zeebeJobType("B")).endEvent("end_v2").moveToActivity("A").endEvent("end_2_v2").done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        Record timerCreated = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.writeRecords(RecordToWrite.command().migration((ProcessInstanceMigrationRecordValue)new ProcessInstanceMigrationRecord().setProcessInstanceKey(processInstanceKey).setTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction(new ProcessInstanceMigrationMappingInstruction().setSourceElementId("A").setTargetElementId("A"))), RecordToWrite.command().timer(TimerIntent.TRIGGER, (TimerRecordValue)timerCreated.getValue()).key(timerCreated.getKey()));
        ENGINE.increaseTime(Duration.ofHours(1L));
        ENGINE.job().ofInstance(processInstanceKey).withType("B").complete();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"B_v2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end_v2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{targetProcessId, ProcessInstanceIntent.ELEMENT_COMPLETED})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"B_v1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end_v1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{processId, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldContinueMigratedInstanceWithMessageBefore() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", t -> t.zeebeJobType("A")).boundaryEvent("message", b -> b.message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).serviceTask("B_v1", t -> t.zeebeJobType("B")).endEvent("end_v1").moveToActivity("A").endEvent("end_2_v1").done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("A", t -> t.zeebeJobType("A")).boundaryEvent("message", b -> b.message(m -> m.name("message2").zeebeCorrelationKeyExpression("key"))).serviceTask("B_v2", t -> t.zeebeJobType("B")).endEvent("end_v2").moveToActivity("A").endEvent("end_2_v2").done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("key", this.helper.getCorrelationValue()).create();
        RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.writeRecords(RecordToWrite.command().message(MessageIntent.PUBLISH, (MessageRecordValue)new MessageRecord().setName("message").setCorrelationKey(this.helper.getCorrelationValue()).setTimeToLive(Duration.ofHours(1L).toMillis())), RecordToWrite.command().migration((ProcessInstanceMigrationRecordValue)new ProcessInstanceMigrationRecord().setProcessInstanceKey(processInstanceKey).setTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction(new ProcessInstanceMigrationMappingInstruction().setSourceElementId("A").setTargetElementId("A"))));
        Record migrationRejection = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords((ProcessInstanceMigrationIntent)ProcessInstanceMigrationIntent.MIGRATE).withProcessInstanceKey(processInstanceKey).onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)migrationRejection).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(MigrateProcessInstanceConcurrentTest.createMigrationRejectionDueMissingMappingReason(processInstanceKey));
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("B_v1", "B_v2").migrate();
        ENGINE.job().ofInstance(processInstanceKey).withType("B").complete();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"B_v2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end_v2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{targetProcessId, ProcessInstanceIntent.ELEMENT_COMPLETED})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"B_v1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end_v1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{processId, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldContinueMigratedInstanceWithMessageAfter() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", t -> t.zeebeJobType("A")).boundaryEvent("message", b -> b.message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).serviceTask("B_v1", t -> t.zeebeJobType("B")).endEvent("end_v1").moveToActivity("A").endEvent("end_2_v1").done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("A", t -> t.zeebeJobType("A")).boundaryEvent("message", b -> b.message(m -> m.name("message2").zeebeCorrelationKeyExpression("key"))).serviceTask("B_v2", t -> t.zeebeJobType("B")).endEvent("end_v2").moveToActivity("A").endEvent("end_2_v2").done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("key", this.helper.getCorrelationValue()).create();
        RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.writeRecords(RecordToWrite.command().migration((ProcessInstanceMigrationRecordValue)new ProcessInstanceMigrationRecord().setProcessInstanceKey(processInstanceKey).setTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction(new ProcessInstanceMigrationMappingInstruction().setSourceElementId("A").setTargetElementId("A"))), RecordToWrite.command().message(MessageIntent.PUBLISH, (MessageRecordValue)new MessageRecord().setName("message").setCorrelationKey(this.helper.getCorrelationValue()).setTimeToLive(Duration.ofHours(1L).toMillis())));
        ENGINE.message().withName("message2").withCorrelationKey(this.helper.getCorrelationValue()).publish();
        ENGINE.job().ofInstance(processInstanceKey).withType("B").complete();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"B_v2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end_v2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{targetProcessId, ProcessInstanceIntent.ELEMENT_COMPLETED})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"B_v1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end_v1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{processId, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldContinueMigratedInstanceWithMessageCorrelateBefore() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", t -> t.zeebeJobType("A")).boundaryEvent("message", b -> b.message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).serviceTask("B_v1", t -> t.zeebeJobType("B")).endEvent("end_v1").moveToActivity("A").endEvent("end_2_v1").done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("A", t -> t.zeebeJobType("A")).boundaryEvent("message", b -> b.message(m -> m.name("message2").zeebeCorrelationKeyExpression("key"))).serviceTask("B_v2", t -> t.zeebeJobType("B")).endEvent("end_v2").moveToActivity("A").endEvent("end_2_v2").done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("key", this.helper.getCorrelationValue()).create();
        Record subscriptionCreated = (Record)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ProcessMessageSubscriptionRecord subscriptionCommand = new ProcessMessageSubscriptionRecord();
        subscriptionCommand.wrap((ProcessMessageSubscriptionRecord)subscriptionCreated.getValue());
        subscriptionCommand.setMessageKey(1L);
        ENGINE.writeRecords(RecordToWrite.command().processMessageSubscription(ProcessMessageSubscriptionIntent.CORRELATE, (ProcessMessageSubscriptionRecordValue)subscriptionCommand).key(subscriptionCreated.getKey()), RecordToWrite.command().migration((ProcessInstanceMigrationRecordValue)new ProcessInstanceMigrationRecord().setProcessInstanceKey(processInstanceKey).setTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction(new ProcessInstanceMigrationMappingInstruction().setSourceElementId("A").setTargetElementId("A"))));
        Record migrationRejection = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords((ProcessInstanceMigrationIntent)ProcessInstanceMigrationIntent.MIGRATE).withProcessInstanceKey(processInstanceKey).onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)migrationRejection).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(MigrateProcessInstanceConcurrentTest.createMigrationRejectionDueMissingMappingReason(processInstanceKey));
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("B_v1", "B_v2").migrate();
        ENGINE.job().ofInstance(processInstanceKey).withType("B").complete();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"B_v2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end_v2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{targetProcessId, ProcessInstanceIntent.ELEMENT_COMPLETED})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"B_v1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end_v1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{processId, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Ignore(value="Ignore until the migration is supported for tasks with boundary events")
    @Test
    public void shouldContinueMigratedInstanceWithNonInterruptingTimerBefore() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", t -> t.zeebeJobType("A")).boundaryEvent("timer", b -> b.timerWithDuration("PT1H")).cancelActivity(Boolean.valueOf(false))).serviceTask("B_v1", t -> t.zeebeJobType("B")).endEvent("end_v1").moveToActivity("A").endEvent("end_2_v1").done()).withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("A", t -> t.zeebeJobType("A")).boundaryEvent("timer", b -> b.timerWithDuration("PT1H")).cancelActivity(Boolean.valueOf(false))).serviceTask("B_v2", t -> t.zeebeJobType("B")).endEvent("end_v2").moveToActivity("A").endEvent("end_2_v2").done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        Record timerCreated = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.writeRecords(RecordToWrite.command().timer(TimerIntent.TRIGGER, (TimerRecordValue)timerCreated.getValue()).key(timerCreated.getKey()), RecordToWrite.command().migration((ProcessInstanceMigrationRecordValue)new ProcessInstanceMigrationRecord().setProcessInstanceKey(processInstanceKey).setTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction(new ProcessInstanceMigrationMappingInstruction().setSourceElementId("A").setTargetElementId("A"))));
        Record migrationRejection = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords((ProcessInstanceMigrationIntent)ProcessInstanceMigrationIntent.MIGRATE).withProcessInstanceKey(processInstanceKey).onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)migrationRejection).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(MigrateProcessInstanceConcurrentTest.createMigrationRejectionDueMissingMappingReason(processInstanceKey));
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").addMappingInstruction("B_v1", "B_v2").migrate();
        ENGINE.job().ofInstance(processInstanceKey).withType("B").complete();
        ENGINE.job().ofInstance(processInstanceKey).withType("A").complete();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"B_v2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end_v2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{targetProcessId, ProcessInstanceIntent.ELEMENT_COMPLETED})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"B_v1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end_v1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{processId, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldContinueMigratedInstanceWithElementActivateBefore() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).serviceTask("B_v1", s -> s.zeebeJobType("B")).endEvent("end_v1").done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).serviceTask("B_v2", s -> s.zeebeJobType("B")).endEvent("end_v2").done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        Record taskActivated = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").getFirst();
        ENGINE.writeRecords(RecordToWrite.command().processInstance(ProcessInstanceIntent.COMPLETE_ELEMENT, (ProcessInstanceRecordValue)taskActivated.getValue()).key(taskActivated.getKey()), RecordToWrite.command().migration((ProcessInstanceMigrationRecordValue)new ProcessInstanceMigrationRecord().setProcessInstanceKey(processInstanceKey).setTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction(new ProcessInstanceMigrationMappingInstruction().setSourceElementId("A").setTargetElementId("A"))));
        Record migrationRejection = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords((ProcessInstanceMigrationIntent)ProcessInstanceMigrationIntent.MIGRATE).withProcessInstanceKey(processInstanceKey).onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)migrationRejection).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(MigrateProcessInstanceConcurrentTest.createMigrationRejectionDueMissingMappingReason(processInstanceKey));
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("B_v1").await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("B_v1", "B_v2").migrate();
        ENGINE.job().ofInstance(processInstanceKey).withType("B").complete();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"B_v2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end_v2", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{targetProcessId, ProcessInstanceIntent.ELEMENT_COMPLETED})})).doesNotContain((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"B_v1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end_v1", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{processId, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    private static String createMigrationRejectionDueMissingMappingReason(long processInstanceKey) {
        return "Expected to migrate process instance '%d' but no mapping instruction defined for active element with id 'B_v1'. Elements cannot be migrated without a mapping.".formatted(processInstanceKey);
    }
}

