/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance.migration;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.UserTaskBuilder;
import io.camunda.zeebe.protocol.record.Assertions;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordAssert;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceMigrationIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceMigrationRecordValue;
import io.camunda.zeebe.test.util.record.ProcessInstanceMigrationRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.time.Duration;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class MigrateProcessInstanceRejectionTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldRejectCommandWhenProcessInstanceIsUnknown() {
        long unknownKey = 12345L;
        ENGINE.processInstance().withInstanceKey(12345L).migration().withTargetProcessDefinitionKey(1L).expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.NOT_FOUND).hasRejectionReason(String.format("Expected to migrate process instance but no process instance found with key '%d'", 12345L)).hasKey(12345L);
    }

    @Test
    public void shouldRejectCommandWhenTargetProcessDefinitionIsUnknown() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.zeebeJobType("task")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long unknownKey = 12345L;
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(12345L).expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.NOT_FOUND).hasRejectionReason(String.format("Expected to migrate process instance to process definition but no process definition found with key '%d'", 12345L)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenActiveElementIsNotMapped() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("A", t -> t.zeebeJobType("task")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("A", t -> t.zeebeJobType("task")).userTask("B").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(String.format("Expected to migrate process instance '%d' but no mapping instruction defined for active element with id 'A'. Elements cannot be migrated without a mapping.", processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenAnyElementsMappedToADifferentBpmnElementType() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("A", t -> t.zeebeJobType("task")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent().userTask("A").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(String.format("Expected to migrate process instance '%s' but active element with id 'A' and type 'SERVICE_TASK' is mapped to an element with id 'A' and different type 'USER_TASK'. Elements must be mapped to elements of the same type.", processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenMappingInstructionContainsANonExistingSourceElementId() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("A", t -> t.zeebeJobType("jobType")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("A", t -> t.zeebeJobType("jobType")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("B", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason(String.format("Expected to migrate process instance '%s' but mapping instructions contain a non-existing source element id 'B'. Elements provided in mapping instructions must exist in the source process definition.", processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenMappingInstructionContainsANonExistingTargetElementId() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("A", t -> t.zeebeJobType("jobType")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("A", t -> t.zeebeJobType("jobType")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason(String.format("Expected to migrate process instance '%s' but mapping instructions contain a non-existing target element id 'B'. Elements provided in mapping instructions must exist in the target process definition.", processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenElementFlowScopeIsChangedInTargetProcessDefinition() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent("start").serviceTask("A", t -> t.zeebeJobType("task")).endEvent("end").done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent("start").subProcess("sub", s -> s.embeddedSubProcess().startEvent().serviceTask("A", t -> t.zeebeJobType("task")).endEvent()).endEvent("end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(String.format("Expected to migrate process instance '%s' but the flow scope of active element with id 'A' is changed. The flow scope of the active element is expected to be 'process2' but was 'sub'. The flow scope of an element cannot be changed during migration yet.", processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenElementFlowScopeIsChangedInTargetProcessDefinitionDeeper() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent("start").serviceTask("A", t -> t.zeebeJobType("task")).endEvent("end").done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent("start").subProcess("sub1", s -> s.embeddedSubProcess().startEvent().subProcess("sub2", s2 -> s2.embeddedSubProcess().startEvent().serviceTask("A", t -> t.zeebeJobType("task")).endEvent()).endEvent()).endEvent("end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(String.format("Expected to migrate process instance '%s' but the flow scope of active element with id 'A' is changed. The flow scope of the active element is expected to be 'process2' but was 'sub2'. The flow scope of an element cannot be changed during migration yet.", processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenTheMigratedProcessInstanceIsAChildProcessInstance() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().callActivity("call", c -> c.zeebeProcessId("childProcess")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"childProcess").startEvent().serviceTask("A", t -> t.zeebeJobType("A")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("A", t -> t.zeebeJobType("A")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        RecordingExporter.processInstanceRecords().withParentProcessInstanceKey(processInstanceKey).withBpmnProcessId("childProcess").await();
        long childProcessInstanceKey = ((Record)RecordingExporter.processInstanceRecords().withParentProcessInstanceKey(processInstanceKey).withBpmnProcessId("childProcess").getFirst()).getKey();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(childProcessInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(String.format("Expected to migrate process instance '%s' but process instance is a child process instance. Child process instances cannot be migrated.", childProcessInstanceKey)).hasKey(childProcessInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenSourceElementIdIsMappedInMultipleMappingInstructions() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("A", t -> t.zeebeJobType("task")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("A", t -> t.zeebeJobType("task")).serviceTask("B", t -> t.zeebeJobType("task")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").addMappingInstruction("A", "B").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason(String.format("Expected to migrate process instance '%s' but the mapping instructions contain duplicate source element ids '%s'.", processInstanceKey, "[A]")).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenTheMigratedProcessInstanceContainsATaskSubscribedToABoundaryEvent() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("start").serviceTask("A", t -> t.zeebeJobType("A")).boundaryEvent("boundary").timerWithDuration(Duration.ofDays(1L))).endEvent().moveToActivity("A").endEvent("end").done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent("start").serviceTask("A", t -> t.zeebeJobType("A")).endEvent("end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).withHandlerNodeId("boundary").await();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason("Expected to migrate process instance '%s' but active element with id 'A' has one or more boundary events of types 'TIMER'. Migrating active elements with boundary events of these types is not possible yet.".formatted(processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenTheMigratedProcessInstanceSubscribedToAnEventSubprocess() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").eventSubProcess("eventSubProcess", sub -> sub.startEvent("eventSubProcessStart", s -> s.message(m -> m.name("message").zeebeCorrelationKeyExpression("\"correlationKey\""))).endEvent()).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).withMessageName("message").withCorrelationKey("correlationKey").await();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason("Expected to migrate process instance but process instance has an event subprocess. Process instances with event subprocesses cannot be migrated yet.").hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenTheTargetProcessDefinitionContainsATaskSubscribedToABoundaryEvent() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("A", t -> t.zeebeJobType("A")).boundaryEvent("boundary").timerWithDuration(Duration.ofDays(1L))).endEvent().moveToActivity("A").endEvent("end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason("Expected to migrate process instance '%s' but target element with id 'A' has one or more boundary events of types 'TIMER'. Migrating target elements with boundary events of these types is not possible yet.".formatted(processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenTheTargetProcessDefinitionSubscribedToAnEventSubprocess() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").eventSubProcess("eventSubProcess", sub -> sub.startEvent("eventSubProcessStart", s -> s.message(m -> m.name("message").zeebeCorrelationKeyExpression("\"correlationKey\""))).endEvent()).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason("Expected to migrate process instance but target process has an event subprocess. Target processes with event subprocesses cannot be migrated yet.").hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenActiveElementSubscribesToTheSameMessageBoundaryEventWithoutMapping() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("A", a -> a.zeebeJobType("A")).boundaryEvent("boundary").message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).endEvent().moveToActivity("A").endEvent().done()).withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("A", t -> t.zeebeJobType("A")).boundaryEvent("boundary").message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).endEvent().moveToActivity("A").endEvent("end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withVariable("key", "key").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason("Expected to migrate process instance '%s' but active element with id 'A' attempts to subscribe to a message it is already subscribed to with name 'message'. Migrating active elements that subscribe to a message they are already subscribed to is not possible yet. Please provide a mapping instruction to message catch event with id 'boundary' to migrate the respective message subscription.".formatted(processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenMessageBoundaryEventsAreMapped() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("A", a -> a.zeebeJobType("A")).boundaryEvent("boundary").message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).endEvent().moveToActivity("A").endEvent().done()).withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("A", t -> t.zeebeJobType("A")).boundaryEvent("boundary").message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).endEvent().moveToActivity("A").endEvent("end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withVariable("key", "key").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").addMappingInstruction("boundary", "boundary").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason("Expected to migrate process instance '%s' but active element with id 'A' is mapped to element with id 'A' that must be subscribed to mapped catch event with id 'boundary'. Migrating active elements with mapped catch events is not possible yet.".formatted(processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenNativeUserTaskIsMappedToUserTask() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("A").zeebeUserTask()).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent().userTask("B").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(String.format("Expected to migrate process instance '%s' but active user task with id 'A' and implementation 'zeebe user task' is mapped to an user task with id 'B' and different implementation 'job worker'. Elements must be mapped to elements of the same implementation.", processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenUserTaskIsMappedToNativeUserTask() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().userTask("A").endEvent().done()).withXmlResource(((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process2").startEvent().userTask("B").zeebeUserTask()).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(String.format("Expected to migrate process instance '%s' but active user task with id 'A' and implementation 'job worker' is mapped to an user task with id 'B' and different implementation 'zeebe user task'. Elements must be mapped to elements of the same implementation.", processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectMigrationWhenSubprocessIsUnmapped() {
        String processId = "process";
        String targetProcessId = "process2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().subProcess("sub1", s -> s.embeddedSubProcess().startEvent().serviceTask("A", t -> t.zeebeJobType("task")).endEvent()).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent().subProcess("sub2", s -> s.embeddedSubProcess().startEvent().serviceTask("B", t -> t.zeebeJobType("task")).endEvent()).endEvent().moveToActivity("sub2").endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(String.format("Expected to migrate process instance '%d' but no mapping instruction defined for active element with id 'sub1'. Elements cannot be migrated without a mapping.", processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectWhenUnableToSubscribeToMessageBoundaryEvent() {
        String processId = "process";
        String targetProcessId = "process2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().userTask("A").endEvent().done()).withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process2").startEvent().userTask("B").boundaryEvent("boundary").message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).endEvent().moveToActivity("B").endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        Record<ProcessInstanceMigrationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").expectRejection().migrate();
        ((RecordAssert)Assertions.assertThat(rejection).describedAs("Expect that the message boundary event could not be subscribed", new Object[0])).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason("Expected to migrate process instance '%s' but active element with id 'A' is mapped to element with id 'B' that must be subscribed to a message catch event. Failed to extract the correlation key for 'key': The value must be either a string or a number, but was 'NULL'. The evaluation reported the following warnings:\n[NO_VARIABLE_FOUND] No variable found with name 'key'".formatted(processInstanceKey));
    }

    private static long extractTargetProcessDefinitionKey(Record<DeploymentRecordValue> deployment, String bpmnProcessId) {
        return ((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().stream().filter(p -> p.getBpmnProcessId().equals(bpmnProcessId)).findAny().orElseThrow().getProcessDefinitionKey();
    }
}

