/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance.migration;

import io.camunda.zeebe.engine.processing.processinstance.migration.MigrationTestUtil;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceMigrationMappingInstruction;
import io.camunda.zeebe.protocol.record.Assertions;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceMigrationIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceMigrationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValueAssert;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class MigrateProcessInstanceTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Test
    public void shouldWriteMigratedEventForProcessInstance() {
        String processId1 = this.helper.getBpmnProcessId();
        String processId2 = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId1).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)processId2).startEvent().serviceTask("B", a -> a.zeebeJobType("B")).endEvent().done()).deploy();
        long otherProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, processId2);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId1).create();
        Record<ProcessInstanceMigrationRecordValue> event = ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(otherProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        Assertions.assertThat(event).hasKey(processInstanceKey).hasRecordType(RecordType.EVENT).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATED);
        Assertions.assertThat((ProcessInstanceMigrationRecordValue)((ProcessInstanceMigrationRecordValue)event.getValue())).hasProcessInstanceKey(processInstanceKey).hasTargetProcessDefinitionKey(otherProcessDefinitionKey).hasMappingInstructions(new ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue[]{new ProcessInstanceMigrationMappingInstruction().setSourceElementId("A").setTargetElementId("B")});
    }

    @Test
    public void shouldWriteElementMigratedEventForProcessInstance() {
        String processId = this.helper.getBpmnProcessId();
        String otherProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)otherProcessId).startEvent().serviceTask("B", a -> a.zeebeJobType("B")).endEvent().done()).deploy();
        long otherProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, otherProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(otherProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        ((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_MIGRATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).getFirst()).getValue())).describedAs("Expect that process definition key changed", new Object[0])).hasProcessDefinitionKey(otherProcessDefinitionKey).describedAs("Expect that bpmn process id and element id changed", new Object[0])).hasBpmnProcessId(otherProcessId).hasElementId(otherProcessId).describedAs("Expect that version number did not change", new Object[0])).hasVersion(1);
    }

    @Test
    public void shouldWriteElementMigratedEventForProcessInstanceToNewVersion() {
        String processId = this.helper.getBpmnProcessId();
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).deploy();
        Record<DeploymentRecordValue> secondVersionDeployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).userTask().endEvent().done()).deploy();
        long v2ProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(secondVersionDeployment, processId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVersion(1).create();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(v2ProcessDefinitionKey).addMappingInstruction("A", "A").migrate();
        ((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)((Record)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).onlyEvents()).withIntent((Intent)ProcessInstanceIntent.ELEMENT_MIGRATED)).getFirst()).getValue())).describedAs("Expect that process definition key changed", new Object[0])).hasProcessDefinitionKey(v2ProcessDefinitionKey).describedAs("Expect that version number changed", new Object[0])).hasVersion(2).describedAs("Expect that bpmn process id and element id did not change", new Object[0])).hasBpmnProcessId(processId).hasElementId(processId);
    }
}

