/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance.migration;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.BusinessRuleTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.InclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceMigrationRecordValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class MigrateProcessInstanceUnsupportedElementsTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String SOURCE_PROCESS = "process_source";
    private static final String TARGET_PROCESS = "process_target";
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Test
    public void shouldRejectMigrationForActiveMessageIntermediateCatchEvent() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)SOURCE_PROCESS).startEvent().intermediateCatchEvent("A", e -> e.message(m -> m.name("msg").zeebeCorrelationKeyExpression("key"))).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)TARGET_PROCESS).startEvent().intermediateCatchEvent("A", e -> e.message(m -> m.name("msg").zeebeCorrelationKeyExpression("key"))).userTask("B").endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrateProcessInstanceUnsupportedElementsTest.extractTargetProcessDefinitionKey(deployment);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(SOURCE_PROCESS).withVariable("key", this.helper.getCorrelationValue()).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        Record<ProcessInstanceMigrationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).hasRejectionType(RejectionType.INVALID_STATE);
        Assertions.assertThat((String)rejection.getRejectionReason()).contains(new CharSequence[]{String.format("Expected to migrate process instance '%s' but active element with id '%s' has an unsupported type. The migration of a %s is not supported", processInstanceKey, "A", "INTERMEDIATE_CATCH_EVENT")});
    }

    @Test
    public void shouldRejectMigrationForActiveReceiveTask() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)SOURCE_PROCESS).startEvent().receiveTask("A", e -> e.message(m -> m.name("msg").zeebeCorrelationKeyExpression("key"))).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)TARGET_PROCESS).startEvent().receiveTask("A", e -> e.message(m -> m.name("msg").zeebeCorrelationKeyExpression("key"))).userTask("B").endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrateProcessInstanceUnsupportedElementsTest.extractTargetProcessDefinitionKey(deployment);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(SOURCE_PROCESS).withVariable("key", this.helper.getCorrelationValue()).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        Record<ProcessInstanceMigrationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).hasRejectionType(RejectionType.INVALID_STATE);
        Assertions.assertThat((String)rejection.getRejectionReason()).contains(new CharSequence[]{String.format("Expected to migrate process instance '%s' but active element with id '%s' has an unsupported type. The migration of a %s is not supported", processInstanceKey, "A", "RECEIVE_TASK")});
    }

    @Test
    public void shouldRejectMigrationForActiveCallActivity() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)SOURCE_PROCESS).startEvent().callActivity("A", c -> c.zeebeProcessId("CHILD_PROCESS")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)TARGET_PROCESS).startEvent().callActivity("A", c -> c.zeebeProcessId("CHILD_PROCESS")).userTask("B").endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"CHILD_PROCESS").startEvent().userTask("C").endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrateProcessInstanceUnsupportedElementsTest.extractTargetProcessDefinitionKey(deployment);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(SOURCE_PROCESS).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withParentProcessInstanceKey(processInstanceKey).withElementId("CHILD_PROCESS").await();
        Record<ProcessInstanceMigrationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).hasRejectionType(RejectionType.INVALID_STATE);
        Assertions.assertThat((String)rejection.getRejectionReason()).contains(new CharSequence[]{String.format("Expected to migrate process instance '%s' but active element with id '%s' has an unsupported type. The migration of a %s is not supported", processInstanceKey, "A", "CALL_ACTIVITY")});
    }

    @Test
    public void shouldRejectMigrationForActiveExclusiveGateway() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)SOURCE_PROCESS).startEvent().exclusiveGateway("A").conditionExpression("missing_function_causing_incident()")).endEvent().moveToLastExclusiveGateway().defaultFlow().endEvent().done()).withXmlResource(((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)TARGET_PROCESS).startEvent().exclusiveGateway("A").conditionExpression("missing_function_causing_incident()")).endEvent().moveToLastExclusiveGateway().defaultFlow().userTask("B").endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrateProcessInstanceUnsupportedElementsTest.extractTargetProcessDefinitionKey(deployment);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(SOURCE_PROCESS).create();
        RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        Record<ProcessInstanceMigrationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).hasRejectionType(RejectionType.INVALID_STATE);
        Assertions.assertThat((String)rejection.getRejectionReason()).contains(new CharSequence[]{String.format("Expected to migrate process instance '%s' but active element with id '%s' has an unsupported type. The migration of a %s is not supported", processInstanceKey, "A", "EXCLUSIVE_GATEWAY")});
    }

    @Test
    public void shouldRejectMigrationForActiveInclusiveGateway() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(((InclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)SOURCE_PROCESS).startEvent().inclusiveGateway("A").conditionExpression("missing_function_causing_incident()")).endEvent().moveToLastInclusiveGateway().defaultFlow().endEvent().done()).withXmlResource(((InclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)TARGET_PROCESS).startEvent().inclusiveGateway("A").conditionExpression("missing_function_causing_incident()")).endEvent().moveToLastInclusiveGateway().defaultFlow().userTask("B").endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrateProcessInstanceUnsupportedElementsTest.extractTargetProcessDefinitionKey(deployment);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(SOURCE_PROCESS).create();
        RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        Record<ProcessInstanceMigrationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).hasRejectionType(RejectionType.INVALID_STATE);
        Assertions.assertThat((String)rejection.getRejectionReason()).contains(new CharSequence[]{String.format("Expected to migrate process instance '%s' but active element with id '%s' has an unsupported type. The migration of a %s is not supported", processInstanceKey, "A", "INCLUSIVE_GATEWAY")});
    }

    @Test
    public void shouldRejectMigrationForActiveEventBasedGateway() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)SOURCE_PROCESS).startEvent().eventBasedGateway("A").intermediateCatchEvent("MSG_1", e -> e.message(m -> m.name("msg_1").zeebeCorrelationKeyExpression("key"))).endEvent().moveToLastGateway().intermediateCatchEvent("MSG_2", e -> e.message(m -> m.name("msg_2").zeebeCorrelationKeyExpression("key"))).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)TARGET_PROCESS).startEvent().eventBasedGateway("A").intermediateCatchEvent("MSG_1", e -> e.message(m -> m.name("msg_1").zeebeCorrelationKeyExpression("key"))).endEvent().moveToLastGateway().intermediateCatchEvent("MSG_2", e -> e.message(m -> m.name("msg_2").zeebeCorrelationKeyExpression("key"))).endEvent().moveToLastGateway().intermediateCatchEvent("MSG_3", e -> e.message(m -> m.name("msg_3").zeebeCorrelationKeyExpression("key"))).endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrateProcessInstanceUnsupportedElementsTest.extractTargetProcessDefinitionKey(deployment);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(SOURCE_PROCESS).withVariable("key", this.helper.getCorrelationValue()).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        Record<ProcessInstanceMigrationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).hasRejectionType(RejectionType.INVALID_STATE);
        Assertions.assertThat((String)rejection.getRejectionReason()).contains(new CharSequence[]{String.format("Expected to migrate process instance '%s' but active element with id '%s' has an unsupported type. The migration of a %s is not supported", processInstanceKey, "A", "EVENT_BASED_GATEWAY")});
    }

    @Test
    public void shouldRejectMigrationForActiveEventBasedSubProcess() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)SOURCE_PROCESS).eventSubProcess("SUB", s -> ((StartEventBuilder)s.startEvent().message(m -> m.name("msg").zeebeCorrelationKeyExpression("key"))).userTask("A").endEvent()).startEvent().userTask("B").endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)TARGET_PROCESS).eventSubProcess("SUB", s -> ((StartEventBuilder)s.startEvent().message(m -> m.name("msg").zeebeCorrelationKeyExpression("key"))).userTask("A").endEvent()).startEvent().userTask("B").userTask("C").endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrateProcessInstanceUnsupportedElementsTest.extractTargetProcessDefinitionKey(deployment);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(SOURCE_PROCESS).withVariable("key", this.helper.getCorrelationValue()).create();
        ENGINE.message().withName("msg").withCorrelationKey(this.helper.getCorrelationValue()).publish();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        Record<ProcessInstanceMigrationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).hasRejectionType(RejectionType.INVALID_STATE);
        Assertions.assertThat((String)rejection.getRejectionReason()).contains(new CharSequence[]{"Expected to migrate process instance but process instance has an event subprocess. Process instances with event subprocesses cannot be migrated yet."});
    }

    @Test
    public void shouldRejectMigrationForActiveMultiInstance() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)SOURCE_PROCESS).startEvent().userTask("A", u -> ((MultiInstanceLoopCharacteristicsBuilder)u.multiInstance().zeebeInputCollectionExpression("[1,2]")).zeebeInputElement("input")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)TARGET_PROCESS).startEvent().userTask("A", u -> ((MultiInstanceLoopCharacteristicsBuilder)u.multiInstance().zeebeInputCollectionExpression("[1,2]")).zeebeInputElement("input")).userTask("B").endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrateProcessInstanceUnsupportedElementsTest.extractTargetProcessDefinitionKey(deployment);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(SOURCE_PROCESS).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        Record<ProcessInstanceMigrationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).hasRejectionType(RejectionType.INVALID_STATE);
        Assertions.assertThat((String)rejection.getRejectionReason()).contains(new CharSequence[]{String.format("Expected to migrate process instance '%s' but active element with id '%s' has an unsupported type. The migration of a %s is not supported", processInstanceKey, "A", "MULTI_INSTANCE_BODY")});
    }

    @Test
    public void shouldRejectMigrationForActiveBusinessRuleTask() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)SOURCE_PROCESS).startEvent().businessRuleTask("A", b -> ((BusinessRuleTaskBuilder)b.zeebeCalledDecisionId("decision")).zeebeResultVariable("result")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)TARGET_PROCESS).startEvent().businessRuleTask("A", b -> ((BusinessRuleTaskBuilder)b.zeebeCalledDecisionId("decision")).zeebeResultVariable("result")).userTask("B").endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrateProcessInstanceUnsupportedElementsTest.extractTargetProcessDefinitionKey(deployment);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(SOURCE_PROCESS).create();
        RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        Record<ProcessInstanceMigrationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).hasRejectionType(RejectionType.INVALID_STATE);
        Assertions.assertThat((String)rejection.getRejectionReason()).contains(new CharSequence[]{String.format("Expected to migrate process instance '%s' but active element with id '%s' has an unsupported type. The migration of a %s is not supported", processInstanceKey, "A", "BUSINESS_RULE_TASK")});
    }

    private static long extractTargetProcessDefinitionKey(Record<DeploymentRecordValue> deployment) {
        return ((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().stream().filter(p -> p.getBpmnProcessId().equals(TARGET_PROCESS)).findAny().orElseThrow().getProcessDefinitionKey();
    }
}

