/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance.migration;

import io.camunda.zeebe.engine.processing.processinstance.migration.MigrationTestUtil;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValueAssert;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValueAssert;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class MigrateServiceTaskTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Test
    public void shouldWriteElementMigratedEventForServiceTask() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).userTask().endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").migrate();
        ((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_MIGRATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).hasVersion(1).describedAs("Expect that element id is left unchanged", new Object[0])).hasElementId("A");
    }

    @Test
    public void shouldWriteElementMigratedEventForServiceTaskWithNewId() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("B", a -> a.zeebeJobType("B")).endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        ((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_MIGRATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).hasVersion(1).describedAs("Expect that element id changed due to mapping", new Object[0])).hasElementId("B");
    }

    @Test
    public void shouldWriteMigratedEventForJob() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("B", a -> a.zeebeJobType("B")).endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        ((JobRecordValueAssert)((JobRecordValueAssert)((JobRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)((Record)RecordingExporter.jobRecords((JobIntent)JobIntent.MIGRATED).withProcessInstanceKey(processInstanceKey).getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).hasProcessDefinitionVersion(1).describedAs("Expect that element id changed due to mapping", new Object[0])).hasElementId("B").describedAs("Expect that the type did not change even though it's different in the target process. Re-evaluation of the job type expression is not enabled for this migration", new Object[0])).hasType("A");
    }

    @Test
    public void shouldContinueFlowInTargetProcessForMigratedJob() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent("source_process_end").done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("B", a -> a.zeebeJobType("B")).endEvent("target_process_end").done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        ENGINE.job().ofInstance(processInstanceKey).withType("A").yield();
        ENGINE.job().ofInstance(processInstanceKey).withType("A").withRetries(2).fail();
        ENGINE.job().ofInstance(processInstanceKey).withType("A").withRetries(3).updateRetries();
        ENGINE.job().ofInstance(processInstanceKey).withType("A").withErrorCode("A1").throwError();
        ENGINE.incident().ofInstance(processInstanceKey).resolve();
        ENGINE.job().ofInstance(processInstanceKey).withType("A").complete();
        ((OptionalAssert)Assertions.assertThat((Optional)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.END_EVENT).withElementId("target_process_end").findAny()).describedAs("Expect that the process instance is continued in the target process", new Object[0])).isPresent();
    }
}

