/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance.migration;

import io.camunda.zeebe.engine.processing.processinstance.migration.MigrationTestUtil;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValueAssert;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class MigrateSubprocessTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Test
    public void shouldMigrateSubprocess() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent("start").subProcess("sub1", s -> s.embeddedSubProcess().startEvent().serviceTask("A", t -> t.zeebeJobType("task")).endEvent()).endEvent("end").done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent("start").subProcess("sub2", s -> s.embeddedSubProcess().startEvent().serviceTask("B", t -> t.zeebeJobType("task")).endEvent()).endEvent("end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").addMappingInstruction("sub1", "sub2").migrate();
        ((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_MIGRATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SUB_PROCESS).getFirst()).getValue())).describedAs("Expect that process definition key is changed", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).describedAs("Expect that bpmn process id and element id changed", new Object[0])).hasBpmnProcessId(targetProcessId).hasElementId("sub2").describedAs("Expect that version number did not change", new Object[0])).hasVersion(1);
    }

    @Test
    public void shouldMigrateNestedSubprocess() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent("start").subProcess("sub1", s -> s.embeddedSubProcess().startEvent().subProcess("subsub1", ss -> ss.embeddedSubProcess().startEvent().serviceTask("A", t -> t.zeebeJobType("task")).endEvent()).endEvent()).endEvent("end").done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent("start").subProcess("sub2", s -> s.embeddedSubProcess().startEvent().subProcess("subsub2", ss -> ss.embeddedSubProcess().startEvent().serviceTask("B", t -> t.zeebeJobType("task")).endEvent()).endEvent()).endEvent("end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").addMappingInstruction("sub1", "sub2").addMappingInstruction("subsub1", "subsub2").migrate();
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_MIGRATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SUB_PROCESS).limit(2L)).hasSize(2)).extracting(Record::getValue).extracting(new Function[]{ProcessInstanceRecordValue::getElementId, ProcessInstanceRecordValue::getProcessDefinitionKey, ProcessInstanceRecordValue::getBpmnProcessId, ProcessInstanceRecordValue::getVersion}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"sub2", targetProcessDefinitionKey, targetProcessId, 1}), Assertions.tuple((Object[])new Object[]{"subsub2", targetProcessDefinitionKey, targetProcessId, 1})});
    }
}

