/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance.migration;

import io.camunda.zeebe.engine.processing.processinstance.migration.MigrationTestUtil;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.UserTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValueAssert;
import io.camunda.zeebe.protocol.record.value.UserTaskRecordValue;
import io.camunda.zeebe.protocol.record.value.UserTaskRecordValueAssert;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class MigrateUserTaskTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Test
    public void shouldWriteElementMigratedEventForUserTaskWithJobWorkerImplementation() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().userTask("A").endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().userTask("B").userTask().endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.USER_TASK).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        ((ProcessInstanceRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_MIGRATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.USER_TASK).getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).hasVersion(1).hasElementId("B");
    }

    @Test
    public void shouldWriteElementMigratedEventForUserTaskWithNativeUserTaskImplementation() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().userTask("A", u -> u.zeebeUserTask()).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().userTask("B", u -> u.zeebeUserTask()).endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        ((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_MIGRATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.USER_TASK).getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).hasVersion(1).describedAs("Expect that element id is left unchanged", new Object[0])).hasElementId("B");
    }

    @Test
    public void shouldWriteMigratedEventForUserTask() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withJsonClasspathResource("/form/test-form-1.form").withJsonClasspathResource("/form/test-form-2.form").withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().userTask("A", u -> ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)u.zeebeUserTask()).zeebeAssigneeExpression("user")).zeebeCandidateUsersExpression("candidates")).zeebeCandidateGroupsExpression("candidates")).zeebeDueDateExpression("now() + duration(due)")).zeebeFollowUpDateExpression("now() + duration(followup)")).zeebeFormId("Form_0w7r08e")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().userTask("B", u -> ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)u.zeebeUserTask()).zeebeAssigneeExpression("user2")).zeebeCandidateUsersExpression("candidates2")).zeebeCandidateGroupsExpression("candidates2")).zeebeDueDateExpression("now() + duration(due2)")).zeebeFollowUpDateExpression("now() + duration(followup2)")).zeebeFormId("Form_6s1b76p")).endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariables(Map.ofEntries(Map.entry("user", "user"), Map.entry("user2", "user2"), Map.entry("candidates", List.of("candidates")), Map.entry("candidates2", List.of("candidates2")), Map.entry("due", "PT2H"), Map.entry("due2", "PT20H"), Map.entry("followup", "PT1H"), Map.entry("followup2", "PT10H"))).create();
        UserTaskRecordValue userTask = (UserTaskRecordValue)((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getValue();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        ((UserTaskRecordValueAssert)((UserTaskRecordValueAssert)((UserTaskRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.MIGRATED).withProcessInstanceKey(processInstanceKey).getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).hasProcessDefinitionVersion(1).describedAs("Expect that element id changed due to mapping", new Object[0])).hasElementId("B").describedAs("Expect that the user task properties did not change even though they're different in the target process. Re-evaluation of these expression is not enabled for this migration", new Object[0])).hasAssignee(userTask.getAssignee()).hasCandidateGroupsList((Collection)userTask.getCandidateGroupsList()).hasCandidateUsersList((Collection)userTask.getCandidateUsersList()).hasDueDate(userTask.getDueDate()).hasFollowUpDate(userTask.getFollowUpDate()).hasFormKey(userTask.getFormKey());
    }

    @Test
    public void shouldWriteMigratedEventForUserTaskWithoutVariables() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().userTask("A", u -> ((UserTaskBuilder)u.zeebeUserTask()).zeebeInputExpression("taskVariable", "taskVariable")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().userTask("B", u -> ((UserTaskBuilder)u.zeebeUserTask()).zeebeInputExpression("taskVariable2", "taskVariable2")).endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariables(Map.ofEntries(Map.entry("taskVariable", "taskVariable"), Map.entry("taskVariable2", "taskVariable2"))).create();
        RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        ((UserTaskRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.MIGRATED).withProcessInstanceKey(processInstanceKey).getFirst()).getValue())).describedAs("Expect that the variables are unset to avoid exceeding the max record size", new Object[0])).hasVariables(Map.of());
    }

    @Test
    public void shouldContinueFlowInTargetProcessForMigratedUserTask() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withJsonClasspathResource("/form/test-form-1.form").withJsonClasspathResource("/form/test-form-2.form").withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().userTask("A", u -> ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)u.zeebeUserTask()).zeebeAssigneeExpression("user")).zeebeCandidateUsersExpression("candidates")).zeebeCandidateGroupsExpression("candidates")).zeebeDueDateExpression("now() + duration(due)")).zeebeFollowUpDateExpression("now() + duration(followup)")).zeebeFormId("Form_0w7r08e")).endEvent("source_process_end").done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().userTask("B", u -> ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)u.zeebeUserTask()).zeebeAssigneeExpression("user2")).zeebeCandidateUsersExpression("candidates2")).zeebeCandidateGroupsExpression("candidates2")).zeebeDueDateExpression("now() + duration(due2)")).zeebeFollowUpDateExpression("now() + duration(followup2)")).zeebeFormId("Form_6s1b76p")).endEvent("target_process_end").done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariables(Map.ofEntries(Map.entry("user", "user"), Map.entry("user2", "user2"), Map.entry("candidates", List.of("candidates")), Map.entry("candidates2", List.of("candidates2")), Map.entry("due", "PT2H"), Map.entry("due2", "PT20H"), Map.entry("followup", "PT1H"), Map.entry("followup2", "PT10H"))).create();
        long userTaskKey = ((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getKey();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        ENGINE.userTask().ofInstance(processInstanceKey).withKey(userTaskKey).withoutAssignee().assign();
        ENGINE.userTask().ofInstance(processInstanceKey).withKey(userTaskKey).withAssignee("user2").assign();
        ENGINE.userTask().ofInstance(processInstanceKey).withKey(userTaskKey).withAssignee("user3").claim();
        ENGINE.userTask().ofInstance(processInstanceKey).withKey(userTaskKey).complete();
        ((OptionalAssert)Assertions.assertThat((Optional)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.END_EVENT).withElementId("target_process_end").findAny()).describedAs("Expect that the process instance is continued in the target process", new Object[0])).isPresent();
    }
}

