/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance.migration;

import io.camunda.zeebe.engine.processing.processinstance.migration.MigrationTestUtil;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.record.Assertions;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValueAssert;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class MigrateVariablesTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Test
    public void shouldWriteMigratedEventForGlobalVariable() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariables(Map.of("variable_to_migrate", "This is just a string", "another_variable_to_migrate", Map.of("this", "is", "a", "context"))).create();
        VariableRecordValue variable = (VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName("variable_to_migrate").getFirst()).getValue();
        VariableRecordValue variable2 = (VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName("another_variable_to_migrate").getFirst()).getValue();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").migrate();
        ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)Assertions.assertThat((VariableRecordValue)((VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.MIGRATED).withProcessInstanceKey(processInstanceKey).withName("variable_to_migrate").getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).describedAs("Expect that the value is unset to avoid exceeding the max record size", new Object[0])).hasValue("null").describedAs("Expect that the other variable data did not change", new Object[0])).hasName(variable.getName()).hasProcessInstanceKey(variable.getProcessInstanceKey()).hasScopeKey(variable.getScopeKey()).hasTenantId(variable.getTenantId());
        ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)Assertions.assertThat((VariableRecordValue)((VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.MIGRATED).withProcessInstanceKey(processInstanceKey).withName("another_variable_to_migrate").getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).describedAs("Expect that the value is unset to avoid exceeding the max record size", new Object[0])).hasValue("null").describedAs("Expect that the other variable data did not change", new Object[0])).hasName(variable2.getName()).hasProcessInstanceKey(variable2.getProcessInstanceKey()).hasScopeKey(variable2.getScopeKey()).hasTenantId(variable2.getTenantId());
    }

    @Test
    public void shouldWriteMigratedEventForLocalVariable() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> ((ServiceTaskBuilder)((ServiceTaskBuilder)a.zeebeJobType("A")).zeebeInputExpression("\"This is just a string\"", "variable_to_migrate")).zeebeInputExpression("{\"this\": \"is\", \"a\": \"context\"}", "another_variable_to_migrate")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrationTestUtil.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        VariableRecordValue variable = (VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName("variable_to_migrate").getFirst()).getValue();
        VariableRecordValue variable2 = (VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName("another_variable_to_migrate").getFirst()).getValue();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").migrate();
        ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)Assertions.assertThat((VariableRecordValue)((VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.MIGRATED).withProcessInstanceKey(processInstanceKey).withName("variable_to_migrate").getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).describedAs("Expect that the value is unset to avoid exceeding the max record size", new Object[0])).hasValue("null").describedAs("Expect that the other variable data did not change", new Object[0])).hasName(variable.getName()).hasProcessInstanceKey(variable.getProcessInstanceKey()).hasScopeKey(variable.getScopeKey()).hasTenantId(variable.getTenantId());
        ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)Assertions.assertThat((VariableRecordValue)((VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.MIGRATED).withProcessInstanceKey(processInstanceKey).withName("another_variable_to_migrate").getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).describedAs("Expect that the value is unset to avoid exceeding the max record size", new Object[0])).hasValue("null").describedAs("Expect that the other variable data did not change", new Object[0])).hasName(variable2.getName()).hasProcessInstanceKey(variable2.getProcessInstanceKey()).hasScopeKey(variable2.getScopeKey()).hasTenantId(variable2.getTenantId());
    }
}

