/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.signal;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.client.SignalClient;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.protocol.record.ExecuteCommandResponseDecoder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.SignalSubscriptionIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.time.Duration;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class SignalCatchEventTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "wf";
    private static final String ELEMENT_ID = "catch";
    private static final String SIGNAL_NAME = "signal";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private final SignalClient signalClient = ENGINE.signal().withSignalName("signal");

    @Test
    public void shouldTriggerIntermediateCatchEvent() {
        BpmnModelInstance process = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().intermediateCatchEvent(ELEMENT_ID).signal(SIGNAL_NAME)).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((boolean)RecordingExporter.signalSubscriptionRecords((SignalSubscriptionIntent)SignalSubscriptionIntent.CREATED).withSignalName(SIGNAL_NAME).exists()).isTrue();
        this.signalClient.broadcast();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ELEMENT_ID, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{ELEMENT_ID, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldTriggerInterruptingBoundaryEvent() {
        BpmnModelInstance process = ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("task", b -> b.zeebeJobType("type")).boundaryEvent(ELEMENT_ID).signal(SIGNAL_NAME)).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((boolean)RecordingExporter.signalSubscriptionRecords((SignalSubscriptionIntent)SignalSubscriptionIntent.CREATED).withSignalName(SIGNAL_NAME).exists()).isTrue();
        this.signalClient.broadcast();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"task", ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{"task", ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{ELEMENT_ID, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{ELEMENT_ID, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldTriggerNonInterruptingBoundaryEvent() {
        BpmnModelInstance process = ((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("task", b -> b.zeebeJobType("type")).boundaryEvent(ELEMENT_ID).signal(SIGNAL_NAME)).cancelActivity(Boolean.valueOf(false))).endEvent("end").done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((boolean)RecordingExporter.signalSubscriptionRecords((SignalSubscriptionIntent)SignalSubscriptionIntent.CREATED).withSignalName(SIGNAL_NAME).exists()).isTrue();
        this.signalClient.broadcast();
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType("type").activate();
        ENGINE.job().withKey((Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0)).complete();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"task", ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{"task", ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{ELEMENT_ID, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{ELEMENT_ID, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"end", ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{"end", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"task", ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{"task", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCloseSignalSubscription() {
        BpmnModelInstance process = ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("task", b -> b.zeebeJobType("type")).boundaryEvent(ELEMENT_ID).signal(SIGNAL_NAME)).endEvent("end").done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((boolean)RecordingExporter.signalSubscriptionRecords((SignalSubscriptionIntent)SignalSubscriptionIntent.CREATED).withSignalName(SIGNAL_NAME).exists()).isTrue();
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType("type").activate();
        ENGINE.job().withKey((Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0)).complete();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"task", ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{"task", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        Assertions.assertThat((boolean)RecordingExporter.signalSubscriptionRecords((SignalSubscriptionIntent)SignalSubscriptionIntent.DELETED).withSignalName(SIGNAL_NAME).exists()).isTrue();
    }

    @Test
    public void shouldTriggerSignalCatchEventAttachedToEventBasedGateway() {
        BpmnModelInstance process = ((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().eventBasedGateway("event_based_gateway").intermediateCatchEvent(ELEMENT_ID).signal(SIGNAL_NAME)).endEvent().moveToLastGateway().intermediateCatchEvent().timerWithDuration(Duration.ofMinutes(10L))).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((boolean)RecordingExporter.signalSubscriptionRecords((SignalSubscriptionIntent)SignalSubscriptionIntent.CREATED).withSignalName(SIGNAL_NAME).exists()).isTrue();
        this.signalClient.broadcast();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ELEMENT_ID, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{ELEMENT_ID, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{PROCESS_ID, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldRejectDeploymentSignalCatchEventWithSameSignalNameAttachedToEventBasedGateway() {
        BpmnModelInstance process = ((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().eventBasedGateway("event_based_gateway").intermediateCatchEvent(ELEMENT_ID).signal(SIGNAL_NAME)).endEvent().moveToLastGateway().intermediateCatchEvent().signal(SIGNAL_NAME)).endEvent().moveToLastGateway().intermediateCatchEvent().timerWithDuration(Duration.ofMinutes(10L))).endEvent().done();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(process).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"Element: event_based_gateway"})).contains(new CharSequence[]{"ERROR: Multiple signal event definitions with the same name 'signal' are not allowed."});
    }
}

