/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.usertask;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.UserTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;
import io.camunda.zeebe.protocol.record.value.UserTaskRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class AssignUserTaskTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    private static BpmnModelInstance process() {
        return AssignUserTaskTest.process(b -> {});
    }

    private static BpmnModelInstance process(Consumer<UserTaskBuilder> consumer) {
        UserTaskBuilder builder = (UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("task").zeebeUserTask();
        consumer.accept(builder);
        return builder.endEvent().done();
    }

    @Test
    public void shouldEmitAssigningEventForUserTask() {
        ENGINE.deployment().withXmlResource(AssignUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long userTaskKey = ((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getKey();
        Record<UserTaskRecordValue> assignedRecord = ENGINE.userTask().withKey(userTaskKey).withAssignee("foo").assign();
        UserTaskRecordValue recordValue = (UserTaskRecordValue)assignedRecord.getValue();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(assignedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.ASSIGNING);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)recordValue).hasUserTaskKey(userTaskKey).hasAction("assign").hasTenantId("<default>");
    }

    @Test
    public void shouldTrackCustomActionInAssigningEvent() {
        ENGINE.deployment().withXmlResource(AssignUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long userTaskKey = ((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getKey();
        Record<UserTaskRecordValue> assignedRecord = ENGINE.userTask().withKey(userTaskKey).withAction("customAction").withAssignee("foo").assign();
        UserTaskRecordValue recordValue = (UserTaskRecordValue)assignedRecord.getValue();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(assignedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.ASSIGNING);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)recordValue).hasUserTaskKey(userTaskKey).hasAction("customAction").hasTenantId("<default>");
    }

    @Test
    public void shouldRejectAssignIfUserTaskNotFound() {
        int key = 123;
        Record<UserTaskRecordValue> assignedRecord = ENGINE.userTask().withKey(123L).withAssignee("foo").expectRejection().assign();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(assignedRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldAssignUserTaskWithAssignee() {
        ENGINE.deployment().withXmlResource(AssignUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<UserTaskRecordValue> assignedRecord = ENGINE.userTask().ofInstance(processInstanceKey).withAssignee("foo").assign();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(assignedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.ASSIGNING);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)assignedRecord.getValue())).hasAssignee("foo");
    }

    @Test
    public void shouldUnassignUserTaskWithNoAssignee() {
        ENGINE.deployment().withXmlResource(AssignUserTaskTest.process(b -> b.zeebeAssignee("foo"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<UserTaskRecordValue> assignedRecord = ENGINE.userTask().ofInstance(processInstanceKey).withoutAssignee().assign();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(assignedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.ASSIGNING);
        Assertions.assertThat((String)((UserTaskRecordValue)assignedRecord.getValue()).getAssignee()).isEmpty();
    }

    @Test
    public void shouldRejectAssignIfUserTaskIsCompleted() {
        ENGINE.deployment().withXmlResource(AssignUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.userTask().ofInstance(processInstanceKey).complete();
        Record<UserTaskRecordValue> assignedRecord = ENGINE.userTask().ofInstance(processInstanceKey).expectRejection().assign();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(assignedRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldAssignUserTaskForCustomTenant() {
        String tenantId = "acme";
        ENGINE.deployment().withXmlResource(AssignUserTaskTest.process()).withTenantId("acme").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("acme").create();
        Record<UserTaskRecordValue> assignedRecord = ENGINE.userTask().ofInstance(processInstanceKey).withAuthorizedTenantIds("acme").withAssignee("foo").assign();
        UserTaskRecordValue recordValue = (UserTaskRecordValue)assignedRecord.getValue();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(assignedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.ASSIGNING);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((UserTaskRecordValue)recordValue).hasTenantId("acme");
    }

    @Test
    public void shouldRejectAssignIfTenantIsUnauthorized() {
        String tenantId = "acme";
        String falseTenantId = "foo";
        ENGINE.deployment().withXmlResource(AssignUserTaskTest.process()).withTenantId("acme").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("acme").create();
        Record<UserTaskRecordValue> assignedRecord = ENGINE.userTask().ofInstance(processInstanceKey).withAuthorizedTenantIds("foo").expectRejection().assign();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(assignedRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }
}

