/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.usertask;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.UserTaskBuilder;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.record.Assertions;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;
import io.camunda.zeebe.protocol.record.value.UserTaskRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.List;
import java.util.function.Consumer;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class UpdateUserTaskTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    private static BpmnModelInstance process() {
        return UpdateUserTaskTest.process(b -> {});
    }

    private static BpmnModelInstance process(Consumer<UserTaskBuilder> consumer) {
        UserTaskBuilder builder = (UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("task").zeebeUserTask();
        consumer.accept(builder);
        return builder.endEvent().done();
    }

    @Test
    public void shouldEmitUpdatingEventForUserTask() {
        ENGINE.deployment().withXmlResource(UpdateUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long userTaskKey = ((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getKey();
        Record<UserTaskRecordValue> updateRecord = ENGINE.userTask().withKey(userTaskKey).update(new UserTaskRecord());
        Assertions.assertThat(updateRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.UPDATING);
        Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)updateRecord.getValue())).hasUserTaskKey(userTaskKey).hasAction("update").hasTenantId("<default>");
    }

    @Test
    public void shouldTrackCustomActionInUpdatingEvent() {
        ENGINE.deployment().withXmlResource(UpdateUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long userTaskKey = ((Record)RecordingExporter.userTaskRecords((UserTaskIntent)UserTaskIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getKey();
        Record<UserTaskRecordValue> updateRecord = ENGINE.userTask().withKey(userTaskKey).withAction("customAction").update(new UserTaskRecord());
        Assertions.assertThat(updateRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.UPDATING);
        Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)updateRecord.getValue())).hasUserTaskKey(userTaskKey).hasAction("customAction").hasTenantId("<default>");
    }

    @Test
    public void shouldRejectUpdateIfUserTaskNotFound() {
        int key = 123;
        Record<UserTaskRecordValue> updateRecord = ENGINE.userTask().withKey(123L).expectRejection().update(new UserTaskRecord());
        Assertions.assertThat(updateRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldUpdateUserTaskCandidateGroupsOnlyWithSingleAttribute() {
        ENGINE.deployment().withXmlResource(UpdateUserTaskTest.process(t -> ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)t.zeebeCandidateGroups("foo, bar")).zeebeCandidateUsers("oof, rab")).zeebeDueDate("2023-03-02T15:35+02:00")).zeebeFollowUpDate("2023-03-02T16:35+02:00"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<UserTaskRecordValue> updateRecord = ENGINE.userTask().ofInstance(processInstanceKey).update(List.of("baz", "foobar"), null, null, null);
        Assertions.assertThat(updateRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.UPDATING);
        Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)updateRecord.getValue())).hasCandidateGroupsList(new String[]{"baz", "foobar"}).hasCandidateUsersList(new String[]{"oof", "rab"}).hasDueDate("2023-03-02T15:35+02:00").hasFollowUpDate("2023-03-02T16:35+02:00");
    }

    @Test
    public void shouldUpdateUserTaskCandidateUsersOnlyWithSingleAttribute() {
        ENGINE.deployment().withXmlResource(UpdateUserTaskTest.process(t -> ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)t.zeebeCandidateGroups("foo, bar")).zeebeCandidateUsers("oof, rab")).zeebeDueDate("2023-03-02T15:35+02:00")).zeebeFollowUpDate("2023-03-02T16:35+02:00"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<UserTaskRecordValue> updateRecord = ENGINE.userTask().ofInstance(processInstanceKey).update(null, List.of("baz", "foobar"), null, null);
        Assertions.assertThat(updateRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.UPDATING);
        Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)updateRecord.getValue())).hasCandidateGroupsList(new String[]{"foo", "bar"}).hasCandidateUsersList(new String[]{"baz", "foobar"}).hasDueDate("2023-03-02T15:35+02:00").hasFollowUpDate("2023-03-02T16:35+02:00");
    }

    @Test
    public void shouldUpdateUserTaskDueDateOnlyWithSingleAttribute() {
        ENGINE.deployment().withXmlResource(UpdateUserTaskTest.process(t -> ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)t.zeebeCandidateGroups("foo, bar")).zeebeCandidateUsers("oof, rab")).zeebeDueDate("2023-03-02T15:35+02:00")).zeebeFollowUpDate("2023-03-02T16:35+02:00"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<UserTaskRecordValue> updateRecord = ENGINE.userTask().ofInstance(processInstanceKey).update(null, null, "abc", null);
        Assertions.assertThat(updateRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.UPDATING);
        Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)updateRecord.getValue())).hasCandidateGroupsList(new String[]{"foo", "bar"}).hasCandidateUsersList(new String[]{"oof", "rab"}).hasDueDate("abc").hasFollowUpDate("2023-03-02T16:35+02:00");
    }

    @Test
    public void shouldUpdateUserTaskFollowUpDateOnlyWithSingleAttribute() {
        ENGINE.deployment().withXmlResource(UpdateUserTaskTest.process(t -> ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)t.zeebeCandidateGroups("foo, bar")).zeebeCandidateUsers("oof, rab")).zeebeDueDate("2023-03-02T15:35+02:00")).zeebeFollowUpDate("2023-03-02T16:35+02:00"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<UserTaskRecordValue> updateRecord = ENGINE.userTask().ofInstance(processInstanceKey).update(null, null, null, "abc");
        Assertions.assertThat(updateRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.UPDATING);
        Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)updateRecord.getValue())).hasCandidateGroupsList(new String[]{"foo", "bar"}).hasCandidateUsersList(new String[]{"oof", "rab"}).hasDueDate("2023-03-02T15:35+02:00").hasFollowUpDate("abc");
    }

    @Test
    public void shouldUpdateAllEligibleUserTaskAttributesWithRecord() {
        ENGINE.deployment().withXmlResource(UpdateUserTaskTest.process(t -> ((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)t.zeebeCandidateGroups("foo, bar")).zeebeCandidateUsers("oof, rab")).zeebeFollowUpDate("2023-03-02T15:35+02:00")).zeebeDueDate("2023-03-02T16:35+02:00"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<UserTaskRecordValue> updateRecord = ENGINE.userTask().ofInstance(processInstanceKey).update(new UserTaskRecord());
        Assertions.assertThat(updateRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.UPDATING);
        Assertions.assertThat((UserTaskRecordValue)((UserTaskRecordValue)updateRecord.getValue())).hasNoCandidateUsersList().hasNoCandidateUsersList().hasDueDate("").hasFollowUpDate("");
    }

    @Test
    public void shouldRejectUpdateIfUserTaskIsCompleted() {
        ENGINE.deployment().withXmlResource(UpdateUserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.userTask().ofInstance(processInstanceKey).complete();
        Record<UserTaskRecordValue> updateRecord = ENGINE.userTask().ofInstance(processInstanceKey).expectRejection().update(new UserTaskRecord());
        Assertions.assertThat(updateRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldUpdateUserTaskForCustomTenant() {
        String tenantId = "acme";
        ENGINE.deployment().withXmlResource(UpdateUserTaskTest.process()).withTenantId("acme").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("acme").create();
        Record<UserTaskRecordValue> updateRecord = ENGINE.userTask().ofInstance(processInstanceKey).withAuthorizedTenantIds("acme").update(new UserTaskRecord());
        UserTaskRecordValue recordValue = (UserTaskRecordValue)updateRecord.getValue();
        Assertions.assertThat(updateRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)UserTaskIntent.UPDATING);
        Assertions.assertThat((UserTaskRecordValue)recordValue).hasTenantId("acme");
    }

    @Test
    public void shouldRejectUpdateIfTenantIsUnauthorized() {
        String tenantId = "acme";
        String falseTenantId = "foo";
        ENGINE.deployment().withXmlResource(UpdateUserTaskTest.process()).withTenantId("acme").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("acme").create();
        Record<UserTaskRecordValue> updateRecord = ENGINE.userTask().ofInstance(processInstanceKey).withAuthorizedTenantIds("foo").expectRejection().update(new UserTaskRecord());
        Assertions.assertThat(updateRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }
}

