/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.variable;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class ProcessInstanceVariableTypeTest {
    @ClassRule
    public static final EngineRule ENGINE_RULE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final BpmnModelInstance PROCESS = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Parameterized.Parameter(value=0)
    public String variables;
    @Parameterized.Parameter(value=1)
    public String expectedValue;

    @Parameterized.Parameters(name="with variables: {0}")
    public static Object[][] parameters() {
        return new Object[][]{{"{'x':'foo'}", "\"foo\""}, {"{'x':123}", "123"}, {"{'x':true}", "true"}, {"{'x':false}", "false"}, {"{'x':null}", "null"}, {"{'x':[1,2,3]}", "[1,2,3]"}, {"{'x':{'y':123}}", "{\"y\":123}"}, {"{'x':{'_y':123}}", "{\"_y\":123}"}};
    }

    @BeforeClass
    public static void deployProcess() {
        ENGINE_RULE.deployment().withXmlResource(PROCESS).deploy();
    }

    @Test
    public void shouldWriteVariableCreatedEvent() {
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(this.variables).create();
        Record variableRecord = (Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        VariableRecordValue value = (VariableRecordValue)variableRecord.getValue();
        Assertions.assertThat((long)value.getScopeKey()).isEqualTo(processInstanceKey);
        Assertions.assertThat((String)value.getName()).isEqualTo("x");
        Assertions.assertThat((String)value.getValue()).isEqualTo(this.expectedValue);
    }
}

