/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.variable.mapping;

import io.camunda.zeebe.engine.processing.variable.mapping.VariableValue;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.EndEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeVariablesMappingBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.test.util.record.VariableRecordStream;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class NoneEndEventOutputMappingTest {
    @ClassRule
    public static final EngineRule ENGINE_RULE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final String A_TIME_VALUE = "\"04:20:00@Europe/Berlin\"";
    private static final String A_LOCAL_TIME_VALUE = "\"04:20\"";
    private static final String A_DATE_VALUE = "\"2021-02-24\"";
    private static final String A_LOCAL_DATE_AND_TIME_VALUE = "\"2021-02-24T04:20\"";
    private static final String A_DATE_AND_TIME_VALUE = "\"2021-02-24T04:20+01:00\"";
    private static final String A_DAY_TIME_DURATION_VALUE = "\"PT42H56M33S\"";
    private static final String A_YEAR_MONTH_DURATION_VALUE = "\"P2Y3M\"";
    private static final String A_STRING = "\"foobar\"";
    private static final String A_SUB_STRING = "\"bar\"";
    private static final String A_UPPER_STRING = "\"FOOBAR\"";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Parameterized.Parameter(value=0)
    public String initialVariables;
    @Parameterized.Parameter(value=1)
    public Consumer<EndEventBuilder> mappings;
    @Parameterized.Parameter(value=2)
    public List<VariableValue> expectedScopeVariables;

    @Parameterized.Parameters(name="from {0} to {2}")
    public static Object[][] parameters() {
        return new Object[][]{{"{'x': 1}", NoneEndEventOutputMappingTest.mapping(b -> b.zeebeOutputExpression("x", "y")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("y", "1"))}, {"{'_x': 1}", NoneEndEventOutputMappingTest.mapping(b -> b.zeebeOutputExpression("_x", "_y")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("_y", "1"))}, {"{'x': 1}", NoneEndEventOutputMappingTest.mapping(b -> b.zeebeOutputExpression("decimal(x / 3, 2)", "y")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("y", "0.33"))}, {"{'x': 1, 'y': 2}", NoneEndEventOutputMappingTest.mapping(b -> b.zeebeOutputExpression("y", "z")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("z", "2"))}, {"{'x': 1}", NoneEndEventOutputMappingTest.mapping(b -> ((EndEventBuilder)b.zeebeInputExpression("x", "y")).zeebeOutputExpression("x", "z")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("z", "1"))}, {"{'x': {'y': 2}}", NoneEndEventOutputMappingTest.mapping(b -> b.zeebeOutputExpression("x", "z")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("z", "{\"y\":2}"))}, {"{'x': {'y': 2}}", NoneEndEventOutputMappingTest.mapping(b -> b.zeebeOutputExpression("x.y", "z")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("z", "2"))}, {"{'z': {'x': 1}, 'y': 2}", NoneEndEventOutputMappingTest.mapping(b -> b.zeebeOutputExpression("y", "z.y")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("z", "{\"x\":1,\"y\":2}"))}, {"{'x': 1, 'y': 2}", NoneEndEventOutputMappingTest.mapping(b -> ((EndEventBuilder)b.zeebeOutputExpression("x", "z.x")).zeebeOutputExpression("y", "z.y")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("z", "{\"x\":1,\"y\":2}"))}, {"{'x': %s}".formatted(A_STRING), NoneEndEventOutputMappingTest.mapping(b -> b.zeebeOutputExpression("contains(x, \"of\")", "y")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("y", "false"))}, {"{'x': %s}".formatted(A_STRING), NoneEndEventOutputMappingTest.mapping(b -> b.zeebeOutputExpression("starts with(x, \"fo\")", "y")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("y", "true"))}, {"{'x': %s}".formatted(A_STRING), NoneEndEventOutputMappingTest.mapping(b -> b.zeebeOutputExpression("substring(x, 4)", "y")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("y", A_SUB_STRING))}, {"{'x': %s}".formatted(A_STRING), NoneEndEventOutputMappingTest.mapping(b -> b.zeebeOutputExpression("upper case(x)", "y")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("y", A_UPPER_STRING))}, {"{'x': %s}".formatted(A_TIME_VALUE), NoneEndEventOutputMappingTest.mapping(b -> b.zeebeOutputExpression("time(x)", "y")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("y", A_TIME_VALUE))}, {"{'x': %s}".formatted(A_LOCAL_TIME_VALUE), NoneEndEventOutputMappingTest.mapping(b -> b.zeebeOutputExpression("time(x)", "y")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("y", A_LOCAL_TIME_VALUE))}, {"{'x': %s}".formatted(A_DATE_VALUE), NoneEndEventOutputMappingTest.mapping(b -> b.zeebeOutputExpression("date(x)", "y")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("y", A_DATE_VALUE))}, {"{'x': %s}".formatted(A_LOCAL_DATE_AND_TIME_VALUE), NoneEndEventOutputMappingTest.mapping(b -> b.zeebeOutputExpression("date and time(x)", "y")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("y", A_LOCAL_DATE_AND_TIME_VALUE))}, {"{'x': %s}".formatted(A_DATE_AND_TIME_VALUE), NoneEndEventOutputMappingTest.mapping(b -> b.zeebeOutputExpression("date and time(x)", "y")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("y", A_DATE_AND_TIME_VALUE))}, {"{'x': %s}".formatted(A_DAY_TIME_DURATION_VALUE), NoneEndEventOutputMappingTest.mapping(b -> b.zeebeOutputExpression("duration(x)", "y")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("y", A_DAY_TIME_DURATION_VALUE))}, {"{'x': %s}".formatted(A_YEAR_MONTH_DURATION_VALUE), NoneEndEventOutputMappingTest.mapping(b -> b.zeebeOutputExpression("duration(x)", "y")), NoneEndEventOutputMappingTest.scopeVariables(VariableValue.variable("y", A_YEAR_MONTH_DURATION_VALUE))}};
    }

    @Test
    public void shouldApplyOutputMappings() {
        ENGINE_RULE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent("end", builder -> this.mappings.accept((EndEventBuilder)builder)).done()).deploy();
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(this.initialVariables).create();
        long endEventActivatePosition = ((Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("end").limit(1L)).getFirst()).getPosition();
        ((AbstractListAssert)Assertions.assertThat((Stream)((VariableRecordStream)RecordingExporter.variableRecords().withProcessInstanceKey(processInstanceKey).skipUntil(r -> r.getPosition() > endEventActivatePosition)).withScopeKey(processInstanceKey).limit((long)this.expectedScopeVariables.size())).extracting(Record::getValue).extracting(v -> VariableValue.variable(v.getName(), v.getValue())).hasSameSizeAs(this.expectedScopeVariables)).containsAll(this.expectedScopeVariables);
    }

    private static Consumer<ZeebeVariablesMappingBuilder<EndEventBuilder>> mapping(Consumer<ZeebeVariablesMappingBuilder<EndEventBuilder>> mappingBuilder) {
        return mappingBuilder;
    }

    private static List<VariableValue> scopeVariables(VariableValue ... variables) {
        return Arrays.asList(variables);
    }
}

