/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.variable.mapping;

import io.camunda.zeebe.el.EvaluationResult;
import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.ExpressionLanguageFactory;
import io.camunda.zeebe.el.ResultType;
import io.camunda.zeebe.engine.processing.bpmn.clock.ZeebeFeelEngineClock;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.VariableMappingTransformer;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeMapping;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.test.util.MsgPackUtil;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.feel.FeelEngineClock;
import org.junit.Test;

public final class VariableMappingTransformerTest {
    private final VariableMappingTransformer transformer = new VariableMappingTransformer();
    private final ExpressionLanguage expressionLanguage = ExpressionLanguageFactory.createExpressionLanguage((FeelEngineClock)new ZeebeFeelEngineClock(ActorClock.current()));

    @Test
    public void shouldCreateValidExpression() {
        Expression expression = this.transformer.transformInputMappings(List.of(VariableMappingTransformerTest.mapping("x", "a"), VariableMappingTransformerTest.mapping("_x", "b")), this.expressionLanguage);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)expression.isValid()).describedAs("Expected valid expression: %s", new Object[]{expression.getFailureMessage()})).isTrue();
    }

    @Test
    public void shouldEvaluateToObject() {
        Expression expression = this.transformer.transformInputMappings(List.of(VariableMappingTransformerTest.mapping("x", "a")), this.expressionLanguage);
        EvaluationResult result = this.expressionLanguage.evaluateExpression(expression, name -> MsgPackUtil.asMsgPack((String)"1"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.isFailure()).describedAs("Expected valid result: %s", new Object[]{expression.getFailureMessage()})).isFalse();
        Assertions.assertThat((Comparable)result.getType()).isEqualTo((Object)ResultType.OBJECT);
    }

    @Test
    public void failToTransformWithInvalidSourceExpression() {
        List<ZeebeMapping> mappings = List.of(VariableMappingTransformerTest.mapping("=x?", "a"));
        Assertions.assertThatThrownBy(() -> this.transformer.transformInputMappings((Collection)mappings, this.expressionLanguage)).hasMessageStartingWith("Failed to build variable mapping expression: failed to parse expression '{a:x?}'");
    }

    @Test
    public void failToTransformWithInvalidTargetExpression() {
        List<ZeebeMapping> mappings = List.of(VariableMappingTransformerTest.mapping("=x", "a,"));
        Assertions.assertThatThrownBy(() -> this.transformer.transformInputMappings((Collection)mappings, this.expressionLanguage)).hasMessageStartingWith("Failed to build variable mapping expression: failed to parse expression '{a,:x}'");
    }

    @Test
    public void shouldEvaluateWithNotExistingVariable() {
        List<ZeebeMapping> mappings = List.of(VariableMappingTransformerTest.mapping("=x", "a"));
        Expression expression = this.transformer.transformInputMappings(mappings, this.expressionLanguage);
        EvaluationResult result = this.expressionLanguage.evaluateExpression(expression, name -> null);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.isFailure()).describedAs("Expected valid result: %s", new Object[]{expression.getFailureMessage()})).isFalse();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)result.getType()).describedAs("Expected to replace a non-existing variable with `null`", new Object[0])).isEqualTo((Object)ResultType.OBJECT);
    }

    @Test
    public void shouldNotEscapeCharactersInStaticExpression() {
        Expression expression = this.transformer.transformInputMappings(List.of(VariableMappingTransformerTest.mapping("Hello\tWorld", "tab"), VariableMappingTransformerTest.mapping("Hello\nWorld", "newline"), VariableMappingTransformerTest.mapping("Hello\rWorld", "carriageReturn"), VariableMappingTransformerTest.mapping("\"My Name is \"Zeebe\", nice to meet you\"", "doubleQoutes"), VariableMappingTransformerTest.mapping("My Name is &#34;Zeebe&#34;, nice to meet you", "encodedQuotes")), this.expressionLanguage);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)expression.isValid()).describedAs("Expected valid expression: %s", new Object[]{expression.getFailureMessage()})).isTrue();
        Assertions.assertThat((String)expression.getExpression()).isEqualTo("{tab:\"Hello\tWorld\",newline:\"Hello\nWorld\",carriageReturn:\"Hello\rWorld\",doubleQoutes:\"\\\"My Name is \\\"Zeebe\\\", nice to meet you\\\"\",encodedQuotes:\"My Name is &#34;Zeebe&#34;, nice to meet you\"}");
    }

    private static ZeebeMapping mapping(final String source, final String target) {
        return new ZeebeMapping(){

            public String getSource() {
                return source;
            }

            public String getTarget() {
                return target;
            }

            public String toString() {
                return source + " -> " + target;
            }
        };
    }
}

